/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterCodes;
import com.dataiku.dip.cluster.ClusterHandler;
import com.dataiku.dip.cluster.ClusterMeta;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.PythonPluginClusterHandler;
import com.dataiku.dip.containers.exec.KubernetesClusterService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.DirectoryFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClustersService {
    private static final String CLUSTERS_FOLDER_NAME = "clusters";
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private ScenarioRunsService scenarioRunsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private KubernetesClusterService kubernetesClusterService;
    static Logger logger = Logger.getLogger((String)"dip.clusters");

    public static File getClusterFolder(String clusterId) {
        return ApplicationConfigurator.getFile((String[])new String[]{CLUSTERS_FOLDER_NAME, clusterId});
    }

    public static File getClusterExecFolder(String clusterId) {
        return new File(ClustersService.getClusterFolder(clusterId), "exec");
    }

    public static File getClusterLogFolder(String clusterId) {
        return new File(ClustersService.getClusterFolder(clusterId), "log");
    }

    public List<Cluster> listUnsafe() throws Exception {
        return this.clustersDAO.listUnsafe();
    }

    public Cluster getMandatoryUnsafe(String clusterId) throws Exception {
        return this.clustersDAO.getMandatoryUnsafe(clusterId);
    }

    public Cluster getOrNullUnsafe(String clusterId) throws Exception {
        return this.clustersDAO.getOrNullUnsafe(clusterId);
    }

    public Cluster delete(String clusterId) throws Exception {
        Cluster cluster = this.clustersDAO.getMandatoryUnsafe(clusterId);
        this.clustersDAO.delete(clusterId);
        File clusterFolder = ClustersService.getClusterFolder(clusterId);
        DKUFileUtils.forceDelete((File)clusterFolder);
        return cluster;
    }

    public Cluster create(AuthCtx authCtx, Cluster cluster) throws Exception {
        if (StringUtils.isBlank((String)cluster.name)) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INCOMPLETE_CONFIG, "The cluster must have a name");
        }
        if (StringUtils.isBlank((String)cluster.type)) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INCOMPLETE_CONFIG, "The cluster must have a type");
        }
        if (!ClusterRegistry.hasMeta(cluster.type)) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_UNKNOWN_TYPE, "The cluster type is not registered");
        }
        ClusterMeta meta = ClusterRegistry.getMeta(cluster.type);
        if (meta instanceof PythonPluginClusterHandler.PythonPluginClusterMeta) {
            cluster.architecture = ((PythonPluginClusterHandler.PythonPluginClusterMeta)meta).getDesc().desc.architecture;
        }
        if (cluster.architecture == Cluster.ClusterArchitecture.KUBERNETES && !Pattern.matches("^[a-zA-Z0-9-]+$", cluster.name)) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_CONFIG, "The cluster name is not valid for Kubernetes (must conform to [a-zA-Z0-9-]+ )");
        }
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (Cluster existing : this.clustersDAO.listUnsafe()) {
            st2.addAlreadyTransmogrified(existing.id);
        }
        String slug = cluster.name.replaceAll("[^A-z0-9\\-_\\.]", "_");
        cluster.id = st2.transmogrify(slug);
        cluster.owner = authCtx.getIdentifier();
        cluster.encryptFields(this.cryptoService);
        this.clustersDAO.save(cluster);
        File clusterExecFolder = ClustersService.getClusterExecFolder(cluster.id);
        File clusterLogFolder = ClustersService.getClusterLogFolder(cluster.id);
        DKUFileUtils.mkdirs((File)clusterExecFolder);
        DKUFileUtils.mkdirs((File)clusterLogFolder);
        return cluster;
    }

    public Cluster saveFromUser(Cluster cluster, boolean mayUpdatePermissions) throws Exception {
        Cluster existing = this.clustersDAO.getMandatory(cluster.id);
        if (!StringUtils.equals((String)cluster.type, (String)existing.type)) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_PROPERTY_CHANGE, "The cluster type cannot be changed");
        }
        if (cluster.architecture != existing.architecture) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_PROPERTY_CHANGE, "The cluster architecture cannot be changed");
        }
        if (existing.state != Cluster.ClusterState.NONE && !JSON.jsonObjectEquals((JsonObject)JSON.toJsonObject((Object)existing.params), (JsonObject)JSON.toJsonObject((Object)cluster.params))) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_PROPERTY_CHANGE, "The setup of a running cluster cannot be modified");
        }
        if (!mayUpdatePermissions) {
            if (existing.usableByAll != cluster.usableByAll) {
                throw new DKUSecurityException("You may not update permissions");
            }
            if (!existing.owner.equals(cluster.owner)) {
                throw new DKUSecurityException("You may not update permissions");
            }
            if (!JSON.jsonEquals(existing.permissions, cluster.permissions)) {
                throw new DKUSecurityException("You may not update permissions");
            }
        }
        cluster = ClusterRegistry.getMeta(cluster).prepareForSaveFromUser(cluster, existing);
        cluster.encryptFields(this.cryptoService);
        this.clustersDAO.save(cluster);
        return cluster;
    }

    public FutureResponse<Cluster> start(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster) throws Exception {
        if (cluster.state != Cluster.ClusterState.NONE) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_STATE, "Cannot start a cluster in " + String.valueOf((Object)cluster.state) + " state");
        }
        ClusterStartThread ft = new ClusterStartThread(authCtx, projectKey, cluster, this.transactionService, this.clustersDAO, this.cryptoService, this.kubernetesClusterService);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<Cluster>>(){});
    }

    public FutureResponse<Cluster> stop(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster, boolean terminate, boolean forceStop) throws Exception {
        if (cluster.state != Cluster.ClusterState.RUNNING) {
            if (forceStop) {
                logger.info((Object)("Attempting to force stop a cluster that is in " + String.valueOf((Object)cluster.state) + " state"));
            } else {
                throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_STATE, "Cannot stop a cluster in " + String.valueOf((Object)cluster.state) + " state");
            }
        }
        ClusterStopThread ft = new ClusterStopThread(authCtx, projectKey, cluster, terminate, this.transactionService, this, this.clustersDAO, this.cryptoService);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<Cluster>>(){});
    }

    public Cluster markStopped(AuthCtx authCtx, Cluster cluster) throws Exception {
        if (cluster.state != Cluster.ClusterState.RUNNING) {
            throw new CodedException((InfoMessage.MessageCode)ClusterCodes.ERR_CLUSTER_INVALID_STATE, "Cannot mark as stopped a cluster in " + String.valueOf((Object)cluster.state) + " state");
        }
        cluster.state = Cluster.ClusterState.NONE;
        cluster.encryptFields(this.cryptoService);
        this.clustersDAO.save(cluster);
        return cluster;
    }

    public ClusterStatus getStatus(String clusterId) throws Exception {
        Cluster cluster = this.clustersDAO.getMandatory(clusterId);
        ClusterStatus status = new ClusterStatus();
        ClusterSelector selector = new ClusterSelector();
        for (String projectKey : this.listProjectKeys()) {
            String using = selector.getClusterForProject(projectKey, cluster.architecture);
            if (!clusterId.equals(using)) continue;
            status.usages.add(new ClusterUsage(projectKey));
        }
        for (ScenarioRun scenarioRun : this.scenarioRunsService.getAllClusterUsages(clusterId)) {
            status.usages.add(new ClusterUsage(scenarioRun.getScenario().getProjectKey(), scenarioRun.getScenario().getId(), scenarioRun.getRunId()));
        }
        status.state = cluster.state;
        status.clusterType = cluster.type;
        return status;
    }

    public void collectUsageCounts(List<ClusterHeadItem> clusters) throws Exception {
        HashMap clustersById = Maps.newHashMap();
        for (ClusterHeadItem cluster : clusters) {
            clustersById.put(cluster.id, cluster);
        }
        ClusterSelector selector = new ClusterSelector();
        for (String string : this.listProjectKeys()) {
            for (Cluster.ClusterArchitecture architecture : Cluster.ClusterArchitecture.values()) {
                String using = selector.getClusterForProject(string, architecture);
                if (!clustersById.containsKey(using)) continue;
                ++((ClusterHeadItem)clustersById.get((Object)using)).usedInProjects;
            }
        }
        for (Map.Entry entry : this.scenarioRunsService.getAllClustersUsages().entrySet()) {
            if (!clustersById.containsKey(entry.getKey())) continue;
            ++((ClusterHeadItem)clustersById.get(entry.getKey())).usedInScenarios;
        }
    }

    private List<String> listProjectKeys() throws IOException {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.projects.listKeys");){
            TransactionRef t = TransactionContext.retrieveRead();
            ArrayList<String> ret = new ArrayList<String>();
            for (RelFile projectFolder : t.listFiles(ProjectsDAO.projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json"))) {
                String projectKey = projectFolder.getLeafName();
                ret.add(projectKey);
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    public List<LogsService.LogDesc> listLogs(String clusterId) {
        ArrayList logs = Lists.newArrayList();
        File logsFolder = ClustersService.getClusterLogFolder(clusterId);
        if (logsFolder.exists() && logsFolder.isDirectory()) {
            for (File logFile : logsFolder.listFiles()) {
                logs.add(new LogsService.LogDesc(logFile, logsFolder));
            }
        }
        return logs;
    }

    public SmartLogTail getLog(String clusterId, String logName) throws IOException {
        File logsFolder = ClustersService.getClusterLogFolder(clusterId);
        File logFile = DKUFileUtils.getWithin((File)logsFolder, (String[])new String[]{logName});
        if (logFile.exists() && logFile.isFile()) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file doesn't exist");
    }

    public void streamLog(String clusterId, String logName, OutputStream os) throws IOException {
        block11: {
            File logsFolder = ClustersService.getClusterLogFolder(clusterId);
            File logFile = DKUFileUtils.getWithin((File)logsFolder, (String[])new String[]{logName});
            if (logFile.exists() && logFile.isFile()) {
                logger.info((Object)"Start compressed stream");
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file doesn't exist");
        }
    }

    private static class ClusterStartThread
    extends SimpleFutureThread<Cluster> {
        private final String projectKey;
        private final Cluster cluster;
        private final FuturePayload futurePayload;
        private final TransactionService transactionService;
        private final ClustersDAO clustersDAO;
        private final PasswordEncryptionService cryptoService;
        private final KubernetesClusterService kubernetesClusterService;
        private final Pattern k8sVersionPattern = Pattern.compile("([0-9]+)");
        private ClusterHandler handler;

        private ClusterStartThread(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster, TransactionService transactionService, ClustersDAO clustersDAO, PasswordEncryptionService cryptoService, KubernetesClusterService kubernetesClusterService) {
            super(authCtx);
            this.projectKey = projectKey;
            this.cluster = cluster;
            this.transactionService = transactionService;
            this.clustersDAO = clustersDAO;
            this.cryptoService = cryptoService;
            this.kubernetesClusterService = kubernetesClusterService;
            this.futurePayload = FuturePayload.newSimple((String)"start_cluster", (String)("Start cluster " + cluster.name));
        }

        @Override
        protected Cluster compute() throws Exception {
            Cluster started = (Cluster)JSON.deepCopy((Object)this.cluster);
            this.handler = ClusterRegistry.buildHandler(this.owner, this.projectKey, started);
            this.handler.start();
            if (started.architecture == Cluster.ClusterArchitecture.KUBERNETES) {
                this.saveInitialK8sVersion(started);
            }
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                started.encryptFields(this.cryptoService);
                this.clustersDAO.save(started);
                t.commit("Started cluster " + started.name);
            }
            return started;
        }

        private void saveInitialK8sVersion(Cluster started) {
            try {
                KubernetesClusterService.KubectlVersionsResponse versionsResponse = this.kubernetesClusterService.getVersions(started);
                if (versionsResponse == null || versionsResponse.serverVersion == null) {
                    logger.warn((Object)("Couldn't retrieve the k8s version from kubectl version for the cluster '" + started.id + "'."));
                    return;
                }
                Matcher matcher = this.k8sVersionPattern.matcher(versionsResponse.serverVersion.minor);
                int minor = 0;
                while (matcher.find()) {
                    minor = Integer.parseInt(matcher.group(1));
                }
                String k8sVersion = versionsResponse.serverVersion.major + "." + minor;
                logger.debug((Object)("The cluster '" + started.id + "' k8s version is '" + k8sVersion + "'."));
                started.containerSettings.executionConfigsGenericOverrides.properties.add(new SimpleKeyValue("kubernetes.initial.version", k8sVersion));
            }
            catch (Exception e) {
                logger.warn((Object)("Could not retrieve the cluster '" + started.id + "' k8s version."), (Throwable)e);
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SmartLogTail getLog() {
            return this.handler != null && this.handler instanceof PythonPluginClusterHandler ? ((PythonPluginClusterHandler)this.handler).getLogTail() : null;
        }
    }

    private static class ClusterStopThread
    extends SimpleFutureThread<Cluster> {
        private final String projectKey;
        private final Cluster cluster;
        private final FuturePayload futurePayload;
        private final TransactionService transactionService;
        private final ClustersService clustersService;
        private final ClustersDAO clustersDAO;
        private final PasswordEncryptionService cryptoService;
        private final boolean terminate;
        private ClusterHandler handler;

        private ClusterStopThread(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster, boolean terminate, TransactionService transactionService, ClustersService clustersService, ClustersDAO clustersDAO, PasswordEncryptionService cryptoService) {
            super(authCtx);
            this.projectKey = projectKey;
            this.cluster = cluster;
            this.terminate = terminate;
            this.transactionService = transactionService;
            this.clustersService = clustersService;
            this.clustersDAO = clustersDAO;
            this.cryptoService = cryptoService;
            this.futurePayload = FuturePayload.newSimple((String)"Stop_cluster", (String)("Stop cluster " + cluster.name));
        }

        @Override
        protected Cluster compute() throws Exception {
            this.handler = ClusterRegistry.buildHandler(this.owner, this.projectKey, this.cluster);
            this.handler.stop();
            if (this.terminate) {
                try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                    this.clustersService.delete(this.cluster.id);
                    t.commit("Stopped cluster " + this.cluster.name);
                }
            }
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                this.cluster.encryptFields(this.cryptoService);
                this.clustersDAO.save(this.cluster);
                t.commit("Stopped cluster " + this.cluster.name);
            }
            return this.cluster;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SmartLogTail getLog() {
            return this.handler != null && this.handler instanceof PythonPluginClusterHandler ? ((PythonPluginClusterHandler)this.handler).getLogTail() : null;
        }
    }

    public static class ClusterStatus {
        public Cluster.ClusterState state;
        public List<ClusterUsage> usages = Lists.newArrayList();
        public String clusterType;
        public int otherProjectUsagesCount;
        public int otherScenarioUsagesCount;
        public SerializedError error;
    }

    public static class ClusterUsage {
        public String projectKey;
        public String scenarioId;
        public String scenarioProjectKey;
        public String scenarioRunId;

        public ClusterUsage(String projectKey) {
            this.projectKey = projectKey;
        }

        public ClusterUsage(String scenarioProjectKey, String scenarioId, String scenarioRunId) {
            this.scenarioProjectKey = scenarioProjectKey;
            this.scenarioId = scenarioId;
            this.scenarioRunId = scenarioRunId;
        }
    }

    public static class ClusterHeadItem
    implements PrivilegeFiller {
        public String id;
        public String name;
        public String owner;
        public String type;
        public Cluster.ClusterArchitecture architecture;
        public Cluster.ClusterState state;
        public int usedInScenarios;
        public int usedInProjects;
        public Boolean canUpdateCluster;
        public Boolean canManageUsersCluster;

        public ClusterHeadItem(Cluster cluster) {
            this.id = cluster.id;
            this.name = cluster.name;
            this.type = cluster.type;
            this.owner = cluster.owner;
            this.state = cluster.state;
            this.architecture = cluster.architecture;
        }

        @Override
        public void fillPrivilegeInfo(IPermissionsService permissionsService, AuthCtx authCtx) throws DKUSecurityException {
            this.canUpdateCluster = permissionsService.hasClusterPrivilege(authCtx, this.id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            this.canManageUsersCluster = permissionsService.hasClusterPrivilege(authCtx, this.id, Privileges.ClusterLevelPrivilegeType.MANAGE_USERS);
        }
    }

    public static class ClusterItem
    extends Cluster
    implements PrivilegeFiller {
        public Boolean canUpdateCluster;
        public Boolean canManageUsersCluster;

        public ClusterItem(Cluster cluster) {
            super(cluster);
        }

        @Override
        public void fillPrivilegeInfo(IPermissionsService permissionsService, AuthCtx authCtx) throws DKUSecurityException {
            this.canUpdateCluster = permissionsService.hasClusterPrivilege(authCtx, this.id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            this.canManageUsersCluster = permissionsService.hasClusterPrivilege(authCtx, this.id, Privileges.ClusterLevelPrivilegeType.MANAGE_USERS);
        }
    }

    public static interface PrivilegeFiller {
        public void fillPrivilegeInfo(IPermissionsService var1, AuthCtx var2) throws DKUSecurityException;
    }
}

