/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvLanguages;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public class AutomationNodeManagedEnvUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.code-envs");

    private AutomationNodeManagedEnvUtils() {
    }

    private static File getEnvLinksDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "links"});
    }

    private static File getEnvLinkFile(CodeEnvModel.EnvLang envLang, String envName, String linkName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "links", linkName});
    }

    public static File getEnvVersionDir(CodeEnvModel.EnvLang envLang, String envName, @Nonnull String version) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "versions", version});
    }

    public static File getEnvDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
    }

    public static <T> T getEnvDesc(File envRootDir, Class<T> clazz) throws IOException {
        return (T)JSON.parseFile((File)DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc", "desc.json"}), clazz);
    }

    @ParametersAreNonnullByDefault
    public static CodeEnvModel.AbstractEnvDesc getEnvDesc(CodeEnvModel.EnvLang envLang, String envName, Optional<String> envVersionIdOptional) throws IOException {
        File envDir = envVersionIdOptional.map(envVersionId -> AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, envVersionId)).orElseGet(() -> AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName));
        return (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"desc", "desc.json"}), envLang.getDescClazz());
    }

    public static void writeEnvDesc(File envRootDir, CodeEnvModel.PythonEnvDesc envDesc) throws IOException {
        JSON.prettyToFile((Object)envDesc, (File)DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc", "desc.json"}));
    }

    public static String getBundleSuffix(String projectKey, String bundleId) {
        return "bundle-" + projectKey + "-" + bundleId;
    }

    public static CodeEnvModel.EnvVersionRef getNamedBundleLink(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId) throws IOException {
        File linkFile = AutomationNodeManagedEnvUtils.getEnvLinkFile(envLang, envName, AutomationNodeManagedEnvUtils.getBundleSuffix(projectKey, bundleId));
        if (linkFile.exists()) {
            CodeEnvModel.EnvVersionRef evr = new CodeEnvModel.EnvVersionRef();
            evr.envName = envName;
            evr.envVersion = linkFile.getCanonicalFile().getName();
            return evr;
        }
        return null;
    }

    public static void linkBundle(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String version) throws IOException, InterruptedException {
        DKUFileUtils.mkdirs((File)AutomationNodeManagedEnvUtils.getEnvLinksDir(envLang, envName));
        File linkSrc = AutomationNodeManagedEnvUtils.getEnvLinkFile(envLang, envName, AutomationNodeManagedEnvUtils.getBundleSuffix(projectKey, bundleId));
        File linkTgt = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, version);
        DKUFileUtils.forceCreateSymbolicLink((Path)linkSrc.toPath(), (Path)linkTgt.toPath());
    }

    public static Pair<String, String> readProjectKeyBundleFromLink(String link) {
        String projectKeyBundle = link.substring("bundle-".length());
        int split = projectKeyBundle.indexOf(45);
        String projectKey = projectKeyBundle.substring(0, split);
        String bundleId = projectKeyBundle.substring(split + 1);
        return new Pair((Object)projectKey, (Object)bundleId);
    }

    public static List<String> listBundleLink(CodeEnvModel.EnvLang envLang, String envName, String version) throws IOException, InterruptedException {
        ArrayList links = Lists.newArrayList();
        File envLinksDir = AutomationNodeManagedEnvUtils.getEnvLinksDir(envLang, envName);
        if (envLinksDir.exists()) {
            File versionTgt = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, version);
            for (File f : envLinksDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("bundle-");
                }
            })) {
                Path tgt = Files.readSymbolicLink(f.toPath());
                if (!versionTgt.toPath().equals(tgt)) continue;
                links.add(f.getName());
            }
        }
        return links;
    }

    public static void addResourcesEnvVariablesToJupyterKernelForVersionedEnv(CodeEnvModel.EnvLang envLang, String envName, String version, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean forceAdd) {
        try {
            if (envLang != CodeEnvModel.EnvLang.PYTHON) {
                return;
            }
            for (String link : AutomationNodeManagedEnvUtils.listBundleLink(envLang, envName, version)) {
                Pair<String, String> projectKeyBundle = AutomationNodeManagedEnvUtils.readProjectKeyBundleFromLink(link);
                String projectKey = (String)projectKeyBundle.first;
                String bundleId = (String)projectKeyBundle.second;
                AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, version, projectKey, bundleId, tailBuilder, log, forceAdd);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add resources environment variables to Jupyter kernel.json", (Throwable)e);
        }
    }

    public static void addResourcesEnvVariablesToJupyterKernelForVersionedEnv(CodeEnvModel.EnvLang envLang, String envName, String version, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean forceAdd) {
        try {
            if (envLang != CodeEnvModel.EnvLang.PYTHON) {
                return;
            }
            File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, version);
            CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(envVersionDir, CodeEnvModel.PythonEnvDesc.class);
            if (!forceAdd && !pydesc.installJupyterSupport) {
                return;
            }
            FileUtils.writeStringToFile((File)log, (String)"Adding resources environment variables to Jupyter kernel.json ...", (Charset)StandardCharsets.UTF_8, (boolean)true);
            tailBuilder.appendLine("Adding resources environment variables to Jupyter kernel.json ...");
            File resourcesEnvFile = ApplicationConfigurator.getFile((File)envVersionDir, (String[])new String[]{"desc", "actual", "resources_env.json"});
            if (resourcesEnvFile.exists()) {
                CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                CodeEnvLanguages.addEnvToKernel(JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId, null), resourcesEnvVariables.resolve(ApplicationConfigurator.getFile((File)envVersionDir, (String[])new String[]{"resources"})));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add resources environment variables to Jupyter kernel.json", (Throwable)e);
        }
    }

    public static void addResourcesEnvVariablesToJupyterKernelForNonVersionedEnv(CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean forceAdd) {
        try {
            if (envLang != CodeEnvModel.EnvLang.PYTHON) {
                return;
            }
            File envDir = AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName);
            CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(envDir, CodeEnvModel.PythonEnvDesc.class);
            if (!forceAdd && !pydesc.installJupyterSupport) {
                return;
            }
            FileUtils.writeStringToFile((File)log, (String)"Adding resources environment variables to Jupyter kernel.json ...", (Charset)StandardCharsets.UTF_8, (boolean)true);
            tailBuilder.appendLine("Adding resources environment variables to Jupyter kernel.json ...");
            File resourcesEnvFile = ApplicationConfigurator.getFile((File)envDir, (String[])new String[]{"desc", "actual", "resources_env.json"});
            if (resourcesEnvFile.exists()) {
                CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                CodeEnvLanguages.addEnvToKernel(JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, null, null, null), resourcesEnvVariables.resolve(ApplicationConfigurator.getFile((File)envDir, (String[])new String[]{"resources"})));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add resources environment variables to Jupyter kernel.json", (Throwable)e);
        }
    }

    public static void installJupyterSupportForVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, String version, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean onlyIfNeeded) throws IOException, InterruptedException {
        for (String link : AutomationNodeManagedEnvUtils.listBundleLink(envLang, envName, version)) {
            Pair<String, String> projectKeyBundle = AutomationNodeManagedEnvUtils.readProjectKeyBundleFromLink(link);
            String projectKey = (String)projectKeyBundle.first;
            String bundleId = (String)projectKeyBundle.second;
            AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(authCtx, envLang, envName, version, projectKey, bundleId, tailBuilder, log, onlyIfNeeded);
        }
    }

    public static void installJupyterSupportForVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, String version, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean onlyIfNeeded) throws IOException, InterruptedException {
        File rootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, version);
        switch (envLang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                if (onlyIfNeeded && !pydesc.installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, pydesc, envName, projectKey, bundleId, tailBuilder, log, pydesc.yarnPythonBin);
                break;
            }
            case R: {
                CodeEnvModel.REnvDesc rdesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.REnvDesc.class);
                if (onlyIfNeeded && !rdesc.installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.R, rdesc, envName, projectKey, bundleId, tailBuilder, log, rdesc.yarnRBin);
            }
        }
    }

    public static void installJupyterSupportForNonVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean onlyIfNeeded) throws IOException, InterruptedException {
        File rootDir = AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                if (onlyIfNeeded && !pydesc.installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, pydesc, envName, null, null, tailBuilder, log, pydesc.yarnPythonBin);
                break;
            }
            case R: {
                CodeEnvModel.REnvDesc rdesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.REnvDesc.class);
                if (onlyIfNeeded && !rdesc.installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.R, rdesc, envName, null, null, tailBuilder, log, rdesc.yarnRBin);
            }
        }
    }

    public static void removeJupyterSupportForVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, String version, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException, InterruptedException {
        File rootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, version);
        for (String link : AutomationNodeManagedEnvUtils.listBundleLink(envLang, envName, version)) {
            Pair<String, String> projectKeyBundle = AutomationNodeManagedEnvUtils.readProjectKeyBundleFromLink(link);
            String projectKey = (String)projectKeyBundle.first;
            String bundleId = (String)projectKeyBundle.second;
            switch (envLang) {
                case PYTHON: {
                    CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                    CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, pydesc, envName, projectKey, bundleId, tailBuilder, log);
                    break;
                }
                case R: {
                    CodeEnvModel.REnvDesc rdesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.REnvDesc.class);
                    CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.R, rdesc, envName, projectKey, bundleId, tailBuilder, log);
                }
            }
        }
    }

    public static void removeJupyterSupportForNonVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException, InterruptedException {
        File rootDir = AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvDesc pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, pydesc, envName, null, null, tailBuilder, log);
                break;
            }
            case R: {
                CodeEnvModel.REnvDesc rdesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.REnvDesc.class);
                CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.R, rdesc, envName, null, null, tailBuilder, log);
            }
        }
    }
}

