/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class AWSCredentialsProviders {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.aws.provider");

    public static class SerializableAWSCredentialHadoopProvider
    implements AwsCredentialsProvider,
    AWSCredentialsProvider {
        private ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = new ConnectionWithAWSAuthCredentials.SerializableAWSCredential();
        private CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo;
        private String connectionName;
        private String projectKey;

        public SerializableAWSCredentialHadoopProvider(URI uri, Configuration conf) {
            this.cred.accessKey = conf.get("fs.s3a.access.key", null);
            this.cred.secretKey = conf.get("fs.s3a.secret.key", null);
            this.cred.sessionToken = conf.get("fs.s3a.session.token", null);
            this.cred.expirationTime = Long.parseLong(conf.get("fs.s3a.session.expirationTime", "0"));
            if (this.cred.accessKey == null || this.cred.secretKey == null || this.cred.sessionToken == null) {
                throw new IllegalArgumentException("Credentials not found");
            }
            String fetchInfoJson = conf.get("fs.s3a.dku.fetchInfo", null);
            if (fetchInfoJson == null) {
                throw new IllegalArgumentException("Fetch info not found");
            }
            this.fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoJson, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            this.connectionName = conf.get("fs.s3a.dku.connectionName", null);
            if (this.connectionName == null) {
                throw new IllegalArgumentException("Connection name not found");
            }
            this.projectKey = conf.get("fs.s3a.dku.projectKey", "__DKU_ANY_PROJECT__");
        }

        public AwsCredentials resolveCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentials();
        }

        @Override
        public AWSCredentials getCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentialsUnshadedSDK1();
        }

        @Override
        public void refresh() {
            try {
                this.cred = CredentialsRemoteFetchConfigurationProvider.getFromRemote(this.fetchInfo, "/connections/get-fully-resolved-credentials", ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class, "name", this.connectionName, "projectKey", this.projectKey, "useTokenCache", false);
            }
            catch (IOException e) {
                throw SdkException.create((String)"Unable to refresh STS token", (Throwable)e);
            }
        }
    }

    public static class SerializableAWSCredentialProvider
    implements AwsCredentialsProvider {
        private final AuthCtx authCtx;
        private final ConnectionWithAWSAuthCredentials conn;
        private ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred;

        public SerializableAWSCredentialProvider(AuthCtx authCtx, ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred, ConnectionWithAWSAuthCredentials conn) {
            this.authCtx = authCtx;
            this.cred = cred;
            this.conn = conn;
        }

        public AwsCredentials resolveCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentials();
        }

        public void refresh() {
            try {
                this.cred = ((DSSConnection)((Object)this.conn)).getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            }
            catch (DKUSecurityException | IOException e) {
                throw SdkException.create((String)"Unable to refresh STS token", (Throwable)e);
            }
        }
    }
}

