/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class HDFSConnection
extends DSSConnection
implements HDFSAbleConnection,
FSProviderizableConnection,
ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "HDFS";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allowManagedDatasets() {
        return this.allowManagedDatasets;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.root = vc.expand(this.params.root);
    }

    public String getUnresolvedRootForDisplayOnly() {
        return this.params.root;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(RootAndExtraConf.class));
        RootAndExtraConf creds = this.getRootAndExtraConf(ctx.authCtx, ctx.projectKey);
        return clazz.cast(creds);
    }

    private RootAndExtraConf getRootAndExtraConf(AuthCtx authCtx, String projectKey) {
        RootAndExtraConf ret = this.getUnresolvedRootAndExtraConf(authCtx, projectKey);
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        for (AbstractSQLConnection.CustomDatabaseProperty prop : ret.extraConf) {
            if (!prop.secret) continue;
            prop.value = cryptoService.decryptIfEncrypted(prop.value);
        }
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForConnectionAndProjectAndUser(this, authCtx, projectKey);
        ret.root = vc.expand(ret.root);
        for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : ret.extraConf) {
            customDatabaseProperty.value = vc.expand(customDatabaseProperty.value);
        }
        return ret;
    }

    public RootAndExtraConf getUnresolvedRootAndExtraConf(AuthCtx authCtx, String projectKey) {
        String root;
        List<AbstractSQLConnection.CustomDatabaseProperty> props;
        RootAndExtraConf ret = new RootAndExtraConf();
        if (StringUtils.isNotBlank((String)this.params.customPropertiesProviderClass)) {
            try {
                Class<?> clazz = Class.forName(this.params.customPropertiesProviderClass);
                HDFSConnectionPropertiesProvider resolver = (HDFSConnectionPropertiesProvider)clazz.newInstance();
                resolver.setConnection(this);
                resolver.setParams(this.params.customPropertiesProviderParams);
                props = resolver.getProperties(this, authCtx, projectKey);
                root = resolver.getRoot(this, authCtx, projectKey);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to resolve connection settings", t);
            }
        } else {
            root = this.params.root;
            props = this.params.extraConf;
        }
        ret.root = root;
        ret.extraConf = Lists.newArrayList(props);
        return ret;
    }

    @Override
    public String getResolvedHDFSRoot(AuthCtx authCtx, String projectKey) {
        return this.getRootAndExtraConf((AuthCtx)authCtx, (String)projectKey).root;
    }

    @Override
    public boolean mayBeSavedAsPersonalConnectionByNonAdmin() {
        return false;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    public Params getParams() {
        return this.params;
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    public boolean hasSecretFields() {
        for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.extraConf) {
            if (!property.secret) continue;
            return true;
        }
        return false;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.extraConf) {
                if (!property.secret) continue;
                property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
            }
        }
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.extraConf) {
            if (!property.secret) continue;
            property.value = cryptoService.decryptIfEncrypted(property.value);
        }
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        throw new NotImplementedException();
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        private String root;
        private List<AbstractSQLConnection.CustomDatabaseProperty> extraConf = Lists.newArrayList();
        public HiveSynchronizationMode hiveSynchronizationMode = HiveSynchronizationMode.KEEP_IN_SYNC;
        public String defaultDatabase;
        public String customPropertiesProviderClass;
        public List<AbstractSQLConnection.CustomDatabaseProperty> customPropertiesProviderParams = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public HDFSManagedDatasetNamingRule namingRule = new HDFSManagedDatasetNamingRule();
        public ACLSynchronizationMode aclSynchronizationMode = ACLSynchronizationMode.SUBDIRECTORY;
        public ClearMode clearMode = ClearMode.DSS_USER;
        public boolean overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes = false;

        public void setRoot(String root) {
            this.root = root;
        }

        public void setExtraConf(List<AbstractSQLConnection.CustomDatabaseProperty> extraConf) {
            this.extraConf = extraConf;
        }
    }

    public static class RootAndExtraConf {
        public String root;
        public List<AbstractSQLConnection.CustomDatabaseProperty> extraConf = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public List<SimpleKeyValue> getExtraConfAsSimpleKeyValue() {
            return this.extraConf.stream().map(AbstractSQLConnection.CustomDatabaseProperty::toSimpleKeyValue).collect(Collectors.toList());
        }
    }

    public static interface HDFSConnectionPropertiesProvider {
        public void setConnection(HDFSConnection var1);

        public void setParams(List<AbstractSQLConnection.CustomDatabaseProperty> var1);

        public String getRoot(HDFSConnection var1, AuthCtx var2, String var3);

        public List<AbstractSQLConnection.CustomDatabaseProperty> getProperties(HDFSConnection var1, AuthCtx var2, String var3);
    }

    public static class HDFSManagedDatasetNamingRule {
        public String hdfsPathDatasetNamePrefix;
        public String hdfsPathDatasetNameSuffix;
        public String tableNameDatasetNamePrefix;
        public String tableNameDatasetNameSuffix;
        public String hiveDatabaseName;
        public String uploadsPathPrefix = "uploads";
    }

    public static enum HiveSynchronizationMode {
        KEEP_IN_SYNC,
        NO_SYNC;

    }

    public static enum ClearMode {
        DSS_USER,
        IMPERSONATED_NO_SETACL;

    }

    public static enum ACLSynchronizationMode {
        NONE,
        SUBDIRECTORY;

    }
}

