/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedCodeStudioObjectsDAO
extends AbstractStandardDAO<CodeStudioObject>
implements CodeStudioObjectsDAO {
    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.CODE_STUDIO.toHumanReadableString();
    }

    @Override
    protected CodeStudioObject getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile codeStudioObjectFile = this.getDAOFile(projectKey, id);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reading codeStudioObject file " + String.valueOf(codeStudioObjectFile)));
        }
        if (!t.isFile(codeStudioObjectFile)) {
            return null;
        }
        CodeStudioObject codeStudioObject = unsafe ? (CodeStudioObject)t.readObjectUnsafe(codeStudioObjectFile, CodeStudioObject.class) : (CodeStudioObject)t.readObject(codeStudioObjectFile, CodeStudioObject.class);
        codeStudioObject.id = id;
        codeStudioObject.projectKey = projectKey;
        return codeStudioObject;
    }

    @Override
    protected List<CodeStudioObject> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<CodeStudioObject> ret = new ArrayList<CodeStudioObject>();
        RelFile codeStudioObjectsFolder = this.getDAOFolder(projectKey);
        if (!t.exists(codeStudioObjectsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(codeStudioObjectsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String codeStudioObjectId = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                CodeStudioObject codeStudioObject = unsafe ? (CodeStudioObject)t.readObjectUnsafe(file, CodeStudioObject.class) : (CodeStudioObject)t.readObject(file, CodeStudioObject.class);
                codeStudioObject.id = codeStudioObjectId;
                codeStudioObject.projectKey = projectKey;
                ret.add(codeStudioObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read codeStudioObject file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile codeStudioObjectsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(codeStudioObjectsFolder = this.getDAOFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(codeStudioObjectsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile codeStudioObjectFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(codeStudioObjectFile = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("CodeStudioObject does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(codeStudioObjectFile);
    }

    private RelFile getDAOFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"CodeStudioObject project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "code_studios"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"CodeStudioObject id is not specified");
        return new RelFile(this.getDAOFolder(projectKey), new String[]{id + ".json"});
    }
}

