/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedDataCollectionsDAO
implements DataCollectionsDAO {
    private static final RelFile DATA_COLLECTIONS_FOLDER = new RelFile(new String[]{"data-collections"});
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datacollections");

    @Override
    public boolean exists(String id) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.exists(FilesBasedDataCollectionsDAO.getDataCollectionsFile(id));
    }

    @Override
    public DataCollection getOrNull(String id, boolean unsafe) throws IOException {
        RelFile f = FilesBasedDataCollectionsDAO.getDataCollectionsFile(id);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f)) {
            return null;
        }
        DataCollection collection = unsafe ? (DataCollection)t.readObjectUnsafe(f, DataCollection.class) : (DataCollection)t.readObject(f, DataCollection.class);
        collection.id = id;
        return collection;
    }

    @Override
    public DataCollection getOrNull(String id) throws IOException {
        return this.getOrNull(id, false);
    }

    @Override
    public DataCollection getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id, true);
    }

    @Override
    public DataCollection getMandatory(String id, boolean unsafe) throws IOException {
        DataCollection dataCollection = this.getOrNull(id, unsafe);
        if (dataCollection == null) {
            throw new NotFoundException("Data collection does not exist: " + id);
        }
        return dataCollection;
    }

    @Override
    public DataCollection getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id, true);
    }

    @Override
    public DataCollection getMandatory(String id) throws IOException {
        return this.getMandatory(id, false);
    }

    @Override
    public void save(DataCollection dataCollection) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(FilesBasedDataCollectionsDAO.getDataCollectionsFile(dataCollection.getId()), (Object)dataCollection);
    }

    @Override
    public List<DataCollection> list() throws IOException {
        return this.list(false);
    }

    @Override
    public List<DataCollection> listUnsafe() throws IOException {
        return this.list(true);
    }

    @Override
    public List<DataCollection> list(boolean unsafe) throws IOException {
        ArrayList<DataCollection> collections = new ArrayList<DataCollection>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(DATA_COLLECTIONS_FOLDER)) {
            return collections;
        }
        for (RelFile rf : t.listFiles(DATA_COLLECTIONS_FOLDER, (RelFileFilter)FileFilter.json())) {
            String fileName = rf.getLeafName();
            if (!StringUtils.endsWith((String)fileName, (String)".json")) {
                logger.error((Object)("Expected a file with .json extension, got '" + fileName + "'. Skipping."));
            }
            collections.add(this.getOrNull(fileName.substring(0, fileName.length() - 5), unsafe));
        }
        return collections;
    }

    @Override
    public void delete(String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(FilesBasedDataCollectionsDAO.getDataCollectionsFile(id));
    }

    private static RelFile getDataCollectionsFile(String id) {
        return new RelFile(DATA_COLLECTIONS_FOLDER, new String[]{id + ".json"});
    }
}

