/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GeoJoinInputsHelper {
    Map<Integer, Set<String>> joinColumnsPerVirtualInput = new HashMap<Integer, Set<String>>();
    Map<Integer, Set<ColumnDesc>> outputColumnsPerVirtualInput = new HashMap<Integer, Set<ColumnDesc>>();
    Map<Integer, GeoJoinRecipePayloadParams.JoinDesc> joinMatrix = new HashMap<Integer, GeoJoinRecipePayloadParams.JoinDesc>();

    public GeoJoinInputsHelper(GeoJoinRecipePayloadParams params) {
        this.buildJoinMatrix(params);
    }

    private void buildJoinMatrix(GeoJoinRecipePayloadParams params) {
        for (GeoJoinRecipePayloadParams.JoinDesc join : params.joins) {
            this.joinColumnsPerVirtualInput.putIfAbsent(join.table1, new HashSet());
            this.joinColumnsPerVirtualInput.putIfAbsent(join.table2, new HashSet());
            this.joinMatrix.put(join.table2, join);
            for (GeoJoinRecipePayloadParams.MatchingCondition condition : join.on) {
                this.joinColumnsPerVirtualInput.get(condition.column1.table).add(condition.column1.name);
                this.joinColumnsPerVirtualInput.get(condition.column2.table).add(condition.column2.name);
            }
        }
        for (ColumnDesc column : params.getSelectedColumns()) {
            this.outputColumnsPerVirtualInput.putIfAbsent(column.table, new HashSet());
            this.outputColumnsPerVirtualInput.get(column.table).add(column);
        }
    }

    public Set<String> outputColumnNames(int virtInputIdx) {
        Set<ColumnDesc> columnDescs = this.outputColumnsPerVirtualInput.get(virtInputIdx);
        if (columnDescs != null) {
            return columnDescs.stream().map(columnDesc -> columnDesc.name).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

