/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifiers;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementSQLGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotSQLGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPivotRecipeSQLlikeExecutor
extends AbstractPivotRecipeExecutor {
    private static final DoubleMeaning doubleMeaning = new DoubleMeaning();
    @Autowired
    protected PivotRecipeService service;
    private static Logger logger = Logger.getLogger((String)"dip.pivot.abstract.sql");

    public AbstractPivotRecipeSQLlikeExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params) {
        super(engine, activity, params);
    }

    protected abstract SQLUtils.SQLTable getSQLTable() throws IOException, SQLException, DKUSecurityException;

    protected String generateSQL(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, SQLDialect dialect) throws IOException, SQLException, DKUSecurityException {
        Partition part;
        List parts;
        PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(this.params, this.inputDS, this.getSQLTable(), this.outputDS);
        List sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, this.params.engineParams) && (parts = this.sourcePartitions) != null && !parts.isEmpty() && !((Partition)parts.get(0)).isAll() && !((Partition)parts.get(0)).isNP() && this.inputDS.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = this.inputDS.getPartitioningSchema();
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(this.outputDS) && (part = this.activity.getSubgraph().getTargetPartition(this.activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && this.outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = this.outputDS.getPartitioningSchema();
        }
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateQuery(this.identifiers, pivotElementsModalities, dialect, false).toSQL(dialect);
    }

    protected abstract SQLDialect getInputDialect() throws IOException, SQLException, DKUSecurityException;

    protected abstract AbstractSQLConnection getInputSQLConnection() throws IOException, SQLException, DKUSecurityException;

    @Override
    protected List<PivotedModality> doCollectModalities(PivotElement pivotElement) throws Exception {
        return this.collectModalities(pivotElement, this.getModalityCollectionQuery(pivotElement));
    }

    protected String getModalityCollectionQuery(PivotElement pivotElement) throws IOException, SQLException, DKUSecurityException {
        SQLDialect dialect = this.getInputDialect();
        PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(this.params, this.inputDS, this.getSQLTable(), this.outputDS);
        QueryGenerationUtils.SelectQueryBuilderAndSchema prepared = sqlGenerator.generateQueryForPivot(dialect);
        PivotElementSQLGenerator pivotSqlGenerator = new PivotElementSQLGenerator(pivotElement, prepared.schema);
        return pivotSqlGenerator.generateValueCollectionQuery(null, prepared.selectQueryBuilder).toSQL(dialect);
    }

    protected List<PivotedModality> collectModalities(PivotElement pivotElement, String sql) throws Exception {
        QueryRunResult queryRunResult;
        QueryBunch queryBunch = new QueryBunch();
        queryBunch.query = sql;
        ArrayList modalities = Lists.newArrayList();
        logger.info((Object)("Collection modalities for pivot element " + JSON.pretty((Object)pivotElement)));
        SQLConnectionProvider.SQLConnectionData connectionData = this.getInputSQLConnection().getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
        final SQLQueryRuntime queryRuntime = new SQLQueryRuntime(queryBunch, connectionData, this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting modality collection query");
                try {
                    queryRuntime.cancel();
                }
                catch (SQLException e) {
                    logger.error((Object)"Failed to abord modality collection query", (Throwable)e);
                }
            }
        });){
            queryRuntime.init(-1);
            queryRunResult = queryRuntime.getPage(0, 100000, null);
        }
        if (!queryRunResult.success) {
            throw new Exception("Modality collection query failed : " + queryRunResult.errorMessage);
        }
        if (queryRunResult.totalRowsClipped) {
            logger.warn((Object)("Clipped the number of modalities, using only the first " + queryRunResult.rows.size() + " ones"));
        }
        boolean valueCountColumnWasLowercased = false;
        for (int i = 0; i < queryRunResult.columns.size(); ++i) {
            String key = queryRunResult.columns.get((int)i).name;
            if (!"_DKU_value_count".equalsIgnoreCase(key)) continue;
            valueCountColumnWasLowercased = !"_DKU_value_count".equals(key);
        }
        HashMap columnIndices = Maps.newHashMap();
        for (int i = 0; i < queryRunResult.columns.size(); ++i) {
            String key = queryRunResult.columns.get((int)i).name;
            String cleanKey = this.cleanupKey(key, valueCountColumnWasLowercased);
            columnIndices.put(cleanKey, i);
        }
        logger.info((Object)("Columns in the result: " + JSON.json((Object)columnIndices)));
        ModalitySlugifier modalitySlugifier = ModalitySlugifiers.getSlugifier(this.params.modalitySlugification);
        for (String[] row : queryRunResult.rows) {
            HashMap keyValues = Maps.newHashMap();
            for (String key : pivotElement.keyColumns) {
                double v;
                Type columnType;
                String cleanKey = this.cleanupKey(key, valueCountColumnWasLowercased);
                Integer columnIndex = (Integer)columnIndices.get(cleanKey);
                String value = row[columnIndex];
                if (StringUtils.isNotBlank((String)value) && (columnType = queryRunResult.columns.get((int)columnIndex.intValue()).dssType) != null && columnType.isNumeric() && columnType.isFloatingPoint() && (v = doubleMeaning.doubleValue(value)) == Math.floor(v)) {
                    value = Long.toString((long)Math.floor(v));
                }
                keyValues.put(key, value);
            }
            PivotedModality modality = PivotedModality.fromModalities(keyValues, pivotElement, modalitySlugifier);
            modalities.add(modality);
        }
        return modalities;
    }

    private String cleanupKey(String key, boolean valueCountColumnWasLowercased) throws IOException, SQLException, DKUSecurityException {
        return this.getInputDialect().hasCaseInsensitiveColumns() || this.lowercaseColumns || valueCountColumnWasLowercased ? key.toLowerCase() : key;
    }
}

