/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.sql.AbstractSQLQueryRecipeRunner;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.google.common.base.Preconditions;

public abstract class NonLoopingNonTransformingSQLEngineVisualRecipeRunner
extends AbstractSQLQueryRecipeRunner
implements InitializableAbortableRecipeRunner {
    public NonLoopingNonTransformingSQLEngineVisualRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        Preconditions.checkArgument((this.subgraph.getTargets().size() == 1 ? 1 : 0) != 0, (Object)"A visual recipe with SQL engine has one output");
        this.mainConnection = NonLoopingNonTransformingSQLEngineVisualRecipeRunner.getMainSingleConnection(this.authCtxService.getAuthCtx(), this.subgraph, this.datasetsDAO);
        this.outputDataset = this.subgraph.getSingleTargetDataset().getMandatory(this.datasetsDAO);
    }

    protected abstract QueryBunch getQueryBunch(AbstractSQLConnection var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        VariablesExpansionLoopItemsIterable veLoopIterable = new VariablesExpansionLoopItemsIterable(this.authCtxService.getAuthCtx(), this.recipeProjectKey, null);
        AbstractSQLConnection conn = SQLConnectionProvider.getDSSConnection(this.authCtxService.getAuthCtx(), this.mainConnection);
        QueryBunch queryBunch = this.getQueryBunch(conn);
        try {
            logger.info((Object)"Running the visual recipe with SQL engine with non-transformed queries");
            Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
            AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)this.outputDataset.getParams();
            this.runFullSQL(this.mainConnection, outputConfig.catalog, outputConfig.schema, outputConfig.table, targetPartition, queryBunch, veLoopIterable);
        }
        finally {
            NonLoopingNonTransformingSQLEngineVisualRecipeRunner nonLoopingNonTransformingSQLEngineVisualRecipeRunner = this;
            synchronized (nonLoopingNonTransformingSQLEngineVisualRecipeRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    @Override
    protected String prepareMainQuery(String outputCatalog, String outputSchema, String outputTable, SQLConnectionProvider.SQLConnectionData connData, String query) {
        return query;
    }
}

