/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class AbtractToVerticaExecutor
extends SISORecipeExecutor
implements Initializable {
    protected SQLConnectionProvider.SQLConnectionData connData;
    protected SyncRecipeParams params;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.vertica");

    public AbtractToVerticaExecutor(SyncRecipeParams params) {
        this.params = params;
    }

    @Override
    public void init() throws Exception {
        assert (this.outputDS.getType().equals("Vertica"));
        if (this.outputDS.getSchema() == null) {
            throw ErrorContext.iaef((String)"Output dataset %s needs a schema", (Object)this.outputDS, (Object[])new Object[0]);
        }
        if (this.inputDS.getPartitioningSchema().isPartitioned() && !this.inputDS.getPartitioningSchema().isSingleDimension()) {
            throw ErrorContext.iae((String)"Input dataset must have at most 1 dimension");
        }
    }

    protected String createCopyStatement(AbstractSQLTableDatasetHandler vti) throws IOException {
        SQLUtils.SQLTable table = vti.getResolvedTable();
        return String.format("COPY %s FROM LOCAL STDIN %s DELIMITER ',' ENCLOSED BY '\"' REJECTED DATA '%s' EXCEPTIONS '%s'", this.connData.getDialect().getQuotedTableFullName(table), ApplicationConfigurator.getParams().getBoolParam("dku.sql.vertica.syncCopyDirect", false) ? "DIRECT" : "", FlowJobUtils.getJobFile("vertica-write", "rejected.csv"), FlowJobUtils.getJobFile("vertica-write", "exceptions.txt"));
    }

    protected void warnRejects() throws IOException {
        File rejectedFile = FlowJobUtils.getJobFile("vertica-write", "rejected.csv");
        if (rejectedFile.isFile() && rejectedFile.length() > 0L) {
            this.warnContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_SQL_BAD_DATA, "Some rows were rejected by Vertica. Check " + String.valueOf(rejectedFile), logger);
        }
    }

    protected Partition computeVerticaPartitionKey(Partition targetPartition) {
        targetPartition.getScheme().getSingleDimension();
        return targetPartition;
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }
}

