/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.DatabricksSupport;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureBlobToDatabricks
extends CloudToDatabricks<AzureBlobDatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.azureblobtodatabricks");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "Azure")) {
            status.markAsNonSelectable("Input dataset is not in Azure", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (outputMeta != BuiltinSQLDatasets.DATABRICKS_META) {
            status.markAsNonSelectable("Output dataset is not in Databricks", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            DatabricksSupport.validateAzureConnection(authCtx, inputDS);
            AzureBlobToDatabricks.getCopyMode(inputDS);
        }
        catch (CloudBlobSupport.CloudBlobToSQLImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    CloudToDatabricks.DisplayableSQLChunk getCredentials(AzureBlobDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData) throws DKUSecurityException, IOException {
        AzureConnection azure = blobHandler.getConnection();
        String storageCredential = ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(azure.params.storageAccount);
        logger.info((Object)("Use storage credentials " + storageCredential));
        if (storageCredential == null) {
            if (StringUtils.isNotBlank((String)azure.params.sasToken)) {
                AzureConnection.SerializableAzureStorageAccountCredentials creds = azure.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, this.contextProjectKey), AzureConnection.SerializableAzureStorageAccountCredentials.class);
                return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIALS (AZURE_SAS_TOKEN = '%s') )", creds.sasToken), "WITH ( CREDENTIALS (AZURE_SAS_TOKEN = '***') )");
            }
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        if (StringUtils.isBlank((String)storageCredential)) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIAL `%s` )", storageCredential));
    }

    @Override
    void setUpCredentials(AzureBlobDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData, Statement stmt) throws SQLException, DKUSecurityException, IOException {
        AzureConnection azure = blobHandler.getConnection();
        DatabricksConnection databricksConnection = (DatabricksConnection)connData.getConnection();
        String storageCredential = databricksConnection.params.getStorageCredentials(azure.params.storageAccount);
        if (storageCredential == null) {
            if (StringUtils.isNotBlank((String)azure.params.sasToken)) {
                logger.info((Object)"Will load using SAS token");
            } else {
                logger.info((Object)"Will load using credentials from connection");
                try {
                    DatabricksSupport.setAzureCredentials(this.authCtx, stmt, azure);
                }
                catch (SQLException exc) {
                    if (databricksConnection.params.suspectSQLWarehouse()) {
                        throw new SQLException("Error while setting up credentials. If you are running a SQL warehouse cluster, you will need to defined stored credentials.", exc);
                    }
                    throw exc;
                }
            }
        }
    }

    @Override
    String getRoot(AzureBlobDatasetHandler blobHandler) throws CodedException, IOException, DKUSecurityException {
        return blobHandler.getFullyQualifiedRootPath(AzureBlobDatasetHandler.HDFSInterface.ABFS);
    }

    @Override
    public void run() throws Exception {
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             AzureBlobDatasetHandler abdh = (AzureBlobDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLUtils.SQLTable outputTable = vti.getResolvedTable();
            AzureConnection azure = abdh.getConnection();
            CloudBlobSupport.CopyMode copyMode = AzureBlobToDatabricks.getCopyMode(this.inputDS);
            boolean isAppendMode = this.writeMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connection = vti.newConnection();
            try {
                SQLUtils.executePreWriteStatements(connData, connection, this.outputDS);
                this.prepareOutputTable(connection, connData);
                this.executeCopy(connData, connection, abdh, copyMode, this.outputDS, outputTable, isAppendMode);
                SQLUtils.executePostWriteStatements(connData, connection, this.outputDS);
                connection.close();
            }
            catch (Exception e) {
                logger.error((Object)"Databricks load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connection);
                throw e;
            }
        }
    }
}

