/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.DatabricksSupport;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToCloud;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabricksToAzureBlob
extends DatabricksToCloud<AzureBlobDatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.databrickstoazureblob");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        status.isSelectable = true;
        if (inputMeta != BuiltinSQLDatasets.DATABRICKS_META) {
            status.markAsNonSelectable("Input dataset is not in Databricks", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, "Azure")) {
            status.markAsNonSelectable("Output dataset is not in Azure", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (!DatasetInspector.isSQLTable(inputDS)) {
            status.markAsNonSelectable("Input dataset is not a SQL table dataset", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            DatabricksSupport.validateAzureConnection(authCtx, outputDS);
            DatabricksToAzureBlob.getCopyMode(outputDS);
        }
        catch (CloudBlobSupport.CloudBlobToSQLImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    String getRoot(AzureBlobDatasetHandler blobHandler) throws CodedException, IOException, DKUSecurityException {
        return blobHandler.getFullyQualifiedRootPath(AzureBlobDatasetHandler.HDFSInterface.ABFS);
    }

    @Override
    CloudToDatabricks.DisplayableSQLChunk getCredentials(AzureBlobDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData) throws SQLException, IOException, DKUSecurityException {
        String storageCredential = this.getStorageCredentials(blobHandler, connData);
        logger.info((Object)("Will use storage credentials " + storageCredential));
        if (storageCredential == null) {
            return null;
        }
        if (StringUtils.isBlank((String)storageCredential)) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIAL `%s` )", storageCredential));
    }

    @Override
    void setUpCredentials(AzureBlobDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData, Statement stmt) throws SQLException, DKUSecurityException, IOException {
        AzureConnection azure = blobHandler.getConnection();
        DatabricksSupport.setAzureCredentials(this.authCtx, stmt, azure);
    }

    @Override
    String getStorageCredentials(AzureBlobDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData) {
        AzureConnection azure = blobHandler.getConnection();
        return ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(azure.params.storageAccount);
    }

    @Override
    public void run() throws Exception {
        CloudBlobSupport.CopyMode mode = DatabricksToAzureBlob.getCopyMode(this.outputDS);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             AzureBlobDatasetHandler abdh = (AzureBlobDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLUtils.SQLTable inputTable = dsh.getResolvedTable();
            try (SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();){
                this.executeCopy(connWrapper, abdh, mode, inputTable);
            }
            catch (Exception e) {
                logger.error((Object)"Databricks unload failed", (Throwable)e);
                throw e;
            }
        }
    }
}

