/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.exec.vstack.AppendColumnOutputProcessor;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.FilterProcessorOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class VStackRecipeBuiltinRunner
implements AbortableRecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    private JobActivity activity;
    private FlowRecipe recipe;
    protected VStackRecipePayloadParams params;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.vstack");

    public VStackRecipeBuiltinRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void notifyBeforeAborting() {
    }

    @Override
    public void run() throws Exception {
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        FlowDataset outputFD = this.activity.getSubgraph().getTargetsDatasets().get(0);
        Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(outputFD);
        SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getModel().getSingleOutput("main");
        Output.WriteMode writeMode = recipeOutput.getWriteMode();
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDS);){
            if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler.getMeta().isFSLike()) {
                    outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDS, targetPartition, (ColumnFactory)cf, this.activity.warnContext, writeMode);
        ProcessorOutput out = streamer.getAsOutput();
        VariablesContext variablesContext = this.variablesService.getForProject(this.recipe.getProjectKey());
        FilterDesc postFilter = this.expandFilter(this.params.postFilter, variablesContext);
        for (VStackRecipePayloadParams.InputDesc input : this.params.virtualInputs) {
            Object currentOut = out;
            FilterDesc inputPreFilter = this.expandFilter(input.preFilter, variablesContext);
            DatasetLocUtils.DatasetLoc dloc = DatasetLocUtils.resolveSmart(this.recipe.getProjectKey(), input.name);
            Dataset source = this.datasetAccessService.getMandatory(dloc);
            FlowDataset fdSource = new FlowDataset(source);
            StreamableDatasetSelection dataSelection = StreamableDatasetSelection.full();
            if (source.getPartitioningSchema().isPartitioned()) {
                dataSelection.withSelectedPartitions(this.activity.getSubgraph().getSourcePartitions(fdSource));
            }
            ArrayList filters = Lists.newArrayList();
            if (FilterDescUtils.willFilter(inputPreFilter)) {
                filters.add(inputPreFilter);
            }
            if (filters.size() > 0) {
                dataSelection.filter = FilterDesc.andFilter((FilterDesc[])filters.toArray(new FilterDesc[0]));
            }
            if (this.params.addOriginColumn) {
                currentOut = new AppendColumnOutputProcessor((ProcessorOutput)currentOut, this.params.originColumnName, input.originLabel, (ColumnFactory)cf);
            }
            if (this.params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX) {
                currentOut = new StackColumnsPerIndexOutputProcessor((ProcessorOutput)currentOut, source.getSchema().getColumns(), (ColumnFactory)cf, outputDS.getSchema().getColumns(), this.params.selectedColumnsIndexes, rf);
            } else if (this.params.mode == VStackRecipePayloadParams.SchemaMergeMode.REMAP) {
                List<String> columnsMatch = ((VStackRecipePayloadParams.InputDesc)this.params.virtualInputs.get((int)input.index)).columnsMatch.stream().map(col -> col == null ? "" : col).toList();
                currentOut = new StackColumnsReorderOutputProcessor((ProcessorOutput)currentOut, (ColumnFactory)cf, outputDS.getSchema().getColumns(), rf, columnsMatch);
            }
            if (FilterDescUtils.willFilter(postFilter)) {
                currentOut = new FilterProcessorOutput((ProcessorOutput)currentOut, (ColumnFactory)cf, postFilter, outputDS.getSchema());
            }
            if (this.params.addOriginColumn) {
                currentOut = new AppendColumnOutputProcessor((ProcessorOutput)currentOut, this.params.originColumnName, input.originLabel, (ColumnFactory)cf);
            }
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(this.authCtxService.getAuthCtx(), source, (ProcessorOutput)currentOut, (ColumnFactory)cf, (RowFactory)rf);
            pusher.setWarningsContext(this.activity.warnContext);
            pusher.setDatasetSelection(dataSelection);
            pusher.push();
        }
        out.lastRowEmitted();
    }

    private FilterDesc expandFilter(FilterDesc filterDesc, VariablesContext vc) {
        FilterDesc expandedFilterDesc = (FilterDesc)JSON.deepCopy((Object)filterDesc);
        if (expandedFilterDesc != null) {
            FilterDescUtils.expandExpressionIfNeeded(expandedFilterDesc, vc);
        }
        return expandedFilterDesc;
    }

    public static class StackColumnsPerIndexOutputProcessor
    extends FilteringProcessorOutput {
        private List<SchemaColumn> outputColumns;
        private List<Integer> outputColumnsIndexes;
        private List<SchemaColumn> inputColumns;
        private int inputSize;
        private int outputSize;
        private ColumnFactory cf;
        private StreamRowFactory rf;

        public StackColumnsPerIndexOutputProcessor(ProcessorOutput downstream, List<SchemaColumn> inputColumns, ColumnFactory cf, List<SchemaColumn> outputColumns, List<Integer> outputColumnsIndexes, StreamRowFactory rf) {
            super(downstream);
            this.cf = cf;
            this.outputColumns = outputColumns;
            this.outputColumnsIndexes = outputColumnsIndexes;
            this.inputColumns = inputColumns;
            this.inputSize = inputColumns.size();
            this.outputSize = outputColumns.size();
            this.rf = rf;
        }

        public void emitRow(Row row) throws Exception {
            int index = 0;
            Row newRow = this.rf.row();
            for (SchemaColumn column : this.outputColumns) {
                String columnName = column.getName();
                String value = null;
                if (index < this.outputSize) {
                    if (index < this.outputColumnsIndexes.size()) {
                        int targetIndex = this.outputColumnsIndexes.get(index);
                        if (targetIndex < this.inputSize) {
                            value = row.get(this.cf.column(this.inputColumns.get(targetIndex).getName()));
                        }
                    } else {
                        value = row.get(this.cf.column(columnName));
                    }
                    newRow.put(this.cf.column(columnName), value);
                }
                ++index;
            }
            this.downstream.emitRow(newRow);
        }
    }

    public static class StackColumnsReorderOutputProcessor
    extends FilteringProcessorOutput {
        private List<SchemaColumn> outputColumns;
        private ColumnFactory cf;
        private StreamRowFactory rf;
        private List<String> columnOrder;
        private int columnOrderSize;

        public StackColumnsReorderOutputProcessor(ProcessorOutput downstream, ColumnFactory cf, List<SchemaColumn> outputColumns, StreamRowFactory rf, List<String> columnOrder) {
            super(downstream);
            this.cf = cf;
            this.outputColumns = outputColumns;
            this.rf = rf;
            this.columnOrder = columnOrder;
            this.columnOrderSize = columnOrder.size();
        }

        public void emitRow(Row row) throws Exception {
            Row newRow = this.rf.row();
            int index = 0;
            for (SchemaColumn column : this.outputColumns) {
                String columnName = column.getName();
                String value = null;
                if (index < this.columnOrderSize) {
                    value = row.get(this.cf.column(this.columnOrder.get(index)));
                }
                newRow.put(this.cf.column(columnName), value);
                ++index;
            }
            if (this.downstream != null) {
                this.downstream.emitRow(newRow);
            }
        }
    }
}

