/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;

public abstract class FlowComputable
extends GraphNode {
    private FCType type;

    public FlowComputable(FCType type) {
        this.type = type;
    }

    public FCType getType() {
        return this.type;
    }

    public abstract boolean isPartitionable();

    public abstract SerializedDataset.RebuildBehavior getRebuildBehavior() throws IOException;

    public abstract SerializedDataset.CrossProjectBuildBehaviour getCrossProjectBehavior() throws IOException;

    @Override
    public String getGraphId() {
        return GraphIds.forComputable(this);
    }

    public boolean canBeBuilt() {
        return true;
    }

    static {
        TypeAdapter defaultEnumAdapter = TypeAdapters.ENUM_FACTORY.create(new Gson(), TypeToken.get(FCType.class));
        JSON.registerAdapter(FCType.class, (Object)defaultEnumAdapter);
    }

    public static enum FCType {
        DATASET(true, ITaggingService.TaggableType.DATASET),
        SAVED_MODEL(true, ITaggingService.TaggableType.SAVED_MODEL),
        MODEL_EVALUATION_STORE(true, ITaggingService.TaggableType.MODEL_EVALUATION_STORE),
        MANAGED_FOLDER(true, ITaggingService.TaggableType.MANAGED_FOLDER),
        STREAMING_ENDPOINT(false, ITaggingService.TaggableType.STREAMING_ENDPOINT),
        RETRIEVABLE_KNOWLEDGE(false, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);

        private final boolean partitionable;
        private final ITaggingService.TaggableType taggableType;

        private FCType(boolean partitionable, ITaggingService.TaggableType taggableType) {
            this.partitionable = partitionable;
            this.taggableType = taggableType;
        }

        public boolean isPartitionable() {
            return this.partitionable;
        }

        public ITaggingService.TaggableType toTaggableType() {
            return this.taggableType;
        }

        public static FCType fromTaggableType(ITaggingService.TaggableType tt) {
            tt.assertNotFakeType();
            return Arrays.stream(FCType.values()).filter(fct -> fct.taggableType == tt).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf((Object)tt) + " is not a computable type"));
        }

        public static boolean isFlowComputable(ITaggingService.TaggableType tt) {
            tt.assertNotFakeType();
            return Arrays.stream(FCType.values()).anyMatch(fct -> fct.taggableType == tt);
        }
    }

    public static class FlowComputableWithRole {
        public final FlowComputable computable;
        public final String role;

        public FlowComputableWithRole(FlowComputable computable, String role) {
            this.computable = computable;
            this.role = role;
        }
    }
}

