/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BuildUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs.utils");

    public static void assignJobNameAndId(String prefix, JobDef jd) throws IOException {
        if (jd.name == null) {
            if (jd.type == JobDef.JobType.REVERSE_FORCED_BUILD) {
                jd.name = prefix + " from ";
                jd.name = jd.name + jd.reverseStartingPoints.stream().map(sp -> sp.id).collect(Collectors.joining(", "));
            } else {
                jd.name = prefix + " ";
                for (int i = 0; i < jd.outputs.size(); ++i) {
                    JobDef.JobOutput output = jd.outputs.get(i);
                    FlowComputable.FCType type = output.type == null ? BuildUtils.detectOutputType(output) : output.type;
                    switch (type) {
                        case SAVED_MODEL: {
                            SavedModel sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatoryUnsafe(output.targetDatasetProjectKey, output.targetDataset);
                            jd.name = jd.name + sm.name;
                            break;
                        }
                        case MANAGED_FOLDER: {
                            ManagedFolder mf = (ManagedFolder)((ManagedFolderDAO)SpringUtils.getBean(ManagedFolderDAO.class)).getMandatory(output.targetDatasetProjectKey, output.targetDataset);
                            jd.name = jd.name + mf.name + (String)(output.targetPartition == null ? "" : " (" + output.targetPartition.replace("/", "_") + ")");
                            break;
                        }
                        case MODEL_EVALUATION_STORE: {
                            ModelEvaluationStore mes = (ModelEvaluationStore)((ModelEvaluationStoresDAO)SpringUtils.getBean(ModelEvaluationStoresDAO.class)).getMandatory(output.targetDatasetProjectKey, output.targetDataset);
                            jd.name = jd.name + mes.name + (String)(output.targetPartition == null ? "" : " (" + output.targetPartition.replace("/", "_") + ")");
                            break;
                        }
                        case RETRIEVABLE_KNOWLEDGE: {
                            RetrievableKnowledge rk = (RetrievableKnowledge)((RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class)).getMandatory(output.targetDatasetProjectKey, output.targetDataset);
                            jd.name = jd.name + rk.name + (String)(output.targetPartition == null ? "" : " (" + output.targetPartition.replace("/", "_") + ")");
                            break;
                        }
                        case DATASET: {
                            jd.name = jd.name + output.targetDataset + (String)(output.targetPartition == null ? "" : " (" + output.targetPartition.replace("/", "_") + ")");
                            break;
                        }
                        case STREAMING_ENDPOINT: {
                            jd.name = jd.name + output.targetDataset;
                        }
                    }
                    if (i == jd.outputs.size() - 1) continue;
                    jd.name = jd.name + ", ";
                }
            }
            jd.name = jd.name.substring(0, Math.min(jd.name.length(), 200));
        }
        jd.assignIdFromNameAndTimestamp();
    }

    public static FlowComputable.FCType detectOutputType(JobDef.JobOutput o) throws IOException {
        if (o.type != null) {
            return o.type;
        }
        SavedModel sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getOrNullUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        if (sm != null) {
            return FlowComputable.FCType.SAVED_MODEL;
        }
        ManagedFolder odb = (ManagedFolder)((ManagedFolderDAO)SpringUtils.getBean(ManagedFolderDAO.class)).getOrNullUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        if (odb != null) {
            return FlowComputable.FCType.MANAGED_FOLDER;
        }
        ModelEvaluationStore mes = (ModelEvaluationStore)((ModelEvaluationStoresDAO)SpringUtils.getBean(ModelEvaluationStoresDAO.class)).getOrNullUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        if (mes != null) {
            return FlowComputable.FCType.MODEL_EVALUATION_STORE;
        }
        RetrievableKnowledge rk = (RetrievableKnowledge)((RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class)).getOrNullUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        if (rk != null) {
            return FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE;
        }
        return FlowComputable.FCType.DATASET;
    }

    private static RelFileFilter getConfigFilter(final AuthCtx authCtx, final Set<String> usefulProjects, final @Nullable String scenarioId) {
        return new RelFileFilter(){
            private final Pattern PROJECT_PATTERN = Pattern.compile("projects/[^/]*/(lib|saved_models|datasets|explore|recipes|managed_folders|streaming-endpoints|model_evaluation_stores|labeling_tasks|knowledge-banks|agent-tools|zones)/.*");
            private final String user = authCtx.getAssociatedDSSUser();

            public boolean accept(ReadOnlyFS fs, RelFile file) throws IOException {
                String fullPath = file.getFullPath();
                if (fullPath.startsWith(".git/")) {
                    return false;
                }
                if (!fullPath.startsWith("projects/") && fullPath.endsWith("-journal")) {
                    return false;
                }
                if (fullPath.startsWith("ipython_notebooks/")) {
                    return false;
                }
                if (fullPath.startsWith("code_studio_templates/")) {
                    return false;
                }
                if (fullPath.startsWith("user-data/")) {
                    return this.user != null && (fullPath.equals("user-data/" + this.user) || fullPath.startsWith("user-data/" + this.user + "/"));
                }
                if (fullPath.startsWith("projects/")) {
                    String[] chunks = fullPath.split("/");
                    if (usefulProjects.contains(chunks[1])) {
                        if (chunks.length > 2 && ".git".equals(chunks[2])) {
                            return false;
                        }
                        if (fs.isDirectory(file)) {
                            return true;
                        }
                        if (fullPath.endsWith("variables.json")) {
                            return true;
                        }
                        if (fullPath.endsWith("active-bundle.json")) {
                            return true;
                        }
                        if (fullPath.endsWith("params.json")) {
                            return true;
                        }
                        if (fullPath.contains(".dss-meta")) {
                            return true;
                        }
                        if ("plugins".equals(chunks[2]) && fullPath.endsWith("settings.json")) {
                            return true;
                        }
                        if (StringUtils.isNotBlank((String)scenarioId) && fullPath.endsWith("scenarios/" + scenarioId + ".json")) {
                            return true;
                        }
                        return this.PROJECT_PATTERN.matcher(fullPath).matches();
                    }
                    return false;
                }
                return !fullPath.endsWith(".png");
            }
        };
    }

    public static JobLocalConfigSnapshot copyJobLocalConfig(AuthCtx authCtx, FlowGraph graphUnsafe, JobDef jd) throws Exception {
        TransactionRef t = TransactionContext.retrieveRead();
        HashSet<String> usefulProjects = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        boolean collectDownstreamProjectsOfExposedObjects = false;
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            collectDownstreamProjectsOfExposedObjects = ConnectionsDAO.get().listUnsafe().values().stream().filter(c2 -> "HDFS".equals(c2.type)).anyMatch(c2 -> ((HDFSConnection)c2).params.aclSynchronizationMode == HDFSConnection.ACLSynchronizationMode.SUBDIRECTORY);
        }
        if (DKUApp.getParams().getBoolParam("dku.jobs.localconfig.forceCollectDownstreamProjectsOfExposedObjects", false)) {
            collectDownstreamProjectsOfExposedObjects = true;
        }
        for (JobDef.JobOutput jobOutput : jd.outputs) {
            BuildUtils.collectUsefulProjects(graphUnsafe, new DatasetLocUtils.DatasetLoc(jobOutput.targetDatasetProjectKey, jobOutput.targetDataset).getFullName(), usefulProjects, visited, collectDownstreamProjectsOfExposedObjects);
        }
        for (JobDef.ReverseJobStartingPoint reverseJobStartingPoint : jd.reverseStartingPoints) {
            BuildUtils.collectUsefulProjectsFromStartingPoint(graphUnsafe, new AnyLoc(reverseJobStartingPoint.projectKey, reverseJobStartingPoint.id), usefulProjects);
        }
        DSSGitModel.ExternalLibraries el = (DSSGitModel.ExternalLibraries)t.readObjectDefault(new RelFile(new String[]{"projects", jd.projectKey, "lib", "external-libraries.json"}), DSSGitModel.ExternalLibraries.class);
        for (String foreignProjectKey : el.getNonNullLibrariesFromProjects()) {
            ((IPermissionsService)SpringUtils.getBean(IPermissionsService.class)).checkProjectPrivileges(authCtx, foreignProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            usefulProjects.add(foreignProjectKey);
        }
        DKULogger.getLogger((String)"dku").info((Object)("Will copy projects : " + JSON.json(usefulProjects) + " (collected downstream: " + collectDownstreamProjectsOfExposedObjects + ")"));
        File file = FlowJobUtils.jobFolder(false, jd.projectKey, jd.id);
        DKUFileUtils.mkdirs((File)file);
        File localConfig = FlowJobUtils.jobLocalConfigFolder(false, jd.projectKey, jd.id);
        File localConfigArchive = FlowJobUtils.jobLocalConfigArchive(false, jd.projectKey, jd.id);
        return BuildUtils.copyJobLocalConfig(authCtx, t, usefulProjects, localConfig, localConfigArchive, null);
    }

    public static void copyJobEnvFile(String jobProjectKey, String jobId) throws IOException {
        File[] files;
        File jobFolder = FlowJobUtils.jobFolder(false, jobProjectKey, jobId);
        if (DKUApp.exists((String)"install.ini")) {
            File iniFile = DKUApp.getFile((String)"install.ini");
            FileUtils.copyFile((File)iniFile, (File)DKUApp.getFile((File)jobFolder, (String[])new String[]{"install.ini"}));
        }
        if (DKUApp.exists((String)"bin") && (files = DKUApp.getFile((String)"bin").listFiles()) != null) {
            for (File binFile : files) {
                if (!binFile.getName().startsWith("env-")) continue;
                FileUtils.copyFile((File)binFile, (File)DKUApp.getFile((File)jobFolder, (String[])new String[]{"bin", binFile.getName()}));
            }
        }
    }

    public static void captureEnvironmentVariables(String jobProjectKey, String jobId) throws IOException {
        Map envVariables = DKUtils.getEnvironment();
        if (!envVariables.isEmpty()) {
            File jobFolder = FlowJobUtils.jobFolder(false, jobProjectKey, jobId);
            JSON.prettyToFile((Object)envVariables, (File)DKUApp.getFile((File)jobFolder, (String[])new String[]{"env.json"}));
        }
    }

    public static JobLocalConfigSnapshot copyJobLocalConfig(AuthCtx ctx, String projectKey, File attemptFolder, String scenarioId) throws Exception {
        TransactionRef t = TransactionContext.retrieveRead();
        DKULogger.getLogger((String)"dku").info((Object)("Will copy project : " + projectKey));
        DKUFileUtils.mkdirs((File)attemptFolder);
        File localConfigFolder = FlowJobUtils.jobLocalConfigFolder(attemptFolder);
        File localConfigArchive = FlowJobUtils.jobLocalConfigArchive(attemptFolder);
        return BuildUtils.copyJobLocalConfig(ctx, t, Sets.newHashSet((Object[])new String[]{projectKey}), localConfigFolder, localConfigArchive, scenarioId);
    }

    public static boolean useZippedJobLocalConfig() {
        return DKUApp.getParams().getBoolParam("dku.jobs.localconfig.zipped", true);
    }

    public static JobLocalConfigSnapshot copyJobLocalConfig(AuthCtx ctx, TransactionRef t, Set<String> usefulProjects, File localConfigFolder, File localConfigArchive, String scenarioId) throws Exception {
        ImpersonationResolverService impersonationService;
        InMemoryDiff fileContents = new InMemoryDiff();
        if (BuildUtils.useZippedJobLocalConfig()) {
            if (!localConfigArchive.createNewFile()) {
                logger.debug((Object)("Unable to create new file " + localConfigFolder.getAbsolutePath() + ". It already exists."));
            }
        } else if (!localConfigFolder.mkdirs()) {
            logger.warn((Object)("Unable to create directory " + localConfigFolder.getAbsolutePath()));
        }
        if ((impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class)).isEnabled()) {
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            if (localConfigArchive.isFile()) {
                aclHandler.ensureStudioPrivate(localConfigArchive);
            } else {
                aclHandler.ensureStudioPrivate(localConfigFolder);
            }
        }
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.jobs.snapshotConfig");){
            logger.info((Object)"Snapshotting local config");
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)t).to((ReadWriteFS)fileContents).filter(BuildUtils.getConfigFilter(ctx, usefulProjects, scenarioId)).dryRun(false).copyMethod(FSUtils.COPY_COMPRESSED_BYTES_REF).run();
            AppsService appsService = (AppsService)SpringUtils.getBean(AppsService.class);
            AppManifest.RecipeAppManifests appsManifest = new AppManifest.RecipeAppManifests();
            for (AppManifest mf : appsService.listRecipeAppManifests_T()) {
                appsManifest.manifests.put(mf.id, mf);
            }
            fileContents.makeDirectory(new RelFile(new String[]{"run"}));
            fileContents.writeObject("run/app-manifests.json", (Object)appsManifest);
            logger.info((Object)"Snapshotting local config done");
        }
        return new JobLocalConfigSnapshot(fileContents, localConfigFolder, localConfigArchive);
    }

    private static void collectUsefulProjects(FlowGraph graphUnsafe, String computableId, Set<String> projects, Set<String> visitedId, boolean collectDownstreamProjectsOfExposedObjects) throws IOException {
        if (visitedId.contains(computableId)) {
            return;
        }
        visitedId.add(computableId);
        FlowComputable fcUnsafe = graphUnsafe.getComputable(computableId);
        if (fcUnsafe == null) {
            throw ErrorContext.iaef((String)"Computable not found or not buildable: %s", (Object)computableId, (Object[])new Object[0]);
        }
        switch (fcUnsafe.getType()) {
            case DATASET: {
                ProjectsDAO projectsDAO;
                SerializedProject sp;
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(((FlowDataset)fcUnsafe).getFullId());
                projects.add(loc.getProjectKey());
                if (!collectDownstreamProjectsOfExposedObjects || (sp = (projectsDAO = (ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getOrNull(loc.getProjectKey())) == null) break;
                for (ExposedObject eo : sp.exposedObjects.objects) {
                    if (eo.type != ITaggingService.TaggableType.DATASET || eo.localName == null || !eo.localName.equals(loc.getName())) continue;
                    for (ExposedObject.Rule rule : eo.rules) {
                        if (rule.targetProject == null) continue;
                        projects.add(rule.targetProject);
                    }
                }
                break;
            }
            case SAVED_MODEL: 
            case MANAGED_FOLDER: 
            case MODEL_EVALUATION_STORE: 
            case RETRIEVABLE_KNOWLEDGE: 
            case STREAMING_ENDPOINT: {
                projects.add(AnyLoc.resolveFull(fcUnsafe.getFullId()).getProjectKey());
            }
        }
        for (GraphNode graphNode : fcUnsafe.getPredecessors()) {
            if (graphNode instanceof FlowRunnable) {
                projects.add(((FlowRunnable)graphNode).getProjectKey());
                for (FlowComputable src : ((FlowRunnable)graphNode).getSources()) {
                    BuildUtils.collectUsefulProjects(graphUnsafe, src.getFullId(), projects, visitedId, collectDownstreamProjectsOfExposedObjects);
                }
                continue;
            }
            throw new NotImplementedException();
        }
    }

    private static void collectUsefulProjectsFromStartingPoint(FlowGraph graphUnsafe, AnyLoc spLoc, Set<String> projects) throws IOException {
        projects.add(spLoc.getProjectKey());
        for (GraphNode gn : graphUnsafe.getNodesMap().values()) {
            if (!(gn instanceof FlowComputable)) continue;
            String projectOfTheComputable = AnyLoc.resolveFull(gn.getFullId()).getProjectKey();
            projects.add(projectOfTheComputable);
        }
    }

    public static class JobLocalConfigSnapshot {
        private final InMemoryDiff fileContents;
        private final File localConfigFolder;
        private final File localConfigArchive;

        public JobLocalConfigSnapshot(InMemoryDiff fileContents, File localConfigFolder, File localConfigArchive) {
            this.fileContents = fileContents;
            this.localConfigFolder = localConfigFolder;
            this.localConfigArchive = localConfigArchive;
        }

        public void copyConfigOnDisk() throws IOException {
            TransactionContext.assertNoAttachedTransaction();
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.jobs.copyConfigOnDisk");){
                if (this.localConfigArchive.isFile()) {
                    logger.info((Object)("Copying config on disk in archive " + String.valueOf(this.localConfigArchive)));
                    try (ZipWriteFS zipFs = new ZipWriteFS(this.localConfigArchive, 1);){
                        FSUtils.newRecursiveCopy().from((ReadOnlyFS)this.fileContents).to((ReadWriteFS)zipFs, FlowJobUtils.LOCALCONFIG_FOLDER_NAME).run();
                    }
                } else {
                    logger.info((Object)("Copying config on disk in " + String.valueOf(this.localConfigFolder)));
                    int parallelism = DKUApp.getParams().getIntParam("dku.jobs.localconfig.fastCopyParallelism", Integer.valueOf(1));
                    logger.info((Object)("Using optimized copy method, with parallelism: " + parallelism));
                    FSUtils.newRecursiveCopy().from((ReadOnlyFS)this.fileContents).to((ReadWriteFS)NativeFS.from((File)this.localConfigFolder).skipFileTypeCheck(true).atomicWrite(false).build()).parallelism(parallelism).dryRun(false).run();
                }
                logger.info((Object)"Copied config on disk");
            }
        }
    }
}

