/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.FileNamingAbleOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DatasetWriter
implements AutoCloseable {
    private static final DKULogger logger = DKULogger.getLogger(DatasetWriter.class);
    final RowFactory rowFactory = new StreamRowFactory();
    final ColumnFactory columnFactory;
    private final WarningsContext warningsContext;
    final Dataset dataset;
    private OutputWriter datasetOutputWriter;
    private long writtenRows = 0L;
    private DatasetHandler datasetHandler;

    private DatasetWriter(AuthCtx authCtx, Dataset dataset, Partition partition, WarningsContext wc, Output.WriteMode mode, String fixedId, ColumnFactory columnFactory) throws Exception {
        this.dataset = dataset;
        this.warningsContext = wc;
        this.datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);
        this.columnFactory = columnFactory != null ? columnFactory : new StreamColumnFactory();
        mode = DatasetWriter.getWriteModeAfterDatasetCleanup(this.datasetHandler, dataset, partition, mode);
        logger.info((Object)"Creating output writer");
        this.datasetOutputWriter = this.datasetHandler.buildOutput(partition, 0, 1, this.warningsContext).getWriter(mode);
        if (StringUtils.isNotBlank((String)fixedId) && this.datasetOutputWriter instanceof FileNamingAbleOutputWriter) {
            ((FileNamingAbleOutputWriter)this.datasetOutputWriter).setFileNamingMode(FileNamingAbleOutputWriter.FileNamingMode.FIXED, fixedId);
        }
        logger.info((Object)"Initializing output writer");
        this.datasetOutputWriter.init(columnFactory);
        logger.info((Object)"Done initializing output writer");
    }

    public static Output.WriteMode getWriteModeAfterDatasetCleanup(Dataset dataset, Partition partition, Output.WriteMode mode, AuthCtx authCtx) throws Exception {
        try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
            Output.WriteMode writeMode = DatasetWriter.getWriteModeAfterDatasetCleanup(datasetHandler, dataset, partition, mode);
            return writeMode;
        }
    }

    public static Output.WriteMode getWriteModeAfterDatasetCleanup(DatasetHandler datasetHandler, Dataset dataset, Partition partition, Output.WriteMode mode) throws Exception {
        if (mode == Output.WriteMode.OVERWRITE && !datasetHandler.outputHandlesClear()) {
            logger.info((Object)"Overwrite: clearing output");
            if (dataset.getPartitioningSchema().isPartitioned()) {
                if (datasetHandler.getMeta().isFSLike()) {
                    datasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{partition}));
                }
            } else {
                datasetHandler.clearAllData();
            }
            mode = Output.WriteMode.APPEND;
        }
        return mode;
    }

    public static DatasetWriter build(AuthCtx authCtx, Dataset dataset, String partitionSpec, WarningsContext wc, Output.WriteMode mode, String fixedId, ColumnFactory columnFactory) throws Exception {
        Partition partition = null;
        if (dataset.getPartitioningSchema().isPartitioned()) {
            if (StringUtils.isBlank((String)partitionSpec)) {
                throw new RuntimeException("A partition ID must be provided, because the dataset " + dataset.getFullName() + " is partitioned");
            }
            List<Partition> partitions = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), partitionSpec);
            if (partitions.size() > 1) {
                throw ErrorContext.iaef((String)"Partition specification %s cannot target in write a range", (Object)partitionSpec, (Object[])new Object[0]);
            }
            if (partitions.size() == 0) {
                throw ErrorContext.iaef((String)"Invalid partition ID: %s", (Object)partitionSpec, (Object[])new Object[0]);
            }
            partition = partitions.get(0);
        } else {
            if (!StringUtils.isBlank((String)partitionSpec) && !partitionSpec.equals("NP")) {
                throw new RuntimeException("There is no point in specifying a partition ID since the dataset " + dataset.getFullName() + " is not partitioned.");
            }
            partition = new Partition(null);
        }
        return DatasetWriter.build(authCtx, dataset, partition, wc, mode, fixedId, columnFactory);
    }

    public static DatasetWriter build(AuthCtx authCtx, Dataset dataset, String partitionSpec, Output.WriteMode mode, String fixedId, ColumnFactory columnFactory) throws Exception {
        return DatasetWriter.build(authCtx, dataset, partitionSpec, new WarningsContext(), mode, fixedId, columnFactory);
    }

    public static DatasetWriter build(AuthCtx authCtx, Dataset dataset, Partition partition, WarningsContext wc, Output.WriteMode mode, String fixedId, ColumnFactory columnFactory) throws Exception {
        return new DatasetWriter(authCtx, dataset, partition, wc, mode, fixedId, columnFactory);
    }

    public void appendFromRowStream(RowInputStream is) throws Exception {
        Row row;
        while ((row = is.next()) != null) {
            this.appendRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRow(Row row) throws Exception {
        if (this.datasetOutputWriter == null) {
            throw new IOException("No output writer, or failed");
        }
        try {
            this.datasetOutputWriter.emitRow(row);
            ++this.writtenRows;
        }
        catch (Exception e) {
            try {
                this.datasetOutputWriter.cancel();
            }
            catch (Exception e2) {
                logger.error((Object)("Unable to cancel() output writer : " + e2.getMessage()), (Throwable)e2);
            }
            finally {
                this.datasetHandler.close();
            }
            this.datasetOutputWriter = null;
            throw e;
        }
    }

    public void cancel() throws Exception {
        if (this.datasetOutputWriter != null) {
            this.datasetOutputWriter.cancel();
            this.datasetHandler.close();
            this.datasetOutputWriter = null;
        }
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }

    @Override
    public void close() throws Exception {
        if (this.datasetOutputWriter != null) {
            try {
                this.datasetOutputWriter.lastRowEmitted();
            }
            finally {
                this.datasetHandler.close();
            }
            this.datasetOutputWriter = null;
        }
    }
}

