/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalineage;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeLineage {
    @Nonnull
    private final Map<Pair<String, String>, DatasetPairLineage> datasetPairLineages;
    private boolean uncertain;

    public RecipeLineage() {
        this(new HashMap<Pair<String, String>, DatasetPairLineage>(), false);
    }

    public RecipeLineage(String inputDatasetName, String outputDatasetName, DatasetPairLineage datasetPairLineage) {
        HashMap<Pair<String, String>, DatasetPairLineage> datasetPairLineageMap = new HashMap<Pair<String, String>, DatasetPairLineage>();
        datasetPairLineageMap.put(new Pair((Object)inputDatasetName, (Object)outputDatasetName), datasetPairLineage);
        this.datasetPairLineages = datasetPairLineageMap;
        this.uncertain = false;
    }

    public RecipeLineage(Map<Pair<String, String>, DatasetPairLineage> datasetPairLineages) {
        this(datasetPairLineages, false);
    }

    public RecipeLineage(Map<Pair<String, String>, DatasetPairLineage> datasetPairLineages, boolean uncertain) {
        this.datasetPairLineages = datasetPairLineages;
        this.uncertain = uncertain;
    }

    public RecipeLineage(RecipeLineage other) {
        this.datasetPairLineages = new HashMap<Pair<String, String>, DatasetPairLineage>();
        this.uncertain = other.uncertain;
        other.getDatasetPairLineages().forEach((datasetPair, otherDatasetPairLineage) -> {
            DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)otherDatasetPairLineage);
            this.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
        });
    }

    @Nonnull
    public Map<Pair<String, String>, DatasetPairLineage> getDatasetPairLineages() {
        return this.datasetPairLineages;
    }

    public boolean isUncertain() {
        return this.uncertain;
    }

    public void setUncertain(boolean uncertain) {
        this.uncertain = uncertain;
    }

    @Nonnull
    public DatasetPairLineage getOrCreateDatasetPairLineage(@Nonnull SerializedDataset inputDataset, @Nonnull SerializedDataset outputDataset) {
        return this.datasetPairLineages.computeIfAbsent((Pair<String, String>)new Pair((Object)inputDataset.getFullName(), (Object)outputDataset.getFullName()), key -> new DatasetPairLineage(inputDataset, outputDataset));
    }

    public DatasetPairLineage getDatasetPairLineage(String inputDatasetName, String outputDatasetName) {
        return this.datasetPairLineages.get(new Pair((Object)inputDatasetName, (Object)outputDatasetName));
    }

    public void setDatasetPairLineage(@Nonnull Pair<String, String> datasetPair, @Nonnull DatasetPairLineage datasetPairLineage) {
        Preconditions.checkArgument((boolean)((String)datasetPair.first).equals(datasetPairLineage.getInputDatasetFullName()), (Object)"Input dataset mismatch");
        Preconditions.checkArgument((boolean)(datasetPair.second == null ? datasetPairLineage.getOutputDatasetFullName() == null : ((String)datasetPair.second).equals(datasetPairLineage.getOutputDatasetFullName())), (Object)"Output dataset mismatch");
        this.datasetPairLineages.put(datasetPair, datasetPairLineage);
    }

    public void setDatasetPairLineage(String inputDatasetName, String outputDatasetName, @Nonnull DatasetPairLineage datasetPairLineage) {
        this.setDatasetPairLineage((Pair<String, String>)new Pair((Object)inputDatasetName, (Object)outputDatasetName), datasetPairLineage);
    }

    public void addDatasetPairLineage(@Nullable DatasetPairLineage datasetPairLineage) {
        if (datasetPairLineage != null) {
            this.datasetPairLineages.put((Pair<String, String>)new Pair((Object)datasetPairLineage.getInputDatasetFullName(), (Object)datasetPairLineage.getOutputDatasetFullName()), datasetPairLineage);
        }
    }

    public void deleteDatasetPairLineage(String inputDatasetName, String outputDatasetName) {
        this.datasetPairLineages.remove(new Pair((Object)inputDatasetName, (Object)outputDatasetName));
    }

    public void keepValidRelations() {
        this.datasetPairLineages.values().forEach(DatasetPairLineage::keepValidRelations);
    }

    public void addRelation(String fromColumn, String toColumn, SerializedDataset inputDataset, SerializedDataset outputDataset) {
        this.addRelation(fromColumn, toColumn, inputDataset, outputDataset, false);
    }

    public void addRelation(String fromColumn, String toColumn, SerializedDataset inputDataset, SerializedDataset outputDataset, boolean indirect) {
        this.datasetPairLineages.computeIfAbsent((Pair<String, String>)new Pair((Object)inputDataset.getFullName(), (Object)outputDataset.getFullName()), key -> new DatasetPairLineage(inputDataset, outputDataset)).addRelation(fromColumn, toColumn, indirect);
    }

    public void addFactorizedColumnRelations(String fromColumn, String toColumn, SerializedDataset inputDataset, SerializedDataset outputDataset, boolean indirect) {
        this.datasetPairLineages.computeIfAbsent((Pair<String, String>)new Pair((Object)inputDataset.getFullName(), (Object)outputDataset.getFullName()), key -> new DatasetPairLineage(inputDataset, outputDataset)).addFactorizedColumnRelations(fromColumn, toColumn, indirect);
    }

    public void addFactorizedColumnRelations(String fromColumn, String toColumn, SerializedDataset inputDataset, SerializedDataset outputDataset) {
        this.addFactorizedColumnRelations(fromColumn, toColumn, inputDataset, outputDataset, false);
    }

    public Set<ColumnRelation> getAllColumnRelations() {
        return this.datasetPairLineages.values().stream().flatMap(datasetPairLineage -> datasetPairLineage.getRelations().stream()).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeLineage that = (RecipeLineage)o;
        return this.uncertain == that.uncertain && Objects.equals(this.datasetPairLineages, that.datasetPairLineages);
    }

    public int hashCode() {
        return Objects.hash(this.datasetPairLineages, this.uncertain);
    }

    public String toString() {
        return "RecipeLineage{uncertain=" + this.uncertain + ", datasetPairLineages=" + String.valueOf(this.datasetPairLineages) + "}";
    }
}

