/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetSQLLikeComputer;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetStreamComputer;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.probes.TemporaryMetric;
import java.util.List;

public class ValuesInSetMetric
extends TemporaryMetric {
    public static final String TYPE = "ValuesInSetMetric";
    public String ruleId;
    public String column;
    public List<String> values;
    public int maxOutlierCount;

    private ValuesInSetMetric() {
        super("temporary_metrics_probe", Type.ARRAY);
    }

    public ValuesInSetMetric(String ruleId, String column, List<String> values) {
        this();
        this.ruleId = ruleId;
        this.column = column;
        this.values = values;
        this.id = this.serialize();
        this.maxOutlierCount = DKUApp.getProperty((String)"dku.dataquality.ValuesInSetMetric.maxOutlierCount", (int)250);
    }

    @Override
    public MetricMetadata getMeta() {
        MetricMetadata meta = new MetricMetadata().withName("Find invalid values");
        meta.withFullName(meta.getName() + " for " + this.column);
        return meta;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public List<MetricComputer> getComputers() {
        return List.of(new ValuesInSetStreamComputer(), new ValuesInSetSQLLikeComputer.ValuesInSetSQLComputer(), new ValuesInSetSQLLikeComputer.ValuesInSetImpalaComputer(), new ValuesInSetSQLLikeComputer.ValuesInSetHiveComputer(), new ValuesInSetSQLLikeComputer.ValuesInSetSparkComputer());
    }

    @Override
    public String serialize() {
        return Metric.buildMetricIdFromParts("temporary_metrics_probe", TYPE, this.column, this.ruleId);
    }
}

