/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.cassandra;

import com.dataiku.dip.connections.CassandraUtil;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.cassandra.AbstractCassandraDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.utils.DKULogger;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.DriverException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CassandraDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    protected final Dataset dataset;
    protected final AuthCtx authCtx;
    protected DatasetHandler handler;
    private static final Pattern validNamePattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    private TypeInferrer2 inferer = new TypeInferrer2();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cassandra");

    public CassandraDatasetTestHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler handler) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test(boolean connectionOnly) throws Exception {
        TestResult testResult;
        block39: {
            CassandraUtil.ClusterConnection dbConn;
            TestResult result;
            AbstractCassandraDatasetHandler.Config config;
            block36: {
                TestResult e3;
                block37: {
                    assert (this.dataset.getType().equals(AbstractCassandraDatasetHandler.META.getType()));
                    config = this.dataset.getParamsAs(AbstractCassandraDatasetHandler.Config.class);
                    logger.info((Object)("Testing, dataset = " + this.dataset.getName() + " connectionOnly = " + connectionOnly));
                    result = new TestResult();
                    result.testedConnectionOnly = true;
                    try (DatasetHandler dhForName = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
                        result.suggestedName = DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), dhForName.suggestName(), this.dao, this.transactionService);
                    }
                    if (StringUtils.isBlank((String)config.connection)) {
                        result.connectionErrorMsg = String.format("Missing connection for dataset %s", this.dataset.getName());
                    }
                    dbConn = null;
                    try {
                        try {
                            dbConn = CassandraUtil.acquireConnection(this.authCtx, config.connection);
                            ArrayList<String> tableList = new ArrayList<String>();
                            for (TableMetadata tableMeta : dbConn.getKeyspaceMetadata().getTables()) {
                                tableList.add(tableMeta.getName());
                            }
                            result.tableList = tableList;
                            result.connectionOK = true;
                            if (!StringUtils.isBlank((String)config.table)) {
                                logger.info((Object)("Checking table: " + config.table));
                                TableMetadata tableMeta = dbConn.getKeyspaceMetadata().getTable(CassandraUtil.quote(config.table));
                                if (tableMeta != null) {
                                    result.tableExists = true;
                                    Schema sch = CassandraUtil.getSchemaFromTable(tableMeta);
                                    result.tableSchema = new Schema(sch);
                                    if (this.dataset.getSchema() == null || this.dataset.getSchema().getColumns().size() == 0) {
                                        result.schemaMismatchMsg = "dataset has no schema";
                                    } else {
                                        try {
                                            if (this.dataset.isManaged()) {
                                                CassandraUtil.checkManagedTableSchema(tableMeta, this.dataset.getSchema());
                                            } else {
                                                CassandraUtil.checkExternalTableSchema(tableMeta, this.dataset.getSchema());
                                            }
                                            result.schemaMatchesTable = true;
                                        }
                                        catch (IllegalArgumentException e2) {
                                            result.schemaMismatchMsg = e2.getMessage();
                                        }
                                    }
                                }
                            }
                        }
                        catch (DriverException e3) {
                            result.connectionErrorMsg = e3.getMessage();
                            logger.warn((Object)("Server connection failed for connection " + config.connection + " : " + e3.getMessage()));
                            TestResult tableMeta = result;
                            if (dbConn != null) {
                                CassandraUtil.releaseConnection(dbConn);
                            }
                            return tableMeta;
                        }
                    }
                    catch (Throwable throwable) {
                        if (dbConn != null) {
                            CassandraUtil.releaseConnection(dbConn);
                        }
                        throw throwable;
                    }
                    if (!connectionOnly && result.tableExists) break block36;
                    e3 = result;
                    if (dbConn == null) break block37;
                    CassandraUtil.releaseConnection(dbConn);
                }
                return e3;
            }
            result.testedConnectionOnly = false;
            logger.info((Object)"Gathering table preview");
            this.dataset.setSchema(null);
            try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
                RowsInputSplit split = ((RowOrientedDatasetHandler)dh).getSampleSplit();
                MemTable mt = new MemTable();
                if (split != null) {
                    split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(100L), null, null);
                }
                this.inferer.processFullAuto(null, mt);
                SerializedMemTableSimple smt = new SerializedMemTableSimple();
                smt.fromMemTable(mt, 0, mt.nrows());
                result.preview = smt;
            }
            catch (DriverException e) {
                logger.warn((Object)("Failed to get preview for table " + config.table + " : " + e.getMessage()));
                result.previewErrorMsg = e.getMessage();
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Failed to process table " + config.table + " : " + e.getMessage()));
                result.previewErrorMsg = e.getMessage();
            }
            testResult = result;
            if (dbConn == null) break block39;
            CassandraUtil.releaseConnection(dbConn);
        }
        return testResult;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(false);
        ret.empty = !result.tableExists;
        ret.result = new SchemaDetection.SchemaDetectionResult();
        ret.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        if (!ret.empty && !result.schemaMatchesTable) {
            ret.result.setWarningLevel(SchemaDetection.WarningLevel.FATAL);
            ret.result.textReasons.add(result.schemaMismatchMsg);
            ret.result.newSchema = result.tableSchema;
            ret.result.detectedSchema = result.tableSchema;
        }
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (!validNamePattern.matcher(newDatasetName).find()) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Cassandra dataset names should be alphanumeric and starting with a letter");
        }
        return ret;
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public List<String> tableList;
        public boolean tableExists;
        public Schema tableSchema;
        public boolean schemaMatchesTable;
        public String schemaMismatchMsg;
        public String previewErrorMsg;
        public SerializedMemTableSimple preview;
    }
}

