/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.custompython;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractNonImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

public class CustomDatasetPythonKernel
extends AbstractNonImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink> {
    private final APITicketService.Ticket ticket;

    public CustomDatasetPythonKernel(AuthCtx authCtx, SingleCommandKernelLink link, String pluginResourceFolderPath, String pluginLibFolderPath, String projectKey, String envName, APITicketService.Ticket ticket) {
        super(authCtx, link, GeneralSettingsDAO.CGrouppableProcessType.CUSTOM_PYTHON_DATA_ACCESS_COMPONENT, pluginResourceFolderPath, CustomDatasetPythonKernel.makePythonLibs("plugin-lib", pluginLibFolderPath), projectKey, envName);
        this.ticket = ticket;
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.connector.server";
    }

    public APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    public static class WriteRowsRequest {
        public final String task = "write_rows";
        public final Schema schema;
        public final PartitioningScheme partitioning;
        public final String partitionId;
        public final Output.WriteMode writeMode;

        public WriteRowsRequest(Schema schema, PartitioningScheme partitioning, String partitionId, Output.WriteMode writeMode) {
            this.schema = schema;
            this.partitioning = partitioning;
            this.partitionId = partitionId;
            this.writeMode = writeMode;
        }
    }

    public static class CountRecordsResponse {
        public long count;
    }

    public static class CountRecordsRequest {
        public final String task = "records_count";
        public final PartitioningScheme partitioning;
        public final String partitionId;

        public CountRecordsRequest(PartitioningScheme partitioning, String partitionId) {
            this.partitioning = partitioning;
            this.partitionId = partitionId;
        }
    }

    public static class PartitionExistsResponse {
        public boolean exists;
    }

    public static class PartitionExistsRequest {
        public final String task = "partition_exists";
        public final PartitioningScheme partitioning;
        public final String partitionId;

        public PartitionExistsRequest(PartitioningScheme partitioning, String partitionId) {
            this.partitioning = partitioning;
            this.partitionId = partitionId;
        }
    }

    public static class ListPartitionsResponse {
        public List<String> partitions;
    }

    public static class ListPartitionsRequest {
        public final String task = "list_partitions";
        public final PartitioningScheme partitioning;

        public ListPartitionsRequest(PartitioningScheme partitioning) {
            this.partitioning = partitioning;
        }
    }

    public static class GetPartitioningSchemeResponse {
        public PartitioningScheme partitioning;
    }

    public static class GetPartitioningSchemeRequest {
        public final String task = "get_partitioning_scheme";
    }

    public static class GetSchemaResponse {
        public Schema schema;
    }

    public static class GetSchemaRequest {
        public final String task = "get_schema";
    }

    public static class ReadRowsRequest {
        public final String task = "read_rows";
        public final Schema schema;
        public final PartitioningScheme partitioning;
        public final String partitionId;
        public final long limit;

        public ReadRowsRequest(Schema schema, PartitioningScheme partitioning, String partitionId, long limit) {
            this.schema = schema;
            this.partitioning = partitioning;
            this.partitionId = partitionId;
            this.limit = limit;
        }
    }

    public static class InitResponse {
        public boolean ok;
    }

    public static class InitRequest {
        public final String code;
        public final JsonObject config;
        public final JsonObject pluginConfig;

        public InitRequest(String code, JsonObject config, JsonObject pluginConfig) {
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
        }
    }
}

