/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.pool.BasePoolableObjectFactory;

public abstract class AbstractConnectionFactory
extends BasePoolableObjectFactory<DSSDBConnection> {
    private static final String VALIDATION_MESSAGE_TEMPLATE = "Validating %s DB Connection: %s";
    DSSDBConnectionsManagementService.ConnectionPool connectionPool;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.db.internal");

    protected abstract String getFactoryType();

    protected abstract SQLDialect getDialect();

    void setConnectionsPool(DSSDBConnectionsManagementService.ConnectionPool connectionsPool) {
        this.connectionPool = connectionsPool;
    }

    protected abstract String[] metricNamesForValidation();

    protected abstract String[] metricNamesForValidationFailure();

    public boolean validateObject(DSSDBConnection connection) {
        try (DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx((String[])this.metricNamesForValidation());){
            boolean bl;
            block17: {
                logger.traceV(VALIDATION_MESSAGE_TEMPLATE, new Object[]{this.getFactoryType(), connection.debugId});
                ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
                SelectQueryBuilder qb = new SelectQueryBuilder();
                qb.select(ef.cst(1));
                String select = qb.toSQL(this.getDialect());
                Statement statement = connection.createStatement();
                try {
                    statement.execute(select);
                    bl = true;
                    if (statement == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        for (String metricName : this.metricNamesForValidationFailure()) {
                            DSSMetrics.registry().meter(metricName).mark();
                        }
                        logger.infoV("Connection is not functional, dropping it. Id: %s. Error: %s ", new Object[]{connection.debugId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        boolean bl2 = false;
                        if (tctx != null) {
                            tctx.close();
                        }
                        return bl2;
                    }
                }
                statement.close();
            }
            return bl;
        }
    }

    public void destroyObject(DSSDBConnection connection) {
        logger.debugV("Destroying connection %s", new Object[]{connection.debugId});
        connection.ultimateClose();
    }

    public void passivateObject(DSSDBConnection connection) {
        if (connection.isReadOnly()) {
            logger.traceV("Connection %s is flagged as read-only: returning connection to pool without rollback.", new Object[]{connection.debugId});
        } else {
            connection.rollback();
        }
        connection.setReadOnly(false);
    }
}

