/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.dataset.status;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class LastBuildPlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedDataset> {
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;

    public LastBuildPlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public Class<SerializedDataset> getInputType() {
        return SerializedDataset.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, SerializedDataset dataset) throws PlaceholderExpectedException {
        try {
            ReadOnlyJobsInternalDB.DatasetBuild lastBuild = this.jobsDBService.getLatestBuildForDataset(dataset.getProjectKey(), dataset.name);
            if (lastBuild == null) {
                return new PlaceholderOutput.Text("No build recorded");
            }
            return PlaceholderOutputFactory.makeDate(new Date(lastBuild.buildEndTime));
        }
        catch (SQLException e) {
            throw PlaceholderExpectedException.createWithLog("Error while trying to read last build time for dataset " + dataset.getFullName(), e);
        }
    }
}

