/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.resolver;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.ExportOutputExecutor;
import com.dataiku.dip.docgen.resolver.GenericPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableUnionPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.docgen.resolver.PlaceholderStore;
import com.dataiku.dip.docgen.resolver.ResolvedResult;
import com.dataiku.dip.docgen.resolver.UnresolvedPlaceholder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class PlaceholderResolver<DocGenContext> {
    private final PlaceholderStore<DocGenContext> placeholderStore;
    private final DocGenContext docGenContext;
    private final InfoMessage.InfoMessages messages;
    private final ExportOutputExecutor exportOutputExecutor;
    private final Map<String, Object> variableValues = new LinkedHashMap<String, Object>();
    public final Map<String, String> variableReplacements = new HashMap<String, String>();
    private static final Logger logger = Logger.getLogger((String)"dku.docgen");

    public PlaceholderResolver(DocGenContext context, PlaceholderStore<DocGenContext> placeholderStore, InfoMessage.InfoMessages messages, ExportOutputExecutor exportOutputExecutor) {
        this.docGenContext = context;
        this.placeholderStore = placeholderStore;
        this.messages = messages;
        this.exportOutputExecutor = exportOutputExecutor;
    }

    public List<ResolvedResult> resolve(List<UnresolvedPlaceholder> placeholders) {
        return placeholders.stream().map(this::resolve).collect(Collectors.toList());
    }

    private ResolvedResult resolve(UnresolvedPlaceholder placeholder) {
        if (placeholder instanceof UnresolvedPlaceholder.Simple) {
            return this.resolveSimple((UnresolvedPlaceholder.Simple)placeholder);
        }
        if (placeholder instanceof UnresolvedPlaceholder.Table) {
            return this.resolveTable((UnresolvedPlaceholder.Table)placeholder);
        }
        if (placeholder instanceof UnresolvedPlaceholder.If) {
            return this.resolveIf((UnresolvedPlaceholder.If)placeholder);
        }
        if (placeholder instanceof UnresolvedPlaceholder.Foreach) {
            return this.resolveForeach((UnresolvedPlaceholder.Foreach)placeholder);
        }
        throw new IllegalStateException("Unknown placeholder type");
    }

    private ResolvedResult resolveTable(UnresolvedPlaceholder.Table placeholder) {
        return new ResolvedResult.Virtual(this.resolve(placeholder.children));
    }

    private ResolvedResult resolveSimple(UnresolvedPlaceholder.Simple placeholder) {
        FoundPlaceholder<GenericPlaceholder.SimplePlaceholder> ph = this.findBestMatchingPlaceholder(placeholder.name, this.placeholderStore::getSimplePlaceholder);
        if (ph == null) {
            ph = this.getSpecialPlaceholder(placeholder.name);
        }
        if (ph == null) {
            this.addStandardWarningMessage(placeholder.name + " couldn't be resolved", "You may have a typo in your template, please refer to the documentation for supported placeholders");
            return new ResolvedResult.Remove(placeholder.name);
        }
        try {
            PlaceholderOutput output = (PlaceholderOutput)((GenericPlaceholder.SimplePlaceholder)ph.placeholder).resolveObject(this.docGenContext, ph.value);
            if (output instanceof PlaceholderOutput.Export) {
                return this.exportOutputExecutor.registerAndGetResolvedResult((PlaceholderOutput.Export)output, placeholder.name);
            }
            return output.toResolvedResult(placeholder.name);
        }
        catch (PlaceholderExpectedException e) {
            this.addExpectedExceptionWarningMessage(placeholder.name, e);
            return new ResolvedResult.Remove(placeholder.name);
        }
        catch (Exception e) {
            this.addStandardErrorMessage(placeholder.name, e);
            return new ResolvedResult.Remove(placeholder.name);
        }
    }

    private ResolvedResult resolveIf(UnresolvedPlaceholder.If placeholder) {
        String resolvedValue;
        FoundPlaceholder<GenericPlaceholder.SimplePlaceholder> phUnchecked = this.findBestMatchingPlaceholder(placeholder.lefthand, this.placeholderStore::getSimplePlaceholder);
        if (phUnchecked == null) {
            phUnchecked = this.getSpecialPlaceholder(placeholder.lefthand);
        }
        if (phUnchecked == null) {
            this.addStandardWarningMessage(placeholder.lefthand + " couldn't be resolved", "You may have a typo in your template, please refer to the documentation for supported placeholders");
            return new ResolvedResult.Remove(placeholder.lefthand);
        }
        if (!(phUnchecked.placeholder instanceof GenericPlaceholder.TextPlaceholder)) {
            this.addStandardWarningMessage(placeholder.lefthand + " cannot be resolved as a conditional placeholder", "Please refer to the documentation to see which are the supported placeholders.");
            return new ResolvedResult.Remove(placeholder.lefthand);
        }
        GenericPlaceholder.TextPlaceholder conditionalPlaceholder = (GenericPlaceholder.TextPlaceholder)phUnchecked.placeholder;
        try {
            resolvedValue = ((PlaceholderOutput.Text)conditionalPlaceholder.resolveObject(this.docGenContext, (Object)phUnchecked.value)).value;
        }
        catch (PlaceholderExpectedException e) {
            this.addExpectedExceptionWarningMessage(placeholder.lefthand, e);
            return new ResolvedResult.Remove(placeholder.lefthand);
        }
        catch (Exception e) {
            this.addStandardErrorMessage(placeholder.lefthand, e);
            return new ResolvedResult.Remove(placeholder.lefthand);
        }
        if (placeholder.isFulfilled(resolvedValue)) {
            return new ResolvedResult.Strip(placeholder.lefthand, this.resolve(placeholder.children));
        }
        return new ResolvedResult.Remove(placeholder.lefthand);
    }

    private ResolvedResult resolveForeach(UnresolvedPlaceholder.Foreach placeholder) {
        Collection resolvedValues;
        FoundPlaceholder<GenericPlaceholder.IterablePlaceholder> ph = this.findBestMatchingPlaceholder(placeholder.iterable, this.placeholderStore::getIterablePlaceholder);
        if (ph == null) {
            this.addStandardWarningMessage(placeholder.iterable + " is not a valid iterable placeholder", "Only specific tags are allowed to be used in iterable placeholders.");
            return new ResolvedResult.Remove(placeholder.variable);
        }
        if (!placeholder.variable.startsWith("$") || placeholder.variable.indexOf(46) != -1) {
            this.addStandardWarningMessage("Invalid variable name: " + placeholder.variable, "All variable names in iterable placeholders must start with $ and must not contain any dot (.)");
            return new ResolvedResult.Remove(placeholder.variable);
        }
        if (this.variableReplacements.containsKey(placeholder.variable)) {
            this.addStandardWarningMessage(placeholder.variable + " is already in use", "Having two nested iterable placeholders with the same variable name is not supported.");
            return new ResolvedResult.Remove(placeholder.variable);
        }
        try {
            String replacement = ((GenericPlaceholder.IterablePlaceholder)ph.placeholder).getDescription().replacement;
            resolvedValues = ((Collection)((GenericPlaceholder.IterablePlaceholder)ph.placeholder).resolveObject(this.docGenContext, ph.value)).stream().map(val -> {
                if (val instanceof IterableUnionPlaceholder.ValueReplacementPair) {
                    return (IterableUnionPlaceholder.ValueReplacementPair)val;
                }
                return new IterableUnionPlaceholder.ValueReplacementPair(val, replacement);
            }).collect(Collectors.toList());
        }
        catch (PlaceholderExpectedException e) {
            this.addExpectedExceptionWarningMessage(placeholder.iterable, e);
            return new ResolvedResult.Remove(placeholder.variable);
        }
        catch (Exception e) {
            this.addStandardErrorMessage(placeholder.iterable, e);
            return new ResolvedResult.Remove(placeholder.variable);
        }
        ArrayList<ResolvedResult.Virtual> iterationChildren = new ArrayList<ResolvedResult.Virtual>();
        for (IterableUnionPlaceholder.ValueReplacementPair pair : resolvedValues) {
            this.variableReplacements.put(placeholder.variable, pair.replacement);
            this.variableValues.put(placeholder.variable, pair.value);
            ResolvedResult.Virtual resolvedContent = new ResolvedResult.Virtual(this.resolve(placeholder.children));
            iterationChildren.add(resolvedContent);
        }
        this.variableValues.remove(placeholder.variable);
        this.variableReplacements.remove(placeholder.variable);
        return new ResolvedResult.Repeat(placeholder.variable, iterationChildren);
    }

    private <PType> FoundPlaceholder<PType> findBestMatchingPlaceholder(String name, Function<String, PType> getFromStore) {
        String suffix;
        if (!name.startsWith("$")) {
            PType ph = getFromStore.apply(name);
            return ph == null ? null : new FoundPlaceholder<PType>(ph, null);
        }
        String variableName = name.split(Pattern.quote("."))[0];
        String string = suffix = name.indexOf(46) == -1 ? "" : name.substring(name.indexOf(46));
        if (!this.variableValues.containsKey(variableName)) {
            return null;
        }
        PType ph = getFromStore.apply(this.variableReplacements.get(variableName) + suffix);
        if (ph != null) {
            return new FoundPlaceholder<PType>(ph, this.variableValues.get(variableName));
        }
        return null;
    }

    @Nullable
    private FoundPlaceholder<GenericPlaceholder.SimplePlaceholder<? super DocGenContext, ?, ?>> getSpecialPlaceholder(String name) {
        if (name.startsWith("$") && name.split(Pattern.quote(".")).length == 2 && name.endsWith(".$type")) {
            final String variableName = name.split(Pattern.quote("."))[0];
            if (!this.variableValues.containsKey(variableName)) {
                return null;
            }
            return new FoundPlaceholder(new GenericPlaceholder.TextPlaceholder<DocGenContext, Object>(){

                @Override
                public PlaceholderOutput.Text resolve(DocGenContext docGenContext, Object resolvedVariable) throws PlaceholderExpectedException {
                    return new PlaceholderOutput.Text(PlaceholderResolver.this.variableReplacements.get(variableName));
                }

                @Override
                public Class<Object> getInputType() {
                    return Object.class;
                }
            }, this.variableValues.get(variableName));
        }
        return null;
    }

    private void addStandardWarningMessage(String title, String details) {
        InfoMessage warningMessage = InfoMessage.warning((String)title, (String)details);
        this.messages.addMessage(warningMessage);
        logger.warn((Object)warningMessage.message);
    }

    private void addExpectedExceptionWarningMessage(String name, PlaceholderExpectedException e) {
        String title = e instanceof BadTemplatePlaceholderException ? "Incorrect usage of placeholder " + name : name + " couldn't be resolved";
        InfoMessage warningMessage = InfoMessage.warning((String)title, (String)("Cause: " + e.getMessage() + this.getFullContextInfo()));
        this.messages.addMessage(warningMessage);
        logger.warn((Object)warningMessage.message);
    }

    private void addStandardErrorMessage(String name, Throwable e) {
        InfoMessage errorMessage = InfoMessage.warning((String)("An unexpected error happened while resolving " + name), (String)(e.getMessage() + this.getFullContextInfo()));
        this.messages.addMessage(errorMessage);
        logger.error((Object)errorMessage.title, e);
    }

    private String getFullContextInfo() {
        StringBuilder sb = new StringBuilder();
        this.variableValues.forEach((varName, value) -> {
            try {
                this.placeholderStore.resolveErrorContextDescription(value).ifPresent(description -> sb.append("<br/>- ").append(StringEscapeUtils.escapeHtml((String)(varName + " = " + description))));
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error while building Document Generator error context", (Throwable)e);
            }
        });
        if (!sb.isEmpty()) {
            return "<br/>Context:" + String.valueOf(sb);
        }
        return "";
    }

    private static class FoundPlaceholder<T> {
        T placeholder;
        Object value;

        public FoundPlaceholder(T placeholder, Object value) {
            this.placeholder = placeholder;
            this.value = value;
        }
    }
}

