/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.engine;

import com.dataiku.dip.engine.AsyncCloser;

public abstract class SmoothlyClosableRunner<Runner extends AutoCloseable>
implements AutoCloseable {
    protected Runner runner;
    protected int refCount;
    private AsyncCloser asyncCloser = new AsyncCloser();

    public SmoothlyClosableRunner(Runner runner) {
        this.runner = runner;
        this.refCount = 1;
    }

    public void setAsyncCloser(AsyncCloser asyncCloser) {
        this.asyncCloser = asyncCloser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decRefCount() {
        SmoothlyClosableRunner smoothlyClosableRunner = this;
        synchronized (smoothlyClosableRunner) {
            this.assertNotClosed();
            --this.refCount;
        }
        if (this.refCount == 0 && this.runner != null) {
            try {
                String resourceName = String.format("%s::%s", this.getClass().getSimpleName(), this.runner.getClass().getSimpleName());
                this.asyncCloser.close((AutoCloseable)this.runner, resourceName);
            }
            finally {
                this.runner = null;
            }
        }
    }

    public synchronized void incRefCount() {
        this.assertNotClosed();
        ++this.refCount;
    }

    protected void assertNotClosed() {
        if (this.refCount == 0) {
            throw new IllegalStateException("Smoothly closable runner is dead");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        SmoothlyClosableRunner smoothlyClosableRunner = this;
        synchronized (smoothlyClosableRunner) {
            if (this.refCount == 0) {
                return;
            }
        }
        this.decRefCount();
    }
}

