/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.CustomPythonExporter;
import com.dataiku.dip.export.CustomPythonExporterDesc;
import com.dataiku.dip.export.ExportOption;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonExportersService
extends CustomPythonElementService<CustomPythonExporterDesc, LoadedPythonExporter> {
    @Override
    public String getFolderName() {
        return "python-exporters";
    }

    @Override
    public String getPrefix() {
        return "exporter";
    }

    @Override
    protected String getCodeExtension(LoadedPythonExporter desc) {
        return ".py";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "exporter_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomPythonExporterDesc> getDescClass() {
        return CustomPythonExporterDesc.class;
    }

    @Override
    public Class<LoadedPythonExporter> getLoadedDescClass() {
        return LoadedPythonExporter.class;
    }

    @Override
    protected void removeElement(LoadedPythonExporter desc) {
        CustomExportersRegistry.deregister(desc.exporterType);
    }

    @Override
    protected LoadedPythonExporter load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonExporter loaded = new LoadedPythonExporter(elementType, pluginId, elementId, (CustomPythonExporterDesc)JSON.parseFile((File)file, CustomPythonExporterDesc.class));
        CustomExportersRegistry.register(new CustomPythonExporter(loaded, this));
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonExporterDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonExportersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (desc.exportOptions != null) {
                    for (ExportOption o : desc.exportOptions) {
                        if (o == null) {
                            this.withWarning("Null export option. Check there is no trailing comma.");
                            continue;
                        }
                        if (!StringUtils.isBlank((String)o.id)) continue;
                        this.withFatal("Export option has no id.");
                    }
                }
                return this.messages;
            }
        }.validate();
    }
}

