/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ExportDAO {
    private static Logger logger = Logger.getLogger((String)"dku.dao.exports");

    public File exportsFolder() {
        return ApplicationConfigurator.getFile((String)"exports");
    }

    public File exportFolder(String exportId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"exports", exportId});
    }

    public File exportStatusFile(String exportId) {
        return new File(this.exportFolder(exportId), "status.json");
    }

    public File exportDataDir(String exportId) {
        return new File(this.exportFolder(exportId), "data");
    }

    public ExportDAO() throws IOException {
        File folder = this.exportsFolder();
        if (!folder.isDirectory()) {
            DKUFileUtils.mkdirs((File)folder);
        }
    }

    public synchronized List<ExportStatus> listExports(String userFilter) throws IOException {
        ArrayList<ExportStatus> out = new ArrayList<ExportStatus>();
        if (!this.exportsFolder().isDirectory()) {
            logger.warn((Object)"Export folder does not exist");
            return out;
        }
        for (File dir : this.exportsFolder().listFiles()) {
            File statusFile;
            if (!dir.isDirectory() || dir.isHidden()) continue;
            String exportId = dir.getName();
            if (userFilter != null && !exportId.startsWith(userFilter + "_") || !(statusFile = this.exportStatusFile(exportId)).isFile()) continue;
            ExportStatus status = this.getStatus(exportId);
            if ((userFilter == null || !userFilter.equals(status.userId)) && userFilter != null) continue;
            out.add(status);
        }
        return out;
    }

    public static String generateExportId(String userId) {
        return userId + "_" + SecretKeyGenerator.generateSmall();
    }

    public synchronized void removeExport(String exportId) throws IOException {
        DKUFileUtils.forceDelete((File)this.exportFolder(exportId));
    }

    public synchronized void writeStatus(ExportStatus status) throws IOException {
        File folder = this.exportFolder(status.exportId);
        if (folder.isDirectory()) {
            DKUFileUtils.mkdirs((File)folder);
        }
        File exportStatusFile = this.exportStatusFile(status.exportId);
        File exportStatusFileTmp = new File(exportStatusFile.getParentFile(), exportStatusFile.getName() + ".tmp");
        JSON.prettyToFile((Object)status, (File)exportStatusFileTmp);
        if (DKUtils.isOsWindows() && exportStatusFile.exists()) {
            Files.delete(exportStatusFile.toPath());
        }
        if (!exportStatusFileTmp.renameTo(exportStatusFile)) {
            throw new IOException("Failed to update the export status");
        }
    }

    public synchronized ExportStatus getStatus(String exportId) throws IOException {
        File sf = this.exportStatusFile(exportId);
        if (sf.isFile()) {
            return (ExportStatus)JSON.parseFile((File)sf, ExportStatus.class);
        }
        throw new IOException("Unable to read export status file");
    }
}

