/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import java.util.Random;

public class Sampler
extends FilteringProcessorOutput {
    private DatasetSelection selection;
    private long emittedRecords;
    private Random rnd = new Random();
    private boolean emittedLastRow;

    public Sampler(DatasetSelection selection, ProcessorOutput downstream) {
        super(downstream);
        Sampler.supportsSelection(selection);
        this.selection = selection;
        this.emittedRecords = 0L;
    }

    public static void supportsSelection(DatasetSelection selection) {
        switch (selection.samplingMethod) {
            case FULL: 
            case HEAD_SEQUENTIAL: 
            case RANDOM_FIXED_RATIO: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported sampling method for streamed input");
            }
        }
        switch (selection.partitionSelectionMethod) {
            case ALL: {
                break;
            }
            case LATEST_N: 
            case SELECTED: {
                throw new RuntimeException("Unsupported partition selection for streamed input");
            }
        }
    }

    private void emitLast() throws Exception {
        if (!this.emittedLastRow) {
            this.emittedLastRow = true;
            super.lastRowEmitted();
        }
    }

    public boolean sampleIsComplete() {
        return this.emittedLastRow;
    }

    public void emitRow(Row row) throws Exception {
        if (this.selection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL && this.emittedRecords >= this.selection.maxRecords) {
            this.emitLast();
        } else if (this.selection.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            double v = this.rnd.nextDouble();
            if (v < this.selection.targetRatio) {
                this.downstream.emitRow(row);
                ++this.emittedRecords;
            }
        } else {
            this.downstream.emitRow(row);
            ++this.emittedRecords;
        }
    }

    public void lastRowEmitted() throws Exception {
        this.emitLast();
    }
}

