/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class HiveMetastoreTablesHandler {
    protected final AuthCtx authCtx;
    protected final MetastoreInspectionService.MetastoreInspector hiveServer2SchemaHandler;
    protected final List<SimpleKeyValue> collectedExtraConf = Lists.newArrayList();

    protected HiveMetastoreTablesHandler(AuthCtx authCtx, MetastoreInspectionService.MetastoreInspector hiveServer2SchemaHandler) {
        this.authCtx = authCtx;
        this.hiveServer2SchemaHandler = hiveServer2SchemaHandler;
    }

    public abstract void preProcessSource(FlowDataset var1, Dataset var2, String var3, List<Partition> var4) throws IOException, InterruptedException, DKUSecurityException, CodedException;

    public abstract void preProcessTarget(FlowDataset var1, Dataset var2, String var3, Partition var4) throws Exception;

    public abstract String getCreationScript();

    public abstract void prepare() throws IOException;

    public abstract void postProcess() throws IOException;

    public abstract void setHDFSPathPrefix(String var1);

    public abstract boolean shouldPrefixWithDbInInsert();

    public List<SimpleKeyValue> getCollectedExtraConf() {
        return this.collectedExtraConf;
    }

    protected String getUseDatabaseHeader(Dataset dataset, boolean createIfNeeded, String overrideDbName) throws IOException {
        String datasetDbName = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(dataset);
        String dbName = StringUtils.isBlank((String)overrideDbName) ? datasetDbName : overrideDbName;
        Object command = createIfNeeded ? "CREATE DATABASE IF NOT EXISTS `" + dbName + "`;\n" : "";
        return (String)command + "USE `" + dbName + "`;";
    }

    protected String getCreateTableHeader(Dataset dataset, String tableName, String location) throws IOException, DKUSecurityException, CodedException {
        String createTable = "CREATE EXTERNAL TABLE IF NOT EXISTS  `" + tableName + "` (" + HiveSchemaHandler.tableDefFromSchema(dataset.getSchema()) + ")";
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        if (scheme.isPartitioned()) {
            createTable = createTable + " PARTITIONED BY (" + HiveSchemaHandler.getPartitionedByString(scheme) + ")";
        }
        createTable = createTable + HiveSchemaHandler.getRowFormat((Dataset)dataset, (String)dataset.getFullName(), (MetastoreInspectionService.MetastoreKind)this.hiveServer2SchemaHandler.getMetastoreKind()).asScript;
        if (location != null) {
            createTable = createTable + "  LOCATION '" + location + "' \n";
        }
        createTable = createTable + HiveSchemaHandler.getTableProperties(this.authCtx, dataset);
        return createTable + ";";
    }

    protected String getCreateFakeTableHeader(Dataset dataset, String tableName) {
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        Schema schemaWithoutPartitioningColumns = new Schema();
        for (SchemaColumn column : dataset.getSchema().getColumns()) {
            if (scheme.isPartitioned() && scheme.getDimensionNamesSet().contains(column.getName())) continue;
            schemaWithoutPartitioningColumns.addColumn(column);
        }
        String createTable = "CREATE EXTERNAL TABLE IF NOT EXISTS  `" + tableName + "` (" + HiveSchemaHandler.tableDefFromSchema(schemaWithoutPartitioningColumns) + ")";
        if (scheme.isPartitioned()) {
            createTable = createTable + " PARTITIONED BY (" + HiveSchemaHandler.getPartitionedByString(scheme) + ")";
        }
        createTable = createTable + " STORED AS PARQUET ";
        return createTable + ";";
    }

    protected String getCreatePartition(Dataset dataset, String tableName, Partition partition, String fqTmpLocation) {
        String addTargetPartition = "ALTER TABLE `" + tableName + "` ADD IF NOT EXISTS PARTITION ";
        ArrayList<CallSite> specs = new ArrayList<CallSite>();
        for (String dimName : dataset.getPartitioningSchema().getDimensionNames()) {
            DimensionValue dimVal = (DimensionValue)partition.getDimensionValues().get(dimName);
            String spec = "`" + dimName + "`='" + dimVal.id() + "'";
            specs.add((CallSite)((Object)spec));
        }
        addTargetPartition = addTargetPartition + "(" + StringUtils.join(specs, (String)",") + ")";
        addTargetPartition = addTargetPartition + " LOCATION '" + fqTmpLocation + "';";
        return addTargetPartition;
    }
}

