/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.hive.GlueMetastoreUtils;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogInternalDB;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogPartition;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.GlueClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.Column;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.Database;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetTablesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetTablesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.Table;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.PartitionSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetastoreInspectionService {
    @Autowired
    private HiveServer2ConnectionPoolService connectionPoolService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.hiverserver2.schema");

    public boolean metastoreSupportEnabled(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        return this.getMetastoreKind(authCtx, projectKey) != null;
    }

    public MetastoreKind getMetastoreKind(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.MetastoreCatalogsSettings metastoreCatalogsSettings = this.generalSettingsDAO.getUnsafeAutoTXN().metastoreCatalogsSettings;
        switch (metastoreCatalogsSettings.synchronizeTo.flavor) {
            case AWS_GLUE: {
                return MetastoreKind.AWS_GLUE;
            }
            case DSS_INTERNAL: {
                return MetastoreKind.DSS;
            }
            case HIVESERVER2: {
                ClusterSettings clusterSettings = null;
                clusterSettings = projectKey == null ? new ClusterSelector().selectGlobal() : new ClusterSelector().selectForProject(authCtx, projectKey);
                if (HiveConfigurator.isHiveInstalled() && clusterSettings.getHiveSettings().enabled) {
                    return MetastoreKind.HIVE_VIA_HS2;
                }
                return null;
            }
        }
        throw new Error("unreachable");
    }

    public MetastoreInspector newInspector(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        MetastoreKind metastoreKind = this.getMetastoreKind(authCtx, projectKey);
        Preconditions.checkNotNull((Object)((Object)metastoreKind));
        return this.newInspector(metastoreKind);
    }

    public MetastoreInspector newInspector(MetastoreKind metastoreKind) throws IOException {
        switch (metastoreKind) {
            case HIVE_VIA_HS2: {
                return new HiveServer2MetastoreInspector();
            }
            case AWS_GLUE: {
                return new AWSGlueMetastoreInspector();
            }
            case DSS: {
                return new DSSCatalogMetastoreInspector();
            }
        }
        throw new Error("unreachable");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static boolean hasProjectPrivilege_autoTxn(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        switch (1.$SwitchMap$com$dataiku$dip$logging$MainLoggingConfigurator$ProcessType[ClusterSelector.getContext().ordinal()]) {
            case 1: 
            case 2: {
                permissionsService = (IPermissionsService)SpringUtils.getBean(IPermissionsService.class);
                if (TransactionContext.hasAttachedTransaction()) {
                    return permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
                transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                t = transactionService.beginRead();
                try {
                    var5_15 = permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    return var5_15;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            case 3: {
                throw new UnsupportedOperationException("Cannot access the DSS-as-Hive metastore from containerized jobs");
            }
            case 4: 
            case 5: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());
                        try {
                            var5_17 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl38
                        }
                        catch (Throwable var5_18) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var6_22) {
                                    var5_18.addSuppressed(var6_22);
                                }
                            }
                            throw var5_18;
                        }
                        apiClient.close();
lbl38:
                        // 2 sources

                        return var5_17;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 6: 
            case 7: {
                backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);
                try {
                    var4_13 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)authCtx), "projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                    return var4_13;
                }
                finally {
                    apiClient.close();
                }
            }
        }
        throw new Error("DSS Process type not set, cannot check cluster access");
    }

    public static enum MetastoreKind {
        HIVE_VIA_HS2,
        DSS,
        AWS_GLUE;

    }

    public static interface MetastoreInspector {
        public List<String> listHiveDatabase(String var1, String var2, AuthCtx var3, String var4) throws Exception;

        public List<ConnectionsService.SQLTableWithQuotedName> listSQLTableForConnection(AuthCtx var1, String var2, String var3, String var4) throws Exception;

        public List<String> listHiveTables(String var1, String var2, AuthCtx var3, String var4) throws Exception;

        public boolean isHiveDatabase(String var1, String var2, AuthCtx var3, String var4) throws Exception;

        public boolean isExternalTable(String var1, String var2, String var3, AuthCtx var4, String var5) throws Exception;

        public boolean isHiveTable(String var1, String var2, String var3, AuthCtx var4, String var5) throws Exception;

        public TableSchema getTableSchema(String var1, String var2, String var3, List<Partition> var4, AuthCtx var5, String var6) throws Exception;

        public List<ColumnSchema> listColumns(String var1, String var2, String var3, AuthCtx var4, String var5) throws Exception;

        public MetastoreKind getMetastoreKind();
    }

    public class HiveServer2MetastoreInspector
    implements MetastoreInspector {
        private HiveServer2ConnectionPoolService.HiveServer2Connection takeForMetastore(String clusterId, AuthCtx authCtx, String database, String projectKey) throws Exception {
            return this.takeForMetastore(clusterId, authCtx, database, null, projectKey);
        }

        @Override
        public MetastoreKind getMetastoreKind() {
            return MetastoreKind.HIVE_VIA_HS2;
        }

        public HiveServer2ConnectionPoolService.HiveServer2Connection takeForMetastore(String clusterId, AuthCtx authCtx, String database, List<SimpleKeyValue> hiveconf, String projectKey) throws Exception {
            ArrayList extraConf = Lists.newArrayList();
            if (HadoopFlavorUtils.hiveSupportsMREngine()) {
                extraConf.add(new SimpleKeyValue("hive.execution.engine", "mr"));
            }
            if (hiveconf != null) {
                extraConf.addAll(hiveconf);
            }
            return MetastoreInspectionService.this.connectionPoolService.take(clusterId, authCtx, database, hiveconf, projectKey);
        }

        @Override
        public List<String> listHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            try (HiveServer2ConnectionPoolService.HiveServer2Connection connection = this.takeForMetastore(clusterId, authCtx, database, projectKey);){
                logger.info((Object)("List hive databases from connection on " + database));
                List<String> dbs = SQLUtils.listSchemasCatalogUnaware(connection);
                ArrayList ret = Lists.newArrayList();
                for (String s : dbs) {
                    if (s == null) {
                        s = "";
                    }
                    s = s.trim().toLowerCase(Locale.ENGLISH);
                    ret.add(s);
                }
                ArrayList arrayList = ret;
                return arrayList;
            }
        }

        @Override
        public List<String> listHiveTables(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            try (HiveServer2ConnectionPoolService.HiveServer2Connection connection = this.takeForMetastore(clusterId, authCtx, database, projectKey);){
                ArrayList arrayList;
                block14: {
                    logger.info((Object)("List hive tables on " + database));
                    Statement st2 = connection.createStatement();
                    try {
                        ResultSet rs2 = st2.executeQuery("SHOW TABLES IN `" + database + "`");
                        ArrayList ret = Lists.newArrayList();
                        while (rs2.next()) {
                            String t = rs2.getString(1);
                            if (t == null) {
                                t = "";
                            }
                            ret.add(t);
                        }
                        arrayList = ret;
                        if (st2 == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (st2 != null) {
                            try {
                                st2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    st2.close();
                }
                return arrayList;
            }
        }

        @Override
        public boolean isHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            for (String s : this.listHiveDatabase(clusterId, database, authCtx, projectKey)) {
                if (!s.trim().equalsIgnoreCase(database)) continue;
                return true;
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean isHiveTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public TableSchema getTableSchema(String clusterId, String database, String table, List<Partition> withPartitions, AuthCtx authCtx, String projectKey) throws Exception {
            logger.infoV("Get table schema db=%s table=%s partitions=%s", new Object[]{database, table, withPartitions == null ? null : withPartitions.stream().map(p -> p.id()).collect(Collectors.joining(","))});
            try (HiveServer2ConnectionPoolService.HiveServer2Connection connection = this.takeForMetastore(clusterId, authCtx, database, projectKey);){
                TableSchema tableSchema = HiveSchemaHandler.getTableSchema(database, table, withPartitions, connection, new HiveSQLDialect());
                return tableSchema;
            }
        }

        @Override
        public boolean isExternalTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            TableSchema tableSchema = this.getTableSchema(clusterId, database, table, new ArrayList<Partition>(), authCtx, projectKey);
            if (Sets.newHashSet((Object[])new String[]{"EXTERNAL", "EXTERNAL_TABLE"}).contains(tableSchema.tableType)) {
                return true;
            }
            Map tableParameters = tableSchema.parameters;
            String key = "EXTERNAL";
            return tableParameters.containsKey("EXTERNAL") && Boolean.parseBoolean((String)tableParameters.get("EXTERNAL"));
        }

        @Override
        public List<ColumnSchema> listColumns(String clusterId, String db, String table, AuthCtx authCtx, String projectKey) throws Exception {
            assert (table != null);
            assert (db != null);
            TableSchema tableSchema = this.getTableSchema(clusterId, db, table, new ArrayList<Partition>(), authCtx, projectKey);
            ArrayList allColumns = Lists.newArrayList();
            allColumns.addAll(tableSchema.columns);
            allColumns.addAll(tableSchema.partitionColumns);
            return allColumns;
        }

        @Override
        public List<ConnectionsService.SQLTableWithQuotedName> listSQLTableForConnection(AuthCtx authCtx, String clusterId, String database, String projectKey) throws Exception {
            try (HiveServer2ConnectionPoolService.HiveServer2Connection connection = this.takeForMetastore(clusterId, authCtx, database, projectKey);){
                HiveSQLDialect dialect = new HiveSQLDialect();
                ArrayList<ConnectionsService.SQLTableWithQuotedName> sqlTables = new ArrayList<ConnectionsService.SQLTableWithQuotedName>();
                for (SQLUtils.SQLTable table : SQLUtils.listTables(null, connection, null, database, new HiveSQLDialect())) {
                    sqlTables.add(new ConnectionsService.SQLTableWithQuotedName(table, dialect));
                }
                ArrayList<ConnectionsService.SQLTableWithQuotedName> arrayList = sqlTables;
                return arrayList;
            }
        }
    }

    public static class AWSGlueMetastoreInspector
    implements MetastoreInspector {
        @Override
        public MetastoreKind getMetastoreKind() {
            return MetastoreKind.AWS_GLUE;
        }

        @Override
        public List<String> listHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            ArrayList ret = Lists.newArrayList();
            try (GlueClient client = GlueMetastoreUtils.getClient(authCtx);){
                String nextToken = null;
                do {
                    if (StringUtils.isNotBlank(nextToken)) {
                        logger.info((Object)"paginate database listing");
                    }
                    GetDatabasesRequest.Builder req = GetDatabasesRequest.builder();
                    if (StringUtils.isNotBlank(nextToken)) {
                        req.nextToken(nextToken);
                    }
                    GetDatabasesResponse rep = client.getDatabases((GetDatabasesRequest)req.build());
                    nextToken = rep.nextToken();
                    for (Database db : rep.databaseList()) {
                        ret.add(db.name());
                    }
                } while (StringUtils.isNotBlank((String)nextToken));
            }
            return ret;
        }

        @Override
        public List<ConnectionsService.SQLTableWithQuotedName> listSQLTableForConnection(AuthCtx authCtx, String clusterId, String database, String projectKey) throws Exception {
            ArrayList ret = Lists.newArrayList();
            for (String tbl : this.listHiveTables(clusterId, database, authCtx, projectKey)) {
                HiveSQLDialect dialect = new HiveSQLDialect();
                ret.add(new ConnectionsService.SQLTableWithQuotedName(null, database, tbl, dialect, true));
            }
            return ret;
        }

        @Override
        public List<String> listHiveTables(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            ArrayList ret = Lists.newArrayList();
            if (StringUtils.isBlank((String)database)) {
                for (String db : this.listHiveDatabase(clusterId, database, authCtx, projectKey)) {
                    ret.addAll(this.listHiveTables(clusterId, db, authCtx, projectKey));
                }
            } else {
                try (GlueClient client = GlueMetastoreUtils.getClient(authCtx);){
                    String nextToken = null;
                    do {
                        if (StringUtils.isNotBlank(nextToken)) {
                            logger.info((Object)"paginate table listing");
                        }
                        GetTablesRequest.Builder req = GetTablesRequest.builder();
                        req.databaseName(database);
                        if (StringUtils.isNotBlank(nextToken)) {
                            req.nextToken(nextToken);
                        }
                        GetTablesResponse rep = client.getTables((GetTablesRequest)req.build());
                        nextToken = rep.nextToken();
                        for (Table db : rep.tableList()) {
                            ret.add(db.name());
                        }
                    } while (StringUtils.isNotBlank((String)nextToken));
                }
            }
            return ret;
        }

        @Override
        public boolean isHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            boolean bl;
            block8: {
                GetDatabaseRequest.Builder req = GetDatabaseRequest.builder();
                req.name(database);
                GlueClient glueClient = GlueMetastoreUtils.getClient(authCtx);
                try {
                    boolean bl2 = bl = glueClient.getDatabase((GetDatabaseRequest)req.build()) != null;
                    if (glueClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (glueClient != null) {
                            try {
                                glueClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (EntityNotFoundException e) {
                        return false;
                    }
                }
                glueClient.close();
            }
            return bl;
        }

        @Override
        public boolean isExternalTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            GetTableRequest.Builder req = GetTableRequest.builder();
            req.databaseName(database);
            req.name(table);
            try {
                Table t;
                try (GlueClient glueClient = GlueMetastoreUtils.getClient(authCtx);){
                    t = glueClient.getTable((GetTableRequest)req.build()).table();
                }
                return t != null && t.tableType().equals("EXTERNAL_TABLE");
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }

        @Override
        public boolean isHiveTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            boolean bl;
            block8: {
                GetTableRequest.Builder req = GetTableRequest.builder();
                req.databaseName(database);
                req.name(table);
                GlueClient glueClient = GlueMetastoreUtils.getClient(authCtx);
                try {
                    boolean bl2 = bl = glueClient.getTable((GetTableRequest)req.build()).table() != null;
                    if (glueClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (glueClient != null) {
                            try {
                                glueClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (EntityNotFoundException e) {
                        return false;
                    }
                }
                glueClient.close();
            }
            return bl;
        }

        @Override
        public TableSchema getTableSchema(String clusterId, String database, String table, List<Partition> withPartitions, AuthCtx authCtx, String projectKey) throws Exception {
            TableSchema schema;
            GetTableRequest.Builder req = GetTableRequest.builder();
            req.databaseName(database);
            req.name(table);
            try (GlueClient client = GlueMetastoreUtils.getClient(authCtx);){
                ColumnSchema cs2;
                Table t = client.getTable((GetTableRequest)req.build()).table();
                schema = new TableSchema();
                schema.name = t.name();
                schema.tableType = t.tableType();
                if (t.parameters() != null) {
                    schema.parameters.putAll(t.parameters());
                }
                for (Column c2 : t.storageDescriptor().columns()) {
                    cs2 = new ColumnSchema();
                    cs2.name = c2.name();
                    cs2.comment = c2.comment();
                    cs2.type = c2.type();
                    cs2.partition = false;
                    schema.columns.add(cs2);
                }
                if (t.partitionKeys() != null) {
                    for (Column c2 : t.partitionKeys()) {
                        cs2 = new ColumnSchema();
                        cs2.name = c2.name();
                        cs2.comment = c2.comment();
                        cs2.type = c2.type();
                        cs2.partition = true;
                        schema.partitionColumns.add(cs2);
                    }
                }
                schema.inputFormat = t.storageDescriptor().inputFormat();
                schema.outputFormat = t.storageDescriptor().outputFormat();
                schema.serde = t.storageDescriptor().serdeInfo().serializationLibrary();
                schema.location = t.storageDescriptor().location();
                if (t.storageDescriptor().parameters() != null) {
                    schema.serdeProps.putAll(t.storageDescriptor().parameters());
                }
                if (t.storageDescriptor().serdeInfo().parameters() != null) {
                    schema.serdeProps.putAll(t.storageDescriptor().serdeInfo().parameters());
                }
                if (!schema.partitionColumns.isEmpty()) {
                    String nextToken = null;
                    do {
                        if (StringUtils.isNotBlank(nextToken)) {
                            logger.info((Object)"paginate partition listing");
                        }
                        GetPartitionsRequest.Builder req2 = GetPartitionsRequest.builder();
                        req2.databaseName(database);
                        req2.tableName(table);
                        if (StringUtils.isNotBlank(nextToken)) {
                            req2.nextToken(nextToken);
                        }
                        GetPartitionsResponse rep2 = client.getPartitions((GetPartitionsRequest)req2.build());
                        nextToken = rep2.nextToken();
                        for (com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.Partition p : rep2.partitions()) {
                            PartitionSchema ps2 = new PartitionSchema();
                            ps2.keys.addAll(p.values());
                            ps2.location = p.storageDescriptor().location();
                            schema.partitions.add(ps2);
                        }
                    } while (StringUtils.isNotBlank((String)nextToken));
                }
            }
            return schema;
        }

        @Override
        public List<ColumnSchema> listColumns(String clusterId, String db, String table, AuthCtx authCtx, String projectKey) throws Exception {
            assert (table != null);
            assert (db != null);
            TableSchema tableSchema = this.getTableSchema(clusterId, db, table, new ArrayList<Partition>(), authCtx, projectKey);
            ArrayList allColumns = Lists.newArrayList();
            allColumns.addAll(tableSchema.columns);
            allColumns.addAll(tableSchema.partitionColumns);
            return allColumns;
        }
    }

    public class DSSCatalogMetastoreInspector
    implements MetastoreInspector {
        @Autowired
        private DSSHiveCatalogInternalDB db;

        public DSSCatalogMetastoreInspector() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public MetastoreKind getMetastoreKind() {
            return MetastoreKind.DSS;
        }

        @Override
        public List<String> listHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            return this.db.listDatabases();
        }

        @Override
        public List<ConnectionsService.SQLTableWithQuotedName> listSQLTableForConnection(AuthCtx authCtx, String clusterId, String database, String projectKey) throws Exception {
            ArrayList ret = Lists.newArrayList();
            for (String tbl : this.listHiveTables(clusterId, database, authCtx, projectKey)) {
                HiveSQLDialect dialect = new HiveSQLDialect();
                ret.add(new ConnectionsService.SQLTableWithQuotedName(null, database, tbl, dialect, true));
            }
            return ret;
        }

        private boolean projectExist(String projectKey) throws IOException {
            ProjectsService projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
            try (Transaction t = TransactionContext.hasAttachedTransaction() ? null : MetastoreInspectionService.this.transactionService.beginRead();){
                SerializedProject project = projectsService.getOrNullUnsafe(projectKey);
                boolean bl = project != null;
                return bl;
            }
        }

        @Override
        public List<String> listHiveTables(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            ArrayList ret = Lists.newArrayList();
            HashSet<String> missingProjects = new HashSet<String>();
            HashMap accessibleProjects = Maps.newHashMap();
            accessibleProjects.put(projectKey, true);
            for (DSSHiveCatalogTable t : this.db.listTables(database)) {
                if (missingProjects.contains(t.projectKey)) continue;
                Boolean accessible = (Boolean)accessibleProjects.get(t.projectKey);
                if (accessible == null) {
                    if (!this.projectExist(t.projectKey)) {
                        missingProjects.add(t.projectKey);
                        logger.warn((Object)String.format("Orphan Hive tables skipped, project %s does not exist anymore.", t.projectKey));
                        continue;
                    }
                    accessible = MetastoreInspectionService.hasProjectPrivilege_autoTxn(authCtx, t.projectKey);
                    if (!accessible.booleanValue()) {
                        logger.warn((Object)String.format("Hive tables skipped as no sufficient rights on project %s.", t.projectKey));
                    }
                    accessibleProjects.put(t.projectKey, accessible);
                }
                if (!accessible.booleanValue()) continue;
                ret.add(t.tableName);
            }
            return ret;
        }

        @Override
        public boolean isHiveDatabase(String clusterId, String database, AuthCtx authCtx, String projectKey) throws Exception {
            return this.db.databaseExists(database);
        }

        @Override
        public boolean isExternalTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            return this.isHiveTable(clusterId, database, table, authCtx, projectKey);
        }

        @Override
        public boolean isHiveTable(String clusterId, String database, String table, AuthCtx authCtx, String projectKey) throws Exception {
            String tableProjectKey = this.db.getProjectKeyOfTableOrNull(database, table);
            if (tableProjectKey == null) {
                return false;
            }
            if (StringUtils.equals((String)projectKey, (String)tableProjectKey)) {
                return true;
            }
            return MetastoreInspectionService.hasProjectPrivilege_autoTxn(authCtx, tableProjectKey);
        }

        @Override
        public TableSchema getTableSchema(String clusterId, String database, String table, List<Partition> withPartitions, AuthCtx authCtx, String projectKey) throws Exception {
            ColumnSchema cs2;
            DSSHiveCatalogTable t = this.db.getTable(database, table);
            if (!StringUtils.equals((String)projectKey, (String)t.projectKey) && !MetastoreInspectionService.hasProjectPrivilege_autoTxn(authCtx, t.projectKey)) {
                throw new DKUSecurityException("No access to table from project " + t.projectKey);
            }
            TableSchema schema = new TableSchema();
            schema.name = t.tableName;
            schema.tableType = "EXTERNAL_TABLE";
            for (SchemaColumn c2 : t.sd.columns) {
                cs2 = new ColumnSchema();
                cs2.name = c2.getName();
                cs2.comment = c2.comment;
                cs2.type = HiveSchemaHandler.hiveTypeFromSchemaType(c2);
                cs2.partition = false;
                schema.columns.add(cs2);
            }
            for (SchemaColumn c2 : t.partitionKeys) {
                cs2 = new ColumnSchema();
                cs2.name = c2.getName();
                cs2.comment = c2.comment;
                cs2.type = HiveSchemaHandler.hiveTypeFromSchemaType(c2);
                cs2.partition = true;
                schema.partitionColumns.add(cs2);
            }
            schema.inputFormat = t.sd.inputFormat;
            schema.outputFormat = t.sd.outputFormat;
            schema.serde = t.sd.serdeName;
            schema.location = t.sd.location;
            schema.serdeProps.putAll(t.sd.serdeParams);
            if (!schema.partitionColumns.isEmpty()) {
                for (DSSHiveCatalogPartition p : this.db.listPartitions(database, table)) {
                    PartitionSchema ps2 = new PartitionSchema();
                    for (String v : p.hivePartitionName.split(",")) {
                        String[] chunks = v.split("=");
                        ps2.keys.add(chunks[1]);
                    }
                    ps2.location = p.location;
                    schema.partitions.add(ps2);
                }
            }
            return schema;
        }

        @Override
        public List<ColumnSchema> listColumns(String clusterId, String db, String table, AuthCtx authCtx, String projectKey) throws Exception {
            assert (table != null);
            assert (db != null);
            TableSchema tableSchema = this.getTableSchema(clusterId, db, table, new ArrayList<Partition>(), authCtx, projectKey);
            ArrayList allColumns = Lists.newArrayList();
            allColumns.addAll(tableSchema.columns);
            allColumns.addAll(tableSchema.partitionColumns);
            return allColumns;
        }
    }
}

