/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.massimport;

import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.shaker.services.smartdate.DateFormatGuesser;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.PartitionSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HivePartitionGuesser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.hive.guesser");

    private String makePartitionDesc(TableSchema tableSchema, List<String> keys) {
        ArrayList columns = Lists.newArrayList();
        for (ColumnSchema c2 : tableSchema.partitionColumns) {
            columns.add(c2.name);
        }
        return Joiner.on((String)",").join((Iterable)columns) + " = " + Joiner.on((String)",").join(keys);
    }

    public PartitioningScheme guessPatternAndTypes(TableSchema tableSchema) throws Exception {
        String tableLocation = tableSchema.location;
        if (tableLocation == null || StringUtils.isEmpty((String)tableLocation)) {
            throw new IllegalArgumentException("No location specified for table.");
        }
        if (tableSchema.partitions == null || tableSchema.partitions.size() == 0) {
            throw new IllegalArgumentException("No partitions specified for table.");
        }
        for (PartitionSchema partition : tableSchema.partitions) {
            String partitionLocation = partition.location;
            if (partitionLocation == null || StringUtils.isEmpty((String)partitionLocation)) {
                String partitionKeys = this.makePartitionDesc(tableSchema, partition.keys);
                throw new IllegalArgumentException("Missing location on one of the partitions (" + partitionKeys + ").");
            }
            if (partitionLocation.startsWith(tableLocation)) continue;
            String partitionKeys = this.makePartitionDesc(tableSchema, partition.keys);
            throw new Exception("At least one of the partitions is not located inside the table's location : " + partitionKeys + " is in '" + partitionLocation + "' outside '" + tableLocation + "'");
        }
        ArrayList suspectedDateTimeFormats = Lists.newArrayList();
        for (int d = 0; d < tableSchema.partitionColumns.size(); ++d) {
            ArrayList suspectedDateTimeFormatsForColumn = Lists.newArrayList();
            suspectedDateTimeFormats.add(suspectedDateTimeFormatsForColumn);
            DateFormatGuesser guesser = new DateFormatGuesser();
            for (Object p : tableSchema.partitions) {
                String v = (String)((PartitionSchema)p).keys.get(d);
                guesser.addObservation(v);
            }
            List<DateFormatGuesser.DetectedFormat> formats = guesser.getResults();
            Collections.sort(formats);
            for (DateFormatGuesser.DetectedFormat formatD : formats) {
                String format = formatD.format;
                logger.info((Object)("Double check format : " + format));
                try {
                    DateTimeFormatter sdf = DateTimeFormat.forPattern((String)format).withLocale(Locale.US);
                    int allOk = 1;
                    for (PartitionSchema p : tableSchema.partitions) {
                        String v = (String)p.keys.get(d);
                        try {
                            sdf.parseDateTime(v);
                        }
                        catch (Exception e) {
                            allOk = 0;
                            break;
                        }
                    }
                    if (allOk == 0) continue;
                    suspectedDateTimeFormatsForColumn.add(sdf);
                }
                catch (Exception sdf) {}
            }
        }
        ArrayList filePathPatterns = Lists.newArrayList();
        int[][] keyOrders = this.buildKeyOrders(tableSchema.partitionColumns.size());
        for (DateTimeFormatter keyOrder : (DateFormatGuesser)keyOrders) {
            Iterator locationPattern = "";
            for (Object keyPosition : keyOrder) {
                locationPattern = (String)((Object)locationPattern) + "(.*)%{" + ((ColumnSchema)tableSchema.partitionColumns.get((int)keyPosition)).name + "}";
            }
            filePathPatterns.add((String)((Object)locationPattern) + "(.*)");
            filePathPatterns.add((String)((Object)locationPattern) + ".*");
        }
        ArrayList schemes = Lists.newArrayList();
        String[] suspectedTimePatterns = new String[]{"%Y(.*)%M(.*)%D(.*)%H", "%Y(.*)%D(.*)%M(.*)%H", "%M(.*)%D(.*)%Y(.*)%H", "%D(.*)%M(.*)%Y(.*)%H", "%Y(.*)%M(.*)%D", "%Y(.*)%D(.*)%M", "%M(.*)%D(.*)%Y", "%D(.*)%M(.*)%Y", "%Y(.*)%M", "%M(.*)%Y", "%Y", "%M", "%D"};
        for (int i = 0; i < tableSchema.partitionColumns.size(); ++i) {
            List dateTimeFormats = (List)suspectedDateTimeFormats.get(i);
            for (DateTimeFormatter dateTimeFormat : dateTimeFormats) {
                String dimensionPattern = "%{" + ((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name + "}";
                block13: for (String filePathPattern : filePathPatterns) {
                    for (String suspectedTimePattern : suspectedTimePatterns) {
                        String timeFilePathPattern = filePathPattern.replace(dimensionPattern, suspectedTimePattern);
                        PartitioningScheme scheme = this.buildPartitioningScheme(tableSchema, timeFilePathPattern, i, dateTimeFormat);
                        if (scheme == null) continue;
                        schemes.add(scheme);
                        continue block13;
                    }
                }
            }
        }
        for (String filePathPattern : filePathPatterns) {
            PartitioningScheme scheme = this.buildPartitioningScheme(tableSchema, filePathPattern, -1, null);
            if (scheme == null) continue;
            schemes.add(scheme);
        }
        return schemes.size() > 0 ? (PartitioningScheme)schemes.get(0) : null;
    }

    private PartitioningScheme buildPartitioningScheme(TableSchema tableSchema, String filePathPattern, int suspectedTimeDimension, DateTimeFormatter suspectedTimeFormatter) throws Exception {
        DateTimeFormatter fmtY = DateTimeFormat.forPattern((String)"yyyy");
        DateTimeFormatter fmtM = DateTimeFormat.forPattern((String)"MM");
        DateTimeFormatter fmtD = DateTimeFormat.forPattern((String)"dd");
        DateTimeFormatter fmtH = DateTimeFormat.forPattern((String)"HH");
        logger.info((Object)("Try pattern '" + filePathPattern + "'"));
        boolean works = true;
        int n = -1;
        ArrayList partitionPieces = Lists.newArrayList();
        for (PartitionSchema partition : tableSchema.partitions) {
            Matcher locationMatcher;
            String locationPattern = filePathPattern;
            for (int i = 0; i < tableSchema.partitionColumns.size(); ++i) {
                String v = (String)partition.keys.get(i);
                if (i == suspectedTimeDimension) {
                    DateTime dateTime = suspectedTimeFormatter.parseDateTime(v);
                    String year = fmtY.print(dateTime.getMillis());
                    String month = fmtM.print(dateTime.getMillis());
                    String day = fmtD.print(dateTime.getMillis());
                    String hour = fmtH.print(dateTime.getMillis());
                    locationPattern = locationPattern.replace("%Y", year);
                    locationPattern = locationPattern.replace("%M", month);
                    locationPattern = locationPattern.replace("%D", day);
                    locationPattern = locationPattern.replace("%H", hour);
                    continue;
                }
                String quoted = Pattern.quote(v);
                locationPattern = locationPattern.replace("%{" + ((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name + "}", quoted);
            }
            String partitionLocation = partition.location.substring(tableSchema.location.length());
            if (partitionLocation.endsWith("/")) {
                partitionLocation = partitionLocation.substring(0, partitionLocation.length() - 1);
            }
            if (!(locationMatcher = Pattern.compile(locationPattern).matcher(partitionLocation)).matches()) {
                works = false;
                break;
            }
            if (n > 0 && n != locationMatcher.groupCount()) {
                works = false;
                break;
            }
            n = locationMatcher.groupCount();
            String[] intersticialPieces = new String[n];
            for (int g = 0; g < n; ++g) {
                intersticialPieces[g] = locationMatcher.group(g + 1);
            }
            for (int i = 0; i < n; ++i) {
                locationPattern = locationPattern.replaceFirst("\\(\\.\\*\\)", Matcher.quoteReplacement(Pattern.quote(intersticialPieces[i])));
            }
            locationMatcher = Pattern.compile(locationPattern).matcher(partitionLocation);
            int partitionMatched = 0;
            for (PartitionSchema partitionOther : tableSchema.partitions) {
                Matcher locationOtherMatcher;
                String otherPartitionLocation = partitionOther.location.substring(tableSchema.location.length());
                if (otherPartitionLocation.endsWith("/")) {
                    otherPartitionLocation = otherPartitionLocation.substring(0, otherPartitionLocation.length() - 1);
                }
                if (!(locationOtherMatcher = Pattern.compile(locationPattern).matcher(otherPartitionLocation)).matches()) continue;
                ++partitionMatched;
            }
            if (partitionMatched != 1) {
                works = false;
                break;
            }
            partitionPieces.add(intersticialPieces);
        }
        if (works) {
            logger.info((Object)"Pattern seems to match, checking if the interior pieces can be inferred.");
            String[] intersticialPieces = (String[])partitionPieces.get(0);
            boolean allPiecesMatch = true;
            for (int i = 1; i < partitionPieces.size(); ++i) {
                for (int j = 0; j < n; ++j) {
                    if (((String[])partitionPieces.get(i))[j].equals(intersticialPieces[j])) continue;
                    allPiecesMatch = false;
                }
            }
            if (allPiecesMatch) {
                String pattern = filePathPattern;
                for (int i = 0; i < n; ++i) {
                    pattern = pattern.replaceFirst("\\(\\.\\*\\)", intersticialPieces[i]);
                }
                logger.info((Object)("Pattern matches, full version is: '" + pattern + "'"));
                PartitioningScheme scheme = new PartitioningScheme();
                scheme.setFilePathPattern(pattern + "/.*");
                for (int i = 0; i < tableSchema.partitionColumns.size(); ++i) {
                    if (i == suspectedTimeDimension) {
                        TimeDimension.Period period = pattern.contains("%H") ? TimeDimension.Period.HOUR : (pattern.contains("%D") ? TimeDimension.Period.DAY : (pattern.contains("%M") ? TimeDimension.Period.MONTH : TimeDimension.Period.YEAR));
                        scheme.addDimension((Dimension)new TimeDimension(((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name, period));
                        continue;
                    }
                    scheme.addDimension((Dimension)new ExactValueDimension(((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name));
                }
                return scheme;
            }
        }
        return null;
    }

    private int[][] buildKeyOrders(int size) {
        ArrayList permutations = Lists.newArrayList();
        int[] base = new int[size];
        for (int i = 0; i < size; ++i) {
            base[i] = i;
        }
        this.buildPermutations(size, 0, permutations, base);
        return (int[][])permutations.toArray((T[])new int[0][]);
    }

    private void buildPermutations(int size, int from, List<int[]> permutations, int[] base) {
        if (from >= size - 1) {
            permutations.add(base);
            return;
        }
        for (int swap = from; swap < size; ++swap) {
            int[] perm = new int[size];
            for (int i = 0; i < size; ++i) {
                perm[i] = base[i];
            }
            if (swap != from) {
                int j = perm[swap];
                perm[swap] = perm[from];
                perm[from] = j;
            }
            this.buildPermutations(size, from + 1, permutations, perm);
        }
    }
}

