/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.BinaryUtils;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryStreamEncoder
implements AutoCloseable {
    private byte[] buffer = new byte[10];
    private OutputStream os;
    private long written;

    public BinaryStreamEncoder(OutputStream os) {
        this.os = os;
    }

    public long getWritten() {
        return this.written;
    }

    public void writeVInt(long value) throws IOException {
        int codeSize = BinaryUtils.writeVInt(value, this.buffer, 0);
        this.os.write(this.buffer, 0, codeSize);
        this.written += (long)codeSize;
    }

    public void writeLE64(long value) throws IOException {
        BinaryUtils.encodeLE64(value, this.buffer, 0);
        this.os.write(this.buffer, 0, 8);
        this.written += 8L;
    }

    public void writeLE32(int value) throws IOException {
        BinaryUtils.encodeLE32(value, this.buffer, 0);
        this.os.write(this.buffer, 0, 4);
        this.written += 4L;
    }

    public void writeLE16(short value) throws IOException {
        BinaryUtils.encodeLE16(value, this.buffer, 0);
        this.os.write(this.buffer, 0, 2);
        this.written += 2L;
    }

    public void writeUCS2Char(char c2) throws IOException {
        BinaryUtils.encodeLE16((short)c2, this.buffer, 0);
        this.os.write(this.buffer, 0, 2);
        this.written += 2L;
    }

    public void writeUTF8LenAndString(String s) throws IOException {
        byte[] data = s.getBytes("utf8");
        this.writeVInt(data.length);
        this.os.write(data);
        this.written += (long)data.length;
    }

    public void writeUTF8LenAndString(char[] c2) throws IOException {
        byte[] data = new String(c2).getBytes("utf8");
        this.writeVInt(data.length);
        this.os.write(data);
        this.written += (long)data.length;
    }

    public void writeByte(byte b) throws IOException {
        this.os.write(b);
        ++this.written;
    }

    public void writeBytes(byte[] b) throws IOException {
        this.os.write(b);
        this.written += (long)b.length;
    }

    public void writeFloat(float value) throws IOException {
        BinaryUtils.encodeFloat(value, this.buffer, 0);
        this.os.write(this.buffer, 0, 4);
        this.written += 4L;
    }

    public void writeDouble(double value) throws IOException {
        BinaryUtils.encodeDouble(value, this.buffer, 0);
        this.os.write(this.buffer, 0, 8);
        this.written += 8L;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.flush();
            this.os.close();
            this.os = null;
        }
    }
}

