/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.scatter.AbstractScatterBuilder;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.Unaggregated;
import com.dataiku.dip.pivot.backend.model.maps.PTMapScatterRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapScatterResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import java.util.Arrays;

public class MapScatterBuilder
extends AbstractScatterBuilder {
    private final PTMapScatterRequest request;
    private int finishedPoints;

    public MapScatterBuilder(PTMapScatterRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PTMapScatterResponse buildFromLino(LinoReader linoReader) throws Exception {
        this.outputRows = (int)Math.min(linoReader.nbRecords(), (long)this.request.maxRows);
        logger.info((Object)("Will build MAP scatter on " + this.outputRows + " rows"));
        this.buildLinoFilters(this.request, linoReader);
        AbstractScatterBuilder.BlockTmpData lonData = new AbstractScatterBuilder.BlockTmpData();
        lonData.type = AxisDef.Type.NUMERICAL;
        this.initAxis(lonData);
        AbstractScatterBuilder.BlockTmpData latData = new AbstractScatterBuilder.BlockTmpData();
        latData.type = AxisDef.Type.NUMERICAL;
        this.initAxis(latData);
        this.initValues(this.request.columns);
        long beforeFilter = 0L;
        long afterFilter = 0L;
        double minLon = 180.0;
        double maxLon = -180.0;
        double minLat = 90.0;
        double maxLat = -90.0;
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            int i;
            this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
            if (this.finishedPoints == this.outputRows) continue;
            ColumnBlock lonBlock = linoReader.readColumnBlock(this.request.geoColumn + "__dku_lon", blockIdx);
            ColumnBlock latBlock = linoReader.readColumnBlock(this.request.geoColumn + "__dku_lat", blockIdx);
            beforeFilter += (long)lonBlock.nbRecords();
            boolean[] filters = new boolean[lonBlock.nbRecords()];
            if (this.filtered) {
                this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            } else {
                Arrays.fill(filters, true);
            }
            for (i = 0; i < lonBlock.nbRecords(); ++i) {
                double lon = lonBlock.doubles[i];
                double lat = latBlock.doubles[i];
                if (Double.isNaN(lon) || Double.isNaN(lat)) {
                    filters[i] = false;
                    continue;
                }
                minLon = Math.min(minLon, lon);
                maxLon = Math.max(maxLon, lon);
                minLat = Math.min(minLat, lat);
                maxLat = Math.max(maxLat, lat);
                if (!(lon > this.request.maxLon || lon < this.request.minLon || lat > this.request.maxLat) && !(lat < this.request.minLat)) continue;
                filters[i] = false;
            }
            this.filterNAOnNumBlock(lonBlock, filters);
            this.filterNAOnNumBlock(latBlock, filters);
            for (i = 0; i < this.request.columns.size(); ++i) {
                if (((Unaggregated)this.request.columns.get((int)i)).id.startsWith("tooltip")) continue;
                this.filterNAOnBlock(linoReader, ((Unaggregated)this.request.columns.get((int)i)).column, (AbstractScatterBuilder.BlockTmpData)this.values.get(i), filters, blockIdx);
            }
            long blockKept = FilteringExecutor.countTrue(filters);
            logger.info((Object)("Handle block " + blockIdx + " with " + lonBlock.nbRecords() + "(keep: " + blockKept + ")"));
            afterFilter += blockKept;
            int gathered = this.gatherDataOnNumBlock(lonBlock, filters, lonData, this.finishedPoints);
            this.gatherDataOnNumBlock(latBlock, filters, latData, this.finishedPoints);
            for (int i2 = 0; i2 < this.request.columns.size(); ++i2) {
                this.gatherDataBlock(linoReader, ((Unaggregated)this.request.columns.get((int)i2)).column, (AbstractScatterBuilder.BlockTmpData)this.values.get(i2), blockIdx, filters, this.finishedPoints, null);
            }
            this.finishedPoints += gathered;
        }
        logger.info((Object)"End of accumulation phase, build the response");
        PTMapScatterResponse resp = new PTMapScatterResponse();
        resp.xAxis = this.fromBlock(lonData);
        resp.xAxis.num.data = Arrays.copyOfRange(resp.xAxis.num.data, 0, (int)afterFilter);
        resp.yAxis = this.fromBlock(latData);
        resp.yAxis.num.data = Arrays.copyOfRange(resp.yAxis.num.data, 0, (int)afterFilter);
        for (int i = 0; i < this.request.columns.size(); ++i) {
            resp.values.put(((Unaggregated)this.request.columns.get((int)i)).id, this.fromBlock((AbstractScatterBuilder.BlockTmpData)this.values.get(i)));
        }
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        resp.setRecordCounts(beforeFilter, afterFilter);
        resp.minLon = minLon;
        resp.maxLon = maxLon;
        resp.minLat = minLat;
        resp.maxLat = maxLat;
        return resp;
    }
}

