/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.LinoAxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.maps.LinoPointGridAxisHandler;
import com.dataiku.dip.pivot.backend.dss.maps.PivotMapAggrBuilderBase;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridResponse;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;

public class PivotMapGridAggrBuilder
extends PivotMapAggrBuilderBase {
    private final PTMapAggrGridRequest request;

    public PivotMapGridAggrBuilder(PTMapAggrGridRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PTMapAggrGridResponse buildFromLino(LinoReader linoReader, VariablesContext variablesContext) throws Exception {
        this.buildLinoFilters(this.request, linoReader);
        String lonName = this.request.geoColumn + "__dku_lon";
        LinoPointGridAxisHandler axisHandler = new LinoPointGridAxisHandler(lonName, this.request.geoColumn + "__dku_lat", this.request);
        for (int block = 0; block < linoReader.nblocks(); ++block) {
            ColumnBlock lonBlock = linoReader.readColumnBlock(lonName, block);
            boolean[] filters = null;
            if (this.filtered) {
                filters = new boolean[lonBlock.nbRecords()];
                this.filterLinoBlock(this.request, linoReader, block, filters);
            }
            axisHandler.observe(linoReader, block, filters);
        }
        int bins = axisHandler.getNbBins();
        logger.info((Object)("End of binning pass, bins=" + bins));
        BinsAndTensorsSafetyChecks.failIfTooManyBinsOnSingleAxis(null, bins);
        this.buildAggregationStructures(bins, this.request, variablesContext, linoReader);
        for (int block = 0; block < linoReader.nblocks(); ++block) {
            this.addLinoPass2(linoReader, block, axisHandler);
        }
        return this.end(axisHandler);
    }

    private void addLinoPass2(LinoReader linoReader, int blockIdx, LinoAxisHandler handler) throws IOException {
        String lonName = this.request.geoColumn + "__dku_lon";
        this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
        ColumnBlock lonBlock = linoReader.readColumnBlock(lonName, blockIdx);
        boolean[] filters = this.handleFiltersAndCounts(this.request, lonBlock, linoReader, blockIdx);
        int[] bins = new int[lonBlock.nbRecords()];
        handler.getBins(linoReader, blockIdx, bins, filters);
        this.updateAggregations(this.request, bins, filters, PivotTableAggrBuilder.getAggrBlocks(linoReader, this.request.aggregations, blockIdx), linoReader, blockIdx);
    }

    private PTMapAggrGridResponse end(LinoPointGridAxisHandler axisHandler) throws JSONException, IOException {
        logger.info((Object)"End of accumulation phase");
        PTMapAggrGridResponse resp = new PTMapAggrGridResponse();
        resp.engine = PivotTableResponse.PivotEngine.LINO;
        for (int aggrId = 0; aggrId < this.request.aggregations.size(); ++aggrId) {
            AbstractAggregator aggregator = (AbstractAggregator)this.aggregators.get(aggrId);
            aggregator.end();
        }
        resp.counts = this.countList;
        for (AbstractAggregator aggregator : this.aggregators) {
            aggregator.initMerge(aggregator.getOutDT().axisLengths[0]);
            aggregator.mapFillMergeDT(this.countList);
            resp.aggregations.put(aggregator.req.id, aggregator.getMergeDT());
        }
        List<LinoPointGridAxisHandler.GeoGridAxisElt> elts = axisHandler.getGeoAxisElts();
        resp.cellMinLat = new double[elts.size()];
        resp.cellMinLon = new double[elts.size()];
        for (LinoPointGridAxisHandler.GeoGridAxisElt elt : elts) {
            resp.cellMinLat[elt.binIndex] = elt.minLat;
            resp.cellMinLon[elt.binIndex] = elt.minLon;
        }
        resp.gridLatDeg = this.request.latRadiusDeg;
        resp.gridLonDeg = this.request.lonRadiusDeg;
        axisHandler.fillBounds(resp);
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        logger.info((Object)"End of building output data");
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        return resp;
    }
}

