/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.BasicStatsSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class BasicStatsHybridExecutor
implements Callable<BasicStatsBuilder.BasicStats> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.basic_stats");
    private Future<ColumnMapper> colMappingFuture;
    private ExecutionContext ctx;
    private final Future<BasicStatsBuilder.BasicStats> globalStatsFuture;

    public BasicStatsHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, Future<BasicStatsBuilder.BasicStats> globalStatsFuture) {
        this.colMappingFuture = colMappingFuture;
        this.ctx = ctx;
        this.globalStatsFuture = globalStatsFuture;
    }

    @Override
    public BasicStatsBuilder.BasicStats call() throws Exception {
        logger.debug((Object)"Starting task: Basic stats");
        try {
            BasicStatsBuilder.BasicStats basicStats;
            block13: {
                BasicStatsBuilder.BasicStats stats;
                FutureProgress.AutocloseableFutureProgressState state;
                block11: {
                    BasicStatsBuilder.BasicStats basicStats2;
                    block12: {
                        state = FutureProgress.pushAutoCloseableState((String)"Computing basic column statistics...");
                        try {
                            List<AxisDef> columnDefinitions = BasicStatsToSQL.determineDependentColumns(this.ctx.req);
                            stats = this.ctx.cache.basicStatsCache.get(this.ctx.req.filters, columnDefinitions);
                            if (stats == null) break block11;
                            logger.info((Object)"Computed basic column stats from cache");
                            basicStats2 = stats;
                            if (state == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (state != null) {
                                try {
                                    state.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        state.close();
                    }
                    return basicStats2;
                }
                BasicStatsSQLExecutor sqlStatsExecutor = new BasicStatsSQLExecutor(this.ctx, this.colMappingFuture, this.globalStatsFuture);
                stats = sqlStatsExecutor.call();
                this.ctx.cache.basicStatsCache.put((List<RowFilter>)this.ctx.req.filters, stats);
                basicStats = stats;
                if (state == null) break block13;
                state.close();
            }
            return basicStats;
        }
        finally {
            logger.debug((Object)"Done task: Basic stats");
        }
    }
}

