/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark.historyserver;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.recipes.code.spark.historyserver.SparkHistoryServerHandle;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class SparkHistoryServerManager {
    private Cache<String, SparkHistoryServerHandle> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, SparkHistoryServerHandle>(){

        public void onRemoval(RemovalNotification<String, SparkHistoryServerHandle> rn) {
            logger.info((Object)("Removing SparkHistoryServer: " + (String)rn.getKey() + " -> " + ((SparkHistoryServerHandle)rn.getValue()).id));
            try {
                ((SparkHistoryServerHandle)rn.getValue()).stop();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to remove Spark History Server", (Throwable)e);
            }
        }
    }).build();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.history");

    @PostConstruct
    public void init() {
        DKUExecutors.newNamedSingleDaemonThreadExecutor("SparkHistoryServers-cleanup").scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (SparkHistoryServerManager.this.cache.size() > 0L) {
                    logger.info((Object)"Cleanup Spark History Server cache");
                }
                SparkHistoryServerManager.this.cache.cleanUp();
            }
        }, 120L, 120L, TimeUnit.SECONDS);
    }

    private String key(String projectKey, String jobId, String activityId) {
        return projectKey + "___" + jobId + "___" + activityId;
    }

    public void updateLastUsage(String projectKey, String jobId, String activityId) {
        logger.debug((Object)("Update last usage " + this.key(projectKey, jobId, activityId)));
        this.cache.getIfPresent((Object)this.key(projectKey, jobId, activityId));
    }

    public Id startForActivity(String projectKey, String jobId, String activityId) throws Exception {
        SparkHistoryServerHandle handle = (SparkHistoryServerHandle)this.cache.getIfPresent((Object)this.key(projectKey, jobId, activityId));
        if (handle != null) {
            logger.info((Object)("Spark History Server cache hit: " + this.key(projectKey, jobId, activityId)));
            return new Id(handle.id);
        }
        logger.info((Object)("Spark History Server cache miss: " + this.key(projectKey, jobId, activityId)));
        File eventLogRoot = DKUApp.getFile((String[])new String[]{"jobs", projectKey, jobId, activityId, "spark-eventlog"});
        String id = SecretKeyGenerator.generate((int)12);
        handle = new SparkHistoryServerHandle(projectKey, jobId, activityId, id, eventLogRoot.getAbsolutePath());
        handle.start();
        handle.enableProxy();
        DKUtils.unsafeSleep((long)200L);
        this.cache.put((Object)this.key(projectKey, jobId, activityId), (Object)handle);
        return new Id(id);
    }
}

