/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLScriptRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.status.sql");

    public SQLScriptRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        SQLScriptRecipeStatus status = null;
        try {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            SQLConnectionProvider.SQLConnectionData connData;
            String mainConnection;
            try (Transaction t = this.transactionService.beginRead();){
                status = this.fastStatusIgnorePartitions(authCtx);
            }
            try (Transaction t = this.transactionService.beginRead();){
                if (this.payload == null || this.payload.length() == 0 || StringUtils.isWhitespace((String)this.payload)) {
                    status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Recipe SQL query is empty");
                    SQLScriptRecipeStatus sQLScriptRecipeStatus = status;
                    return sQLScriptRecipeStatus;
                }
                if (this.recipe.getInputsForRole("main").size() == 0 && this.recipe.getOutputsForRole("main").size() == 0) {
                    status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "SQL recipe needs at least one input or one output ..");
                    SQLScriptRecipeStatus sQLScriptRecipeStatus = status;
                    return sQLScriptRecipeStatus;
                }
                List<Dataset> sourceDatasets = SQLQueryRecipeUtils.getSourceDatasets(this.recipe);
                status.topLevelMessages.mergeFrom(this.validateSourceDatasets(sourceDatasets));
                SQLQueryRecipeUtils.SQLConnections sourceConnections = new SQLQueryRecipeUtils.SQLConnections();
                for (Dataset dataset : sourceDatasets) {
                    String sourceDSConnection = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)dataset.getProjectKey()).connection;
                    sourceConnections.add(sourceDSConnection);
                }
                List<Dataset> targetsDatasets = SQLQueryRecipeUtils.getTargetDatasets(this.recipe);
                for (Dataset targetDS : targetsDatasets) {
                    if (DatasetInspector.isSQLTable(targetDS)) continue;
                    status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Output dataset %s cannot be used as output of this recipe", new Object[]{targetDS.getName()});
                    break;
                }
                SQLQueryRecipeUtils.SQLConnections sQLConnections = SQLQueryRecipeUtils.getConnectionsFromSqlTableDatasets(targetsDatasets);
                SQLScriptRecipeMeta.SQLScriptRecipeParams params = (SQLScriptRecipeMeta.SQLScriptRecipeParams)SQLScriptRecipeMeta.SQLScriptRecipeParams.class.cast(this.recipe.params);
                HashSet allConnections = Sets.newHashSet();
                allConnections.addAll(sourceConnections.connections);
                allConnections.addAll(sQLConnections.connections);
                if (!params.allowMultipleConnections && allConnections.size() > 1) {
                    status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "SQL recipe can't work on multiple connections simultaneously (inputs/outputs use %s)", new Object[]{Joiner.on((String)", ").join((Iterable)allConnections)});
                    SQLScriptRecipeStatus sQLScriptRecipeStatus = status;
                    return sQLScriptRecipeStatus;
                }
                if (params.allowMultipleConnections) {
                    Object object;
                    if (params.mainConnectionDataset == null) {
                        status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "The dataset whose connection the query should be run in is not specified (mandatory when using multiple connections).", new Object[0]);
                        SQLScriptRecipeStatus sQLScriptRecipeStatus = status;
                        return sQLScriptRecipeStatus;
                    }
                    Dataset dataset = null;
                    for (SerializedRecipe.RecipeInput source : this.recipe.getInputsForRole("main")) {
                        if (!source.ref.equals(params.mainConnectionDataset)) continue;
                        dataset = this.datasetAccessService.getOrNull(DatasetLocUtils.resolveSmart(this.recipe.projectKey, source.ref));
                    }
                    for (SerializedRecipe.RecipeOutput target : this.recipe.getOutputsForRole("main")) {
                        if (!target.ref.equals(params.mainConnectionDataset)) continue;
                        dataset = this.datasetAccessService.getOrNull(DatasetLocUtils.resolveSmart(this.recipe.projectKey, target.ref));
                    }
                    if (dataset == null) {
                        status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "The dataset %s is not among the inputs nor output of the recipe.", new Object[]{params.mainConnectionDataset});
                        object = status;
                        return object;
                    }
                    if (!DatasetInspector.isSQL(dataset)) {
                        status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "The dataset %s is not a SQL dataset.", new Object[]{params.mainConnectionDataset});
                        object = status;
                        return object;
                    }
                    AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                    mainConnection = config.connection;
                } else {
                    mainConnection = sourceConnections.firstConnection;
                    if (mainConnection == null || mainConnection.length() == 0) {
                        mainConnection = sQLConnections.firstConnection;
                    }
                }
                if (mainConnection == null) {
                    status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "No SQL connection among input nor output datasets.", new Object[0]);
                    SQLScriptRecipeStatus sQLScriptRecipeStatus = status;
                    return sQLScriptRecipeStatus;
                }
                SQLQueryRecipeUtils.checkConnectionUsability(allConnections, authCtx);
            }
            try {
                connData = SQLConnectionProvider.getConnectionData_NT(authCtx, this.recipe.getProjectKey(), mainConnection);
            }
            catch (Exception e) {
                logger.error((Object)"Failed load connection", (Throwable)e);
                status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Connection configuration error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                return status;
            }
            try {
                this.validateConnection(authCtx, connData);
            }
            catch (ClassNotFoundException | LinkageError e) {
                logger.error((Object)("Failed to load JDBC driver (" + connData.getDriver(authCtx, this.recipe.getProjectKey()) + "): "), e);
                status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to load JDBC driver (%s): %s", new Object[]{connData.getDriver(authCtx, this.recipe.getProjectKey()), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                return status;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to connect", (Throwable)e);
                status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to connect: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                return status;
            }
            if (request == null) return status;
            try (Transaction t = this.transactionService.beginRead();){
                this.recipe.name = "testRecipe";
                FlowGraph graph = new FlowGraph();
                FlowRecipe frecipe = graph.buildSingleRecipe(this.recipe);
                GenericRecipesValidationService genericRecipesValidationService = (GenericRecipesValidationService)SpringUtils.getBean(GenericRecipesValidationService.class);
                subgraphCallable = genericRecipesValidationService.getValidationRunnableSubgraph(authCtx, frecipe, request.targetPartitionSpec);
            }
            RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
            PreprocessedQueryForSubstitution preprocessedQuery = PreprocessedQueryForSubstitution.preprocess_NT(this.payload, connData.getDialect());
            try (Transaction t = this.transactionService.beginRead();){
                RecipeVariablesHelper.RecipeSubstitutionVariablesResult recipeSubstitutionVariablesResult = new RecipeVariablesHelper().getRecipeVariablesAndSubstitute(authCtx, this.recipe.projectKey, subgraph, preprocessedQuery, null);
                status.topLevelMessages.mergeFrom(recipeSubstitutionVariablesResult.messages);
                status.substitutionVariables = recipeSubstitutionVariablesResult.substitutionVariables;
                recipeSubstitutionVariablesResult.throwIfSubstitutionError();
                logger.info((Object)("Substituted query: " + recipeSubstitutionVariablesResult.substituted));
                return status;
            }
        }
        catch (Exception e) {
            InfoMessage err = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)("Failed to validate SQL recipe: " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Object[])new Object[0]);
            if (status == null) return status;
            status.topLevelMessages.addMessage(err);
        }
        return status;
    }

    private InfoMessage.InfoMessages validateSourceDatasets(List<Dataset> sourceDatasets) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (Dataset dataset : sourceDatasets) {
            if (DatasetInspector.isSQLTable(dataset) || DatasetInspector.isSQLQuery(dataset.getModel())) continue;
            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Input dataset %s cannot be used as input of this recipe", new Object[]{dataset.getName()});
            break;
        }
        return messages;
    }

    @VisibleForTesting
    protected void validateConnection(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData) throws ClassNotFoundException, SQLException, DKUSecurityException, InterruptedException {
        String driverClass = connData.getDriver(authCtx, this.recipe.getProjectKey());
        if (driverClass != null) {
            SQLDriverLoader.loadDriver(driverClass, connData.getJarsDirectory(), connData.getJarsFallThroughPackages(), connData.getJarsNonFallThroughPackages());
        }
        SQLConnectionProvider.newConnection(connData, authCtx, this.recipe.getProjectKey()).close();
    }

    @Override
    public SQLScriptRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        SQLScriptRecipeStatus ret = new SQLScriptRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("SQL", "SQL", "IN_DB", "In Database", "In-database (SQL)");
        return ret;
    }

    public static class SQLScriptRecipeStatus
    extends CodeBasedRecipeStatus {
    }
}

