/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RemoteRunsRegistry {
    private static final Map<String, Execution> registry = new HashMap<String, Execution>();
    private static String dssVersion;
    private static final DKULogger logger;

    public static synchronized void add(String id, AuthCtx authCtx, String projectKey, @Nullable String contextPath, String executionPath, ExecutionType type, String definition, String payload, Collection<String> readablePaths, Collection<String> writablePaths, List<CodeEnvModel.EnvFullRef> codeEnvs) {
        logger.debugV("Registering container execution %s of type %s", new Object[]{id, type});
        String secretId = SecretKeyGenerator.generateSmall();
        boolean resyncPythonCode = ApplicationConfigurator.getParams().getBoolParam("dku.containerexec.resyncPythonCode", false);
        registry.put(id, new Execution(id, authCtx, projectKey, contextPath, executionPath, type, definition, payload, readablePaths, writablePaths, codeEnvs, secretId, resyncPythonCode));
    }

    public static synchronized Execution get(String id) {
        return registry.get(id);
    }

    public static synchronized Execution remove(String id) {
        logger.debugV("Finished with container execution %s", new Object[]{id});
        return registry.remove(id);
    }

    private static String getDssVersion() {
        if (dssVersion == null) {
            dssVersion = ApplicationConfigurator.getDSSVersion().product_version;
        }
        return dssVersion;
    }

    static {
        logger = DKULogger.getLogger((String)"dku.remoterun.registry");
    }

    public static class Execution {
        public final String dssVersion;
        public final String id;
        public transient AuthCtx authCtx;
        public final String projectKey;
        public final String backendDipHomePath;
        @Nullable
        public final String contextPath;
        public final String executionPath;
        public final boolean resyncPythonCode;
        public final transient Set<String> readablePaths;
        public final transient Set<String> writablePaths;
        public final ExecutionType type;
        public final String definition;
        public final String payload;
        public final List<CodeEnvModel.EnvFullRef> codeEnvs;
        public RemoteRunEnvDef envResource;
        public transient RemoteFileUploadListener uploadListener;
        public transient String secretId;

        public Execution(String id, AuthCtx authCtx, String projectKey, String contextPath, String executionPath, ExecutionType type, String definition, String payload, Collection<String> readablePaths, Collection<String> writablePaths, List<CodeEnvModel.EnvFullRef> codeEnvs, String secretId, boolean resyncPythonCode) {
            this.id = id;
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.backendDipHomePath = new File(System.getenv("DIP_HOME")).getAbsolutePath();
            this.contextPath = contextPath;
            this.executionPath = executionPath;
            this.type = type;
            this.definition = definition;
            this.payload = payload;
            this.readablePaths = readablePaths == null ? new HashSet<String>() : Sets.newHashSet(readablePaths);
            this.writablePaths = writablePaths == null ? new HashSet<String>() : Sets.newHashSet(writablePaths);
            this.dssVersion = RemoteRunsRegistry.getDssVersion();
            this.codeEnvs = codeEnvs == null ? Collections.emptyList() : codeEnvs;
            this.secretId = secretId;
            this.resyncPythonCode = resyncPythonCode;
        }
    }

    public static enum ExecutionType {
        TEST_PING,
        RECIPE_PYTHON,
        RECIPE_PREDICTION_TRAIN_PYTHON,
        RECIPE_CLUSTERING_TRAIN_PYTHON,
        RECIPE_PREDICTION_TRAIN_DEEPHUB,
        RECIPE_PREDICTION_TRAIN_TIMESERIES,
        RECIPE_PREDICTION_TRAIN_CAUSAL,
        RECIPE_PREDICTION_SCORE_PYTHON,
        RECIPE_PREDICTION_SCORE_KERAS,
        RECIPE_PREDICTION_SCORE_DEEPHUB,
        RECIPE_PREDICTION_SCORE_MLFLOW,
        RECIPE_PREDICTION_SCORE_TIMESERIES,
        RECIPE_PREDICTION_SCORE_CAUSAL,
        RECIPE_CLUSTERING_SCORE_PYTHON,
        RECIPE_PREDICTION_EVAL_PYTHON,
        RECIPE_PREDICTION_EVAL_KERAS,
        RECIPE_PREDICTION_EVAL_TIMESERIES,
        RECIPE_PREDICTION_EVAL_CAUSAL,
        RECIPE_CLUSTERING_CLUSTER_PYTHON,
        RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON,
        RECIPE_PREDICTION_EVAL_MLFLOW,
        RECIPE_LLM_EVALUATION_PYTHON,
        RECIPE_AGENT_EVALUATION_PYTHON,
        DOCTOR_PYTHON,
        RECIPE_R,
        SPARK,
        CODE_STUDIO,
        NOTEBOOK_PYTHON,
        NOTEBOOK_R,
        WEBAPP_STD,
        WEBAPP_BOKEH,
        WEBAPP_DASH,
        WEBAPP_SHINY,
        WEBAPP_STREAMLIT,
        SIMPLE_PYTHON,
        ML_INTERACTIVE_SCORING,
        RECIPE_CPYTHON,
        CDE,
        RECIPE_FINE_TUNING_LLM;

    }

    public static interface RemoteFileUploadListener {
        public void notifyUpload(String var1);
    }
}

