/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.server.notifications.VariableLookup;

public class ItemCountDistillation
implements DistillationUnit {
    private final Class<? extends ReportItem> reportItemClazz;
    private int count = 0;
    private int countSuccess = 0;
    private int countFailed = 0;
    private int countWarning = 0;
    private int countNull = 0;
    private String prefix;

    public ItemCountDistillation(Class<? extends ReportItem> reportItemClazz, String prefix) {
        this.reportItemClazz = reportItemClazz;
        this.prefix = prefix;
    }

    @Override
    public void getResult(VariableLookup lookup) {
        lookup.addVariable("all" + this.prefix + "Count", this.count);
        lookup.addVariable("success" + this.prefix + "Count", this.countSuccess);
        lookup.addVariable("failed" + this.prefix + "Count", this.countFailed);
        lookup.addVariable("warning" + this.prefix + "Count", this.countWarning);
        lookup.addVariable("na" + this.prefix + "Count", this.countNull);
    }

    @Override
    public void handle(ReportItem item) {
        boolean itemClazzOk;
        boolean bl = itemClazzOk = this.reportItemClazz == null || this.reportItemClazz.isInstance(item);
        if (itemClazzOk) {
            ++this.count;
            if (item.getOutcome() == null) {
                ++this.countNull;
            } else if (item.getOutcome() == ReportItem.Outcome.SUCCESS) {
                ++this.countSuccess;
            } else if (item.getOutcome() == ReportItem.Outcome.FAILED) {
                ++this.countFailed;
            } else if (item.getOutcome() == ReportItem.Outcome.WARNING) {
                ++this.countWarning;
            }
        }
    }
}

