/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.savedmodels.SavedModelsService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckExternalModelEndpointRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CheckExternalModelEndpointParams.class;
        }

        @Override
        public String getType() {
            return "check_external_model_endpoint";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CheckExternalModelEndpointRunner(scenario, step, step.getParamsAs(CheckExternalModelEndpointParams.class));
        }

        @Override
        public String buildName(Step step) {
            CheckExternalModelEndpointParams params = step.getParamsAs(CheckExternalModelEndpointParams.class);
            return "Check endpoint of external model " + params.modelId;
        }

        @Override
        public String buildId(Step step) {
            CheckExternalModelEndpointParams params = step.getParamsAs(CheckExternalModelEndpointParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType());
            if (params != null) {
                sb.append("_");
                sb.append(params.getModelId());
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final Scenario scenario;
    private final Step step;
    private final CheckExternalModelEndpointParams params;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private SavedModelsService savedModelsService;
    @Autowired
    private FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.check_external_model_endpoint");

    CheckExternalModelEndpointRunner(Scenario scenario, Step step, CheckExternalModelEndpointParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        FullModelId fmi;
        SavedModel sm;
        logger.info((Object)("Start step " + this.step.getName()));
        logger.debug((Object)"Retrieving saved model");
        String projectKey = this.scenario.getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, this.params.getModelId());
        }
        if (null == sm) {
            logger.errorV("Saved Model not found with projectKey %s and modelId %s", new Object[]{projectKey, this.params.modelId});
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            return;
        }
        logger.debug((Object)"Retrieving active version");
        try {
            fmi = this.predictionSMMgmtService.getActiveVersionFMI(sm);
        }
        catch (IllegalArgumentException iae) {
            logger.errorV("Error when retrieving active version of saved model with projectKey %s and modelId %s", new Object[]{projectKey, this.params.modelId});
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            return;
        }
        logger.debug((Object)"Retrieve online endpoint status and compare with stored info");
        FutureResponse<InfoMessage.InfoMessages> initial = this.savedModelsService.checkProxyModelEndpoint(stepRun.getScenarioRun().getRunAsUser(), fmi);
        FutureResponse response = this.futureService.waitForFinalResponse(initial);
        if (!response.hasResult) {
            logger.errorV("Check of model %s failed", new Object[]{fmi});
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            return;
        }
        if (((InfoMessage.InfoMessages)response.result).maxSeverity == InfoMessage.Severity.WARNING) {
            logger.warnV("Check terminated with warnings: %s", new Object[]{((InfoMessage.InfoMessages)response.result).report()});
            stepReportItem.withOutcome(ReportItem.Outcome.WARNING);
            return;
        }
        if (((InfoMessage.InfoMessages)response.result).maxSeverity == InfoMessage.Severity.ERROR) {
            logger.warnV("Check terminated with errors: %s", new Object[]{((InfoMessage.InfoMessages)response.result).report()});
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            return;
        }
        logger.debug((Object)"Info on endpoint match online endpoint");
        logger.info((Object)("Done step " + this.step.getName()));
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class CheckExternalModelEndpointParams
    extends NonFatalStepParams
    implements StepParams {
        public String modelId;

        public String getModelId() {
            return this.modelId;
        }
    }
}

