/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.autorestart.AutoRestartingLoopThread;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class StartContinuousActivityStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "start_continuous_activity";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return StartContinuousActivityParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new StartContinuousActivityStepRunner(scenario, step, step.getParamsAs(StartContinuousActivityParams.class));
        }

        @Override
        public String buildName(Step step) {
            StartContinuousActivityParams params = step.getParamsAs(StartContinuousActivityParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Start continuous activities");
            if (params != null) {
                for (String started : params.continuousActivityIds) {
                    sb.append(" ");
                    sb.append(started);
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            StartContinuousActivityParams params = step.getParamsAs(StartContinuousActivityParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("start_cak");
            if (params != null) {
                sb.append("_");
                for (String started : params.continuousActivityIds) {
                    sb.append("_");
                    sb.append(started);
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final StartContinuousActivityParams params;
    private final Step step;
    private final Scenario scenario;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.startcak");

    public StartContinuousActivityStepRunner(Scenario scenario, Step step, StartContinuousActivityParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        String projectKey = this.scenario.getProjectKey();
        Exception thrown = null;
        for (String item : this.params.continuousActivityIds) {
            ReportTargetItem.ContinuousActivityItem caItem = new ReportTargetItem.ContinuousActivityItem(this.scenario.getProjectKey(), item);
            logger.info((Object)("Will start " + item));
            ReportItem startItem = new ReportItem.StartedContinuousActivity(caItem).withStart(DateTime.now().getMillis());
            try {
                this.continuousActivitiesManager.start_NT(authCtx, projectKey, item, this.params.loopParams);
                startItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to start CAK", (Throwable)e);
                thrown = e;
                startItem.withOutcome(ReportItem.Outcome.FAILED);
            }
            finally {
                startItem.withEnd(DateTime.now().getMillis());
            }
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(caItem.projectKey, caItem.continuousActivityId), null, null, stepRun.getScenarioRun(), stepRun, startItem);
        }
        if (thrown != null) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(thrown);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class StartContinuousActivityParams
    extends NonFatalStepParams
    implements StepParams {
        public List<String> continuousActivityIds = Lists.newArrayList();
        public AutoRestartingLoopThread.AutoRestartingLoopParams loopParams = new AutoRestartingLoopThread.AutoRestartingLoopParams();
    }
}

