/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.util.StringUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class ScoringExporter {
    private static final int UUID_LENGTH = 36;
    public final ScoringWriter writer;
    public final String exportId;

    public static void checkExportLicenced() {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus ls = ((LicenseEnforcementService)SpringUtils.getBean(LicenseEnforcementService.class)).getFeaturesStatus();
        if (!ls.isModelExportAllowed()) {
            throw new SecurityException("Model export is not licensed");
        }
    }

    public ScoringExporter(ScoringWriter writer) throws IOException {
        this.writer = writer;
        this.exportId = UUID.randomUUID().toString() + writer.makeFileName();
    }

    String export() throws Exception {
        CompatibilityWithReason compatibility = this.writer.getCompatibility();
        if (!compatibility.compatible) {
            throw new UnsupportedOperationException(compatibility.reason);
        }
        File outputFile = ScoringExporter.getOutputFile(this.exportId);
        File parent = outputFile.getParentFile();
        DKUFileUtils.mkdirs((File)parent);
        this.writer.writeTo(new FileOutputStream(outputFile));
        return this.exportId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String contentType, String exportUUID, HttpServletResponse resp) throws Exception {
        File fromFile = ScoringExporter.getOutputFile(exportUUID);
        if (fromFile == null || !fromFile.isFile() || fromFile.getName().length() <= 36) {
            DKUControllerBase.send404((String)"Exported file not found", (HttpServletResponse)resp);
            return;
        }
        String fileName = fromFile.getName().substring(36);
        try {
            resp.setContentType(contentType);
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            resp.setHeader("Content-Length", "" + fromFile.length());
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fromFile));){
                IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            DKUFileUtils.forceDelete((File)fromFile);
        }
    }

    private static File getOutputFile(String exportUUID) {
        return DKUApp.getFile((String[])new String[]{"tmp", "model-export", exportUUID});
    }

    public void exportTo(HttpServletResponse resp) throws Exception {
        String exportUUID = this.export();
        ScoringExporter.download(this.writer.getContentType(), exportUUID, resp);
    }

    public void exportToStream(OutputStream os) throws Exception {
        String exportUUID = this.export();
        File fromFile = ScoringExporter.getOutputFile(exportUUID);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fromFile));){
            IOUtils.copy((InputStream)bis, (OutputStream)os);
        }
    }

    public static void copyResourcesFromFMI(File tmpResources, FullModelId fullModelId) throws IOException {
        boolean isAnalysisModel;
        boolean bl = isAnalysisModel = fullModelId.type == FullModelId.Type.ANALYSIS;
        if (isAnalysisModel) {
            PredictionSMMgmtService.fillPipelineMeta(fullModelId);
        }
        File resources = fullModelId.getModelFolder();
        if (fullModelId.isPartitionedBaseModel()) {
            String[] partitions;
            DKUFileUtils.copyDirectory((File)resources, (File)tmpResources);
            if (isAnalysisModel) {
                PredictionSMMgmtService.copyPipelineFromMLTask(fullModelId, tmpResources, false);
            }
            File partsFolder = new File(tmpResources, "parts");
            partsFolder.mkdir();
            for (String partition : partitions = fullModelId.parseModelFile((String)"dss_pipeline_meta.json", Build.DssPipelineMeta.class).partitions) {
                File partitionFolder = new File(partsFolder, StringUtils.escape((String)partition));
                partitionFolder.mkdir();
                FullModelId pfmi = fullModelId.getModelPartition(partition);
                DKUFileUtils.copyDirectory((File)pfmi.getModelFolder(), (File)partitionFolder);
                if (!isAnalysisModel) continue;
                PredictionSMMgmtService.copyPipelineFromMLTask(pfmi, partitionFolder, false);
            }
        } else if (isAnalysisModel) {
            DKUFileUtils.copyDirectory((File)resources, (File)tmpResources);
            PredictionSMMgmtService.copyPipelineFromMLTask(fullModelId, tmpResources, false);
        } else {
            DKUFileUtils.copyDirectory((File)resources, (File)tmpResources);
        }
    }

    static interface ScoringWriter {
        public CompatibilityWithReason getCompatibility() throws IOException;

        public void writeTo(OutputStream var1) throws Exception;

        public String makeFileName() throws IOException;

        public String getContentType();
    }
}

