/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.UsersService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupPermissionsWatcher
extends PermissionsWatcher {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UsersService usersService;
    private final String groupName;

    public GroupPermissionsWatcher(String groupName) {
        SpringUtils.getInstance().autowire((Object)this);
        this.groupName = groupName;
    }

    @Override
    protected List<SerializedProject> getProjectsUnsafe() throws IOException {
        return this.projectsService.listAllUnsafe();
    }

    @Override
    protected List<UsersDAO.User> getUsersUnsafe() throws IOException {
        return this.usersService.listUsersInternalUnsafeEnabledOnlyForGroup(this.groupName);
    }
}

