/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import java.io.IOException;

public class NoopCredentialsService
implements ICredentialsService {
    @Override
    public ICredentialsService.Credential getCredential_AutoTXN(AuthCtx authCtx, DSSConnection connection) throws IOException {
        switch (connection.credentialsMode) {
            case GLOBAL: {
                if (connection instanceof ConnectionWithBasicCredential) {
                    return ((ConnectionWithBasicCredential)((Object)connection)).getGlobalCredential();
                }
                throw new SecurityException("Don't know how to get credential for connection " + String.valueOf(connection));
            }
            case PER_USER: {
                throw new UnsupportedOperationException("This service does not support per-user credentials; connection was " + String.valueOf(connection));
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public ICredentialsService.BasicCredential getDecryptedCredential_AutoTXN(AuthCtx authCtx, DSSConnection connection) {
        switch (connection.credentialsMode) {
            case GLOBAL: {
                if (connection instanceof ConnectionWithBasicCredential) {
                    return ((ConnectionWithBasicCredential)((Object)connection)).getGlobalCredential();
                }
                throw new SecurityException("Don't know how to get credential for connection " + String.valueOf(connection));
            }
            case PER_USER: {
                throw new UnsupportedOperationException("This service does not support per-user credentials; connection was " + String.valueOf(connection));
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public ICredentialsService.Credential getDecryptedCredential_AutoTXN(AuthCtx authCtx, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) {
        throw new UnsupportedOperationException("This service does not support plugin credentials; plugin ID was " + String.valueOf(credentialRequestInfo));
    }
}

