/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.auth;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.dip.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.PublicAPIKeyChangedEvent;
import com.dataiku.dip.server.services.IProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublicAPIKeysService {
    private static final long DAY_IN_MILLIS = 86400000L;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private IProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private UsersDAO usersDAO;
    private final Map<LookupKey, LegacyGlobalScopePublicAPIKey> inMemoryKeys = new HashMap<LookupKey, LegacyGlobalScopePublicAPIKey>();
    private Map<LookupKey, PublicAPIKey> cachedKeys;
    public static final String GLOBAL_FILENAME = "public-apikeys.json";
    public static final String PERSONAL_FILENAME = "personal-apikeys.json";
    private long globalFileTs;
    private long personalFileTs;
    public boolean standalone;
    static Logger logger = Logger.getLogger((String)"dip.services.apikeys");

    private synchronized void dropCache() {
        this.cachedKeys = null;
    }

    private synchronized void putInCache(PublicAPIKey key) {
        this.cachedKeys.put(new LookupKey(null, null, key.id), key);
        if (key instanceof ProjectScopePublicAPIKey) {
            this.cachedKeys.put(new LookupKey(((ProjectScopePublicAPIKey)key).projectKey, null, key.id), key);
        }
    }

    private synchronized void fillCacheIfNeeded() throws IOException {
        Object list;
        RelFile rf;
        if (this.standalone) {
            return;
        }
        if (this.haveFilesBeenModified()) {
            logger.warn((Object)"Invalidating API keys cache");
            this.cachedKeys = null;
            this.resetRefTs();
        }
        if (this.cachedKeys != null) {
            return;
        }
        TransactionRef tr = TransactionContext.retrieveRead();
        this.cachedKeys = new HashMap<LookupKey, PublicAPIKey>();
        for (String spProjectKey : this.projectsService.listKeys()) {
            try {
                RelFile rf2 = this.apiKeysFile(spProjectKey);
                if (!tr.isFile(rf2)) continue;
                ProjectScopePublicAPIKey.KeyList keyList = (ProjectScopePublicAPIKey.KeyList)tr.readObject(rf2, ProjectScopePublicAPIKey.KeyList.class);
                for (ProjectScopePublicAPIKey key : keyList) {
                    key.projectKey = spProjectKey;
                    this.putInCache(key);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read project keys for " + spProjectKey), (Throwable)e);
            }
        }
        try {
            rf = RelFile.global((String)GLOBAL_FILENAME);
            if (tr.exists(rf)) {
                list = (AbstractGlobalScopePublicAPIKey.KeyList)tr.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
                Iterator<Object> iterator = ((ArrayList)list).iterator();
                while (iterator.hasNext()) {
                    AbstractGlobalScopePublicAPIKey abstractGlobalScopePublicAPIKey = (AbstractGlobalScopePublicAPIKey)((Object)iterator.next());
                    this.putInCache(abstractGlobalScopePublicAPIKey);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read global keys", (Throwable)e);
            this.dropCache();
        }
        try {
            rf = RelFile.global((String)PERSONAL_FILENAME);
            if (tr.exists(rf)) {
                list = (PersonalPublicAPIKey.ListFile)tr.readObject(rf, PersonalPublicAPIKey.ListFile.class);
                for (PersonalPublicAPIKey personalPublicAPIKey : ((PersonalPublicAPIKey.ListFile)list).keys) {
                    this.putInCache(personalPublicAPIKey);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read global keys", (Throwable)e);
            this.dropCache();
        }
        if (this.cachedKeys != null) {
            logger.info((Object)("Put in cache " + this.cachedKeys.size() + " entries"));
        }
    }

    private boolean haveFilesBeenModified() throws IOException {
        RelFile globalrf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(globalrf = RelFile.global((String)GLOBAL_FILENAME)) && tr.getLastModified(globalrf) != this.globalFileTs) {
            return true;
        }
        RelFile personalrf = RelFile.global((String)PERSONAL_FILENAME);
        return tr.isFile(personalrf) && tr.getLastModified(personalrf) != this.personalFileTs;
    }

    private void resetRefTs() throws IOException {
        RelFile personalrf;
        RelFile globalrf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(globalrf = RelFile.global((String)GLOBAL_FILENAME))) {
            this.globalFileTs = tr.getLastModified(globalrf);
        }
        if (tr.isFile(personalrf = RelFile.global((String)PERSONAL_FILENAME))) {
            this.personalFileTs = tr.getLastModified(personalrf);
        }
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init API keys service");
        DSSEventListener<DSSEvent> listener = new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) {
                try (Transaction t = PublicAPIKeysService.this.transactionService.beginRead();){
                    PublicAPIKeysService.this.dropCache();
                    try {
                        PublicAPIKeysService.this.fillCacheIfNeeded();
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Failed to fill cache ...", (Throwable)e);
                    }
                }
            }
        };
        this.pubSub.subscribe("project-created", (DSSEventListener)listener);
        this.pubSub.subscribe("project-deleted", (DSSEventListener)listener);
        this.pubSub.subscribe("project-bundle-activated", (DSSEventListener)listener);
        this.pubSub.subscribe("project-refreshed", (DSSEventListener)listener);
        DSSMetrics.registry().register("dku.apikeys.inMemoryKeys.total", (Metric)new Gauge<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer getValue() {
                PublicAPIKeysService publicAPIKeysService = PublicAPIKeysService.this;
                synchronized (publicAPIKeysService) {
                    return PublicAPIKeysService.this.inMemoryKeys.size() / 2;
                }
            }
        });
        logger.debug((Object)"Done init API keys service");
    }

    public synchronized List<AbstractGlobalScopePublicAPIKey> listGlobalAPIKeys() throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList keys = (AbstractGlobalScopePublicAPIKey.KeyList)tr.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        if (ApiKeyUtils.useHashedApiKeys()) {
            keys.forEach(APIKeyBase::redactKeySecret);
        }
        return keys.stream().filter(key -> !key.isManagedKey()).collect(Collectors.toList());
    }

    private void checkGroups(AbstractGlobalScopePublicAPIKey key) throws IOException {
        if (key instanceof GlobalScopePublicAPIKeyWithGroups) {
            GlobalScopePublicAPIKeyWithGroups newGlobalKey = (GlobalScopePublicAPIKeyWithGroups)key;
            for (String group : newGlobalKey.getGroups()) {
                this.usersDAO.getGroupMandatory(group);
            }
        }
    }

    public synchronized AbstractGlobalScopePublicAPIKey createGlobalAPIKey(AbstractGlobalScopePublicAPIKey newKey) throws IOException {
        this.checkGroups(newKey);
        newKey.id = SecretKeyGenerator.generate((int)16);
        if (StringUtils.isBlank((String)newKey.key)) {
            newKey.key = ApiKeyUtils.generateApiKeySecret();
        }
        newKey.createdOn = new Date().getTime();
        newKey.managedKey = false;
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey keyCopy = newKey.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)keyCopy.key);
        keyCopy.expiresOn = keyCopy.expiry > 0 ? keyCopy.createdOn + (long)keyCopy.expiry * 86400000L : 0L;
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        list.add(keyCopy);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.cachedKeys.put(new LookupKey(null, newKey.key, null), keyCopy);
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(newKey.label, null, PublicAPIKeyChangedEvent.ActionType.CREATED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
        return newKey;
    }

    public AbstractGlobalScopePublicAPIKey getGlobalAPIKeyById(String keyId) throws IOException {
        return this.getGlobalAPIKeyByIdInternal(keyId, !ApiKeyUtils.useHashedApiKeys());
    }

    public AbstractGlobalScopePublicAPIKey getGlobalAPIKeyByIdWithSecret(String keyId) throws IOException {
        return this.getGlobalAPIKeyByIdInternal(keyId, true);
    }

    private synchronized AbstractGlobalScopePublicAPIKey getGlobalAPIKeyByIdInternal(String keyId, boolean withSecret) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef t = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        for (AbstractGlobalScopePublicAPIKey key : list) {
            if (!key.id.equals(keyId)) continue;
            if (!withSecret) {
                key.redactKeySecret();
            }
            return key;
        }
        throw ErrorContext.iae((String)"Key not found");
    }

    public synchronized AbstractGlobalScopePublicAPIKey getGlobalAPIKeyFromKey(String keyKey) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef t = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        for (AbstractGlobalScopePublicAPIKey key : list) {
            if (!ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.getKey())) continue;
            if (ApiKeyUtils.useHashedApiKeys()) {
                key.redactKeySecret();
            }
            return key;
        }
        throw ErrorContext.iae((String)"Key not found");
    }

    public void updateGlobalAPIKeyByKey(String keyToFind, AbstractGlobalScopePublicAPIKey updatedKey) throws IOException {
        this.updateGlobalAPIKey(updatedKey, key -> key.getKey().equals(keyToFind));
    }

    public void updateGlobalAPIKeyById(AbstractGlobalScopePublicAPIKey updatedKey) throws IOException {
        this.updateGlobalAPIKey(updatedKey, key -> key.id.equals(updatedKey.id));
    }

    private synchronized void updateGlobalAPIKey(AbstractGlobalScopePublicAPIKey updatedKey, Predicate<AbstractGlobalScopePublicAPIKey> keyFilter) throws IOException {
        this.checkGroups(updatedKey);
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        int foundIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            AbstractGlobalScopePublicAPIKey _fk = (AbstractGlobalScopePublicAPIKey)((Object)list.get(i));
            if (!keyFilter.test(_fk)) continue;
            if (updatedKey instanceof LegacyGlobalScopePublicAPIKey && _fk instanceof GlobalScopePublicAPIKeyWithGroups) {
                throw ErrorContext.iae((String)"Converting a global API key with groups into a global API key without groups is not allowed");
            }
            foundIdx = i;
            updatedKey.key = _fk.key;
            updatedKey.managedKey = _fk.managedKey;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        updatedKey.expiresOn = updatedKey.expiry > 0 ? updatedKey.createdOn + (long)updatedKey.expiry * 86400000L : 0L;
        list.set(foundIdx, updatedKey);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(updatedKey.label, null, PublicAPIKeyChangedEvent.ActionType.EDITED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
    }

    public AbstractGlobalScopePublicAPIKey deleteGlobalAPIKeyByKey(String keyKey) throws IOException {
        return this.deleteGlobalAPIKey(key -> ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.getKey()));
    }

    public AbstractGlobalScopePublicAPIKey deleteGlobalAPIKeyById(String keyId) throws IOException {
        return this.deleteGlobalAPIKey(key -> key.id.equals(keyId));
    }

    private synchronized AbstractGlobalScopePublicAPIKey deleteGlobalAPIKey(Predicate<AbstractGlobalScopePublicAPIKey> keyFilter) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        int foundIdx = -1;
        AbstractGlobalScopePublicAPIKey foundKey = null;
        for (int i = 0; i < list.size(); ++i) {
            foundKey = (AbstractGlobalScopePublicAPIKey)((Object)list.get(i));
            if (foundKey.isManagedKey() || !keyFilter.test(foundKey)) continue;
            foundIdx = i;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to delete not found");
        }
        list.remove(foundIdx);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(foundKey.label, null, PublicAPIKeyChangedEvent.ActionType.DELETED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
        return foundKey;
    }

    public synchronized List<LegacyGlobalScopePublicAPIKey> listInMemoryAPIKeys() {
        return this.inMemoryKeys.values().stream().distinct().filter(key -> !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)key)).map(LegacyGlobalScopePublicAPIKey::deepCopy).peek(APIKeyBase::redactKeySecret).collect(Collectors.toList());
    }

    public synchronized void invalidateInMemoryAPIKeys() {
        this.inMemoryKeys.clear();
    }

    public synchronized LegacyGlobalScopePublicAPIKey getInMemoryAPIKey(String requestedBy, String label, String dssUserForImpersonation, UsersDAO.GroupPermissions permissions, Map<String, Cluster.PermissionItem> clusterPermissionItems, Set<String> containerConfNames, Set<String> connectionNames) {
        List<LegacyGlobalScopePublicAPIKey> expiredKeys = ((Stream)this.inMemoryKeys.values().stream().distinct().parallel()).filter(ApiKeyUtils::isInMemoryKeyExpired).toList();
        expiredKeys.forEach(key -> {
            this.inMemoryKeys.remove((Object)new LookupKey(null, key.key, null));
            this.inMemoryKeys.remove((Object)new LookupKey(null, null, key.id));
        });
        Optional<LegacyGlobalScopePublicAPIKey> optionalPublicAPIKey = ((Stream)this.inMemoryKeys.values().stream().distinct().parallel()).filter(ApiKeyUtils::isInMemoryKeyValid).filter(k -> k.createdBy.equals(requestedBy) && StringUtils.equals((String)k.dssUserForImpersonation, (String)dssUserForImpersonation) && k.getGlobalPermissions().hasSameResolvedPermissionsAs(permissions) && (k.getGlobalPermissions().mayManageClusters() || k.hasSameClusterPrivilegesAs(clusterPermissionItems)) && k.hasSameContainerConfPrivilegesAs(containerConfNames) && k.hasSameFreelyUsableConnectionsAs(connectionNames)).findFirst();
        if (optionalPublicAPIKey.isPresent()) {
            return optionalPublicAPIKey.get();
        }
        LegacyGlobalScopePublicAPIKey newKey = new LegacyGlobalScopePublicAPIKey();
        newKey.label = label;
        newKey.createdBy = requestedBy.isEmpty() ? "pintercom" : requestedBy;
        newKey.createdOn = new Date().getTime();
        newKey.setGlobalPermissions(permissions);
        newKey.dssUserForImpersonation = dssUserForImpersonation;
        clusterPermissionItems.forEach(newKey::addClusterPrivileges);
        containerConfNames.forEach(newKey::addContainerConfPrivilege);
        connectionNames.forEach(newKey::addUsableConnection);
        newKey.id = ApiKeyUtils.generateInMemoryApiKeyId();
        newKey.key = ApiKeyUtils.generateInMemoryApiKeySecret();
        this.inMemoryKeys.put(new LookupKey(null, null, newKey.id), newKey);
        this.inMemoryKeys.put(new LookupKey(null, newKey.key, null), newKey);
        logger.info((Object)("Created new in-memory public API key: " + newKey.id + " (for " + newKey.createdBy + ")"));
        DSSMetrics.registry().meter("dku.apikeys.inMemoryKeys.created").mark();
        return newKey;
    }

    public synchronized LegacyGlobalScopePublicAPIKey getInMemoryAPIKey(String requestedBy, String label, String dssUserForImpersonation) {
        return this.getInMemoryAPIKey(requestedBy, label, dssUserForImpersonation, new UsersDAO.GroupPermissions().withAdmin(true), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
    }

    public void putInMemoryAPIKeyInThePast(String keyId) {
        LegacyGlobalScopePublicAPIKey imk = this.inMemoryKeys.get((Object)new LookupKey(null, null, keyId));
        imk.createdOn -= 86400000L;
    }

    public synchronized List<ProjectScopePublicAPIKey> listProjectAPIKeys(String projectKey) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.apiKeysFile(projectKey))) {
            return new ArrayList<ProjectScopePublicAPIKey>();
        }
        ProjectScopePublicAPIKey.KeyList list = (ProjectScopePublicAPIKey.KeyList)tr.readObject(rf, ProjectScopePublicAPIKey.KeyList.class);
        for (ProjectScopePublicAPIKey key : list) {
            key.projectKey = projectKey;
        }
        return list;
    }

    public synchronized ProjectScopePublicAPIKey createProjectAPIKey(ProjectScopePublicAPIKey newKey) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.getUser().isAdmin() && newKey.dssUserForImpersonation != null) {
            throw new SecurityException("You may not modify impersonation user");
        }
        newKey.id = SecretKeyGenerator.generate((int)16);
        newKey.key = ApiKeyUtils.generateApiKeySecret();
        newKey.createdOn = new Date().getTime();
        long apiKeyExpiryInMillis = this.getApiKeysExpiryInMillis();
        if (apiKeyExpiryInMillis > 0L) {
            newKey.expiresOn = newKey.createdOn + apiKeyExpiryInMillis;
        }
        List<ProjectScopePublicAPIKey> list = this.listProjectAPIKeys(newKey.projectKey);
        ProjectScopePublicAPIKey keyCopy = newKey.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)newKey.key);
        list.add(keyCopy);
        t.writeObject(this.apiKeysFile(newKey.projectKey), list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.cachedKeys.put(new LookupKey(null, newKey.key, null), keyCopy);
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(newKey.label, newKey.projectKey, PublicAPIKeyChangedEvent.ActionType.CREATED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
        return newKey;
    }

    public synchronized void updateProjectAPIKey(ProjectScopePublicAPIKey updatedKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)updatedKey.key), (Object)"Empty  API key");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile rf = this.apiKeysFile(updatedKey.projectKey);
        List<ProjectScopePublicAPIKey> list = this.listProjectAPIKeys(updatedKey.projectKey);
        int foundIdx = -1;
        ProjectScopePublicAPIKey oldKey = null;
        for (int i = 0; i < list.size(); ++i) {
            ProjectScopePublicAPIKey foundKey = list.get(i);
            if (!foundKey.id.equals(updatedKey.id) || !foundKey.getKey().equals(updatedKey.getKey())) continue;
            foundIdx = i;
            oldKey = foundKey;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        assert (oldKey != null);
        if (!t.getUser().isAdmin() && !StringUtils.equals((String)oldKey.dssUserForImpersonation, (String)updatedKey.dssUserForImpersonation)) {
            throw new SecurityException("You may not modify impersonation user");
        }
        list.set(foundIdx, updatedKey);
        t.writeObject(rf, list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(updatedKey.label, updatedKey.projectKey, PublicAPIKeyChangedEvent.ActionType.EDITED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
    }

    private synchronized void updateProjectAPIKeysExpiry(String projectKey) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile rf = this.apiKeysFile(projectKey);
        List<ProjectScopePublicAPIKey> list = this.listProjectAPIKeys(projectKey);
        int foundIdx = -1;
        Object oldKey = null;
        long expiryInDays = this.getApiKeysExpiryInMillis();
        for (int i = 0; i < list.size(); ++i) {
            ProjectScopePublicAPIKey foundKey = list.get(i);
            foundKey.expiresOn = expiryInDays > 0L ? foundKey.createdOn + expiryInDays : 0L;
            list.set(i, foundKey);
        }
        t.writeObject(rf, list);
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent("Update project API keys expiration date", projectKey, PublicAPIKeyChangedEvent.ActionType.EDITED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
    }

    public ProjectScopePublicAPIKey deleteProjectAPIKeyByKey(String projectKey, String keyKey) throws IOException {
        return this.deleteProjectAPIKey(projectKey, key -> ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.getKey()));
    }

    public ProjectScopePublicAPIKey deleteProjectAPIKeyById(String projectKey, String keyId) throws IOException {
        return this.deleteProjectAPIKey(projectKey, key -> key.id.equals(keyId));
    }

    private synchronized ProjectScopePublicAPIKey deleteProjectAPIKey(String projectKey, Predicate<ProjectScopePublicAPIKey> keyFilter) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        List<ProjectScopePublicAPIKey> list = this.listProjectAPIKeys(projectKey);
        int foundIdx = -1;
        ProjectScopePublicAPIKey foundKey = null;
        for (int i = 0; i < list.size(); ++i) {
            foundKey = list.get(i);
            if (!keyFilter.test(foundKey)) continue;
            foundIdx = i;
            break;
        }
        if (foundKey == null) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        list.remove(foundIdx);
        t.writeObject(this.apiKeysFile(projectKey), list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(foundKey.label, foundKey.projectKey, PublicAPIKeyChangedEvent.ActionType.DELETED, t.getUser().getAssociatedDSSUserOrIdentifier()));
        }
        return foundKey;
    }

    public synchronized List<PersonalPublicAPIKey> listMyPersonalAPIKeys(AuthCtx ctx) throws IOException {
        if (ctx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            throw new SecurityException("Only users may do this");
        }
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<PersonalPublicAPIKey> list = new ArrayList<PersonalPublicAPIKey>();
        for (PersonalPublicAPIKey pu : ((PersonalPublicAPIKey.ListFile)tr.readObjectDefault((RelFile)rf, PersonalPublicAPIKey.ListFile.class)).keys) {
            if (!pu.user.equals(ctx.getAssociatedDSSUser())) continue;
            if (ApiKeyUtils.useHashedApiKeys()) {
                pu.redactKeySecret();
            }
            list.add(pu);
        }
        return list;
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKey(AuthCtx ctx, String label, String description) throws IOException {
        switch (ctx.getAuthSource()) {
            case USER_FROM_UI: {
                return this.createPersonalAPIKeyInternal(ctx, ctx.getAssociatedDSSUser(), label, description);
            }
        }
        throw new SecurityException("Only users may do this");
    }

    public synchronized void updatePersonalAPIKey(String keyId, String label, String description) throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        PersonalPublicAPIKey foundKey = null;
        for (int i = 0; i < list.keys.size(); ++i) {
            PersonalPublicAPIKey apiKey = list.keys.get(i);
            if (!apiKey.id.equals(keyId)) continue;
            foundIdx = i;
            foundKey = apiKey;
            break;
        }
        if (foundIdx == -1 || foundKey == null) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        foundKey.label = label;
        foundKey.description = description;
        list.keys.set(foundIdx, foundKey);
        tr.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(foundKey.id, null, PublicAPIKeyChangedEvent.ActionType.EDITED, tr.getUser().getAssociatedDSSUser()));
        }
    }

    private synchronized void updatePersonalAPIKeysExpiry() throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        Object foundKey = null;
        long expiryInDays = this.getApiKeysExpiryInMillis();
        for (int i = 0; i < list.keys.size(); ++i) {
            PersonalPublicAPIKey apiKey = list.keys.get(i);
            apiKey.expiresOn = expiryInDays > 0L ? apiKey.createdOn + expiryInDays : 0L;
            list.keys.set(i, apiKey);
        }
        tr.writeObject(rf, (Object)list);
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent("Update personal API keys expiration date", null, PublicAPIKeyChangedEvent.ActionType.EDITED, tr.getUser().getAssociatedDSSUser()));
        }
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKeyInternal(AuthCtx ctx, String user, String label, String description) throws IOException {
        return this.createPersonalAPIKeyInternal(ctx, user, label, description, null);
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKeyInternal(AuthCtx ctx, String user, String label, String description, @Nullable String secret) throws IOException {
        PersonalPublicAPIKey pu = new PersonalPublicAPIKey();
        pu.label = label;
        pu.id = SecretKeyGenerator.generate((int)16);
        pu.key = StringUtils.isNotBlank((String)secret) ? secret : ApiKeyUtils.generateApiKeySecret();
        pu.description = description;
        pu.createdOn = new Date().getTime();
        pu.createdBy = ctx.getAssociatedDSSUser();
        pu.user = user;
        long apiKeyExpiryInMillis = this.getApiKeysExpiryInMillis();
        if (apiKeyExpiryInMillis > 0L) {
            pu.expiresOn = pu.createdOn + apiKeyExpiryInMillis;
        }
        PersonalPublicAPIKey keyCopy = pu.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)keyCopy.key);
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        list.keys.add(keyCopy);
        tr.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.cachedKeys.put(new LookupKey(null, pu.key, null), keyCopy);
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(pu.label, null, PublicAPIKeyChangedEvent.ActionType.CREATED, tr.getUser().getAssociatedDSSUser()));
        }
        return pu;
    }

    public synchronized PersonalPublicAPIKey deletePersonalAPIKeyById(String id) throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)t.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        PersonalPublicAPIKey foundKey = null;
        for (int i = 0; i < list.keys.size(); ++i) {
            foundKey = list.keys.get(i);
            if (!foundKey.id.equals(id)) continue;
            foundIdx = i;
            break;
        }
        if (foundKey == null) {
            throw ErrorContext.iae((String)"Key to delete not found");
        }
        list.keys.remove(foundIdx);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.pubSub.publishAfterTransaction(new PublicAPIKeyChangedEvent(foundKey.label, null, PublicAPIKeyChangedEvent.ActionType.DELETED, t.getUser().getAssociatedDSSUser()));
        }
        return foundKey;
    }

    public synchronized PublicAPIKey getKey(String key) throws IOException {
        LegacyGlobalScopePublicAPIKey globalScopePublicAPIKey = this.inMemoryKeys.get((Object)new LookupKey(null, key, null));
        if (globalScopePublicAPIKey != null && !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)globalScopePublicAPIKey)) {
            return globalScopePublicAPIKey;
        }
        this.fillCacheIfNeeded();
        if (this.cachedKeys == null) {
            logger.warn((Object)"No cached keys !");
            return null;
        }
        return this.getKeyFromCache(key);
    }

    private PublicAPIKey getKeyFromCache(String key) {
        PublicAPIKey foundKey = this.cachedKeys.get((Object)new LookupKey(null, key, null));
        if (foundKey != null && this.isApiKeyValid(foundKey)) {
            return foundKey;
        }
        for (PublicAPIKey cachedKey : this.cachedKeys.values()) {
            if (!StringUtils.isNotBlank((String)cachedKey.key) || !this.isApiKeyValid(cachedKey) || !ApiKeyUtils.compareKeySecret((String)key, (String)cachedKey.key)) continue;
            this.cachedKeys.put(new LookupKey(null, key, null), cachedKey);
            return cachedKey;
        }
        return null;
    }

    public synchronized PublicAPIKey getKeyById(String id) throws IOException {
        return this.getKeyById(id, null);
    }

    public synchronized PublicAPIKey getKeyById(String id, String projectKey) throws IOException {
        if (id.startsWith("dkuimk-")) {
            LegacyGlobalScopePublicAPIKey globalScopePublicAPIKey = this.inMemoryKeys.get((Object)new LookupKey(projectKey, null, id));
            if (globalScopePublicAPIKey != null && !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)globalScopePublicAPIKey)) {
                return globalScopePublicAPIKey;
            }
            return null;
        }
        this.fillCacheIfNeeded();
        if (this.cachedKeys == null) {
            logger.warn((Object)"No cached keys !");
            return null;
        }
        PublicAPIKey key = this.cachedKeys.get((Object)new LookupKey(projectKey, null, id));
        return this.isApiKeyValid(key) ? key : null;
    }

    public synchronized List<PersonalPublicAPIKey> getPersonalKeys() throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        List<PersonalPublicAPIKey> keys = ((PersonalPublicAPIKey.ListFile)tr.readObjectDefault((RelFile)rf, PersonalPublicAPIKey.ListFile.class)).keys;
        if (ApiKeyUtils.useHashedApiKeys()) {
            keys.forEach(APIKeyBase::redactKeySecret);
        }
        return keys;
    }

    public Optional<PersonalPublicAPIKey> getPersonalKeyById(String id) throws IOException {
        return this.getPersonalKeys().stream().filter(key -> key.id.equals(id)).findAny();
    }

    public WebAppDatasetLevelPermissions getDatasetLevelPermissions(AuthCtx liu, String projectKey, String apiKeyId) throws Exception {
        this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        PublicAPIKey keyObj = this.getKeyById(apiKeyId, projectKey);
        if (keyObj == null || !(keyObj instanceof ProjectScopePublicAPIKey)) {
            throw new IllegalArgumentException("Bad API key");
        }
        ProjectScopePublicAPIKey pkeyObj = (ProjectScopePublicAPIKey)keyObj;
        HashMap<String, List<Privileges.DatasetLevelPrivilegeType>> map = new HashMap<String, List<Privileges.DatasetLevelPrivilegeType>>();
        for (ProjectScopePublicAPIKey.LocalDatasetPrivilege ldp : pkeyObj.getLocalDatasetPrivileges()) {
            for (String dataset : ldp.datasets) {
                map.put(dataset, ldp.privileges);
            }
        }
        WebAppDatasetLevelPermissions perms = new WebAppDatasetLevelPermissions();
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
            WebAppDatasetLevelPermission wperm = new WebAppDatasetLevelPermission();
            wperm.datasetName = sd.name;
            List list = (List)map.get(sd.name);
            if (list != null) {
                wperm.readData = list.contains((Object)Privileges.DatasetLevelPrivilegeType.READ_DATA);
                wperm.readMetadata = list.contains((Object)Privileges.DatasetLevelPrivilegeType.READ_METADATA);
                wperm.readSchema = list.contains((Object)Privileges.DatasetLevelPrivilegeType.READ_SCHEMA);
                wperm.writeSchema = list.contains((Object)Privileges.DatasetLevelPrivilegeType.WRITE_SCHEMA);
                wperm.writeMetadata = list.contains((Object)Privileges.DatasetLevelPrivilegeType.WRITE_METADATA);
            }
            perms.datasets.add(wperm);
        }
        return perms;
    }

    public void setDatasetLevelPermissions(AuthCtx liu, String projectKey, String apiKeyId, WebAppDatasetLevelPermissions perms) throws Exception {
        this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        PublicAPIKey keyObj = this.getKeyById(apiKeyId, projectKey);
        if (!(keyObj instanceof ProjectScopePublicAPIKey)) {
            throw new IllegalArgumentException("Bad project key");
        }
        ProjectScopePublicAPIKey pkeyObj = (ProjectScopePublicAPIKey)keyObj;
        List<ProjectScopePublicAPIKey.LocalDatasetPrivilege> allPrivs = pkeyObj.getLocalDatasetPrivileges();
        allPrivs.clear();
        for (WebAppDatasetLevelPermission wperm : perms.datasets) {
            ProjectScopePublicAPIKey.LocalDatasetPrivilege newPriv = new ProjectScopePublicAPIKey.LocalDatasetPrivilege();
            newPriv.datasets.add(wperm.datasetName);
            if (wperm.readData) {
                newPriv.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_DATA);
            }
            if (wperm.readMetadata) {
                newPriv.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_METADATA);
            }
            if (wperm.readSchema) {
                newPriv.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_SCHEMA);
            }
            if (wperm.writeMetadata) {
                newPriv.privileges.add(Privileges.DatasetLevelPrivilegeType.WRITE_METADATA);
            }
            if (wperm.writeSchema) {
                newPriv.privileges.add(Privileges.DatasetLevelPrivilegeType.WRITE_SCHEMA);
            }
            allPrivs.add(newPriv);
        }
        this.updateProjectAPIKey(pkeyObj);
    }

    private RelFile apiKeysFile(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "apikeys.json"});
    }

    private boolean isApiKeyValid(PublicAPIKey key) {
        return key.expiresOn == 0L || key.expiresOn > System.currentTimeMillis();
    }

    private long getApiKeysExpiryInMillis() {
        return (long)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.apiKeysLifetimeDays * 86400000L;
    }

    public synchronized void updateApiKeysLifetime() throws Exception {
        this.updatePersonalAPIKeysExpiry();
        List<String> projectKeys = this.projectsService.listProjectKeys();
        for (String projectKey : projectKeys) {
            this.updateProjectAPIKeysExpiry(projectKey);
        }
        this.dropCache();
        this.fillCacheIfNeeded();
    }

    private static class LookupKey
    extends ImmutableValueObject {
        final String projectKey;
        final String key;
        final String id;

        LookupKey(String projectKey, String key, String id) {
            this.projectKey = projectKey;
            this.key = key;
            this.id = id;
        }
    }

    public static class WebAppDatasetLevelPermissions {
        public List<WebAppDatasetLevelPermission> datasets = new ArrayList<WebAppDatasetLevelPermission>();
    }

    public static class WebAppDatasetLevelPermission {
        public String datasetName;
        public boolean readData;
        public boolean readSchema;
        public boolean readMetadata;
        public boolean writeMetadata;
        public boolean writeSchema;
    }
}

