/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.ModelEvaluationSampleDataService;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.model.core.BaseUserMeta;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.PerTimeSeriesMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsFacts;
import com.dataiku.dip.analysis.model.prediction.PredictionIndividualExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionSubpopulation;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportEvaluationSampleInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.ModelComparisonsService;
import com.dataiku.dip.mec.ModelEvaluationService;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ModelEvaluationsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ModelEvaluationService modelEvaluationService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ModelEvaluationSampleDataService modelEvaluationSampleDataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "modelevaluations-get", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get"}, method={RequestMethod.GET})
    public void getModelEvaluation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws IOException, DKUSecurityException {
        AbstractModelEvaluation me;
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoReadAccess(u, fmeId.getUnderlyingStore(), fmeId.getProjectKey());
            me = this.modelEvaluationService.getModelEvaluation(fmeId);
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)me);
    }

    @AuditedCall(value={"msgType", "modelevaluations-save-meta", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/save-evaluation-model-user-meta"}, method={RequestMethod.POST})
    public void setModelMeta(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam ModelUserMeta meta) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmeId.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        TabularModelEvaluation me = fmeId.getTabularModelEvaluation();
        this.modelEvaluationService.saveModelUserMeta(me, meta);
    }

    @AuditedCall(value={"msgType", "modelevaluations-save-user-meta", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/save-evaluation-user-meta"}, method={RequestMethod.POST})
    public void setEvaluationUserMeta(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam BaseUserMeta meta) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmeId.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        AbstractModelEvaluation me = this.modelEvaluationService.getModelEvaluation(fmeId);
        me.userMeta = meta;
        this.modelEvaluationService.save(me);
    }

    @AuditedCall(value={"msgType", "modelevaluations-get-fme-compat-ref", "projectKey", "${projectKey}", "currentId", "${currentId}"})
    @RequestMapping(value={"/api/modelevaluations/list-compatible-references-for-drift"}, method={RequestMethod.GET})
    @ResponseBody
    public CompatibleReferencesResult getModelEvaluationCompatibleReferences(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String currentId) throws IOException, DKUSecurityException {
        ModelLikeId currentMe = ModelLikeId.parse(currentId, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, projectKey, currentMe.getUnderlyingStore().id, projectKey);
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
        }
        int maxComparables = DKUApp.getProperty((String)"dku.max.comparable_list.length", (int)1000);
        CompatibleReferencesResult compatibleReferences = new CompatibleReferencesResult();
        compatibleReferences.compatibleReferences = this.modelEvaluationService.getCompatibleReferences(projectKey, currentMe, compatibleReferences.infoMessages, maxComparables);
        compatibleReferences.defaultReference = this.modelEvaluationService.getReferenceForDrift(currentMe);
        return compatibleReferences;
    }

    @AuditedCall(value={"msgType", "modelevaluations-get-per-timeseries-metrics", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-per-timeseries-metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public PerTimeSeriesMetrics getPerTimeseriesMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        if (!fmeId.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmeId));
        }
        if (fmeId.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series metrics for 'time series forecasting' models");
        }
        TimeseriesForecastingModelPerf modelPerf = fmeId.getTimeseriesForecastingPerf(true);
        return new PerTimeSeriesMetrics(modelPerf);
    }

    @AuditedCall(value={"msgType", "modelevaluations-get-model-forecasts", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-model-forecasts"}, method={RequestMethod.GET})
    @ResponseBody
    public TimeseriesEvaluationForecasts getModelForecasts(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        if (!fmeId.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmeId));
        }
        if (fmeId.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch forecasts for 'time series forecasting' models");
        }
        return fmeId.getTimeseriesEvaluationForecasts();
    }

    @AuditedCall(value={"msgType", "modelevaluations-get-subpopulations-info", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-subpopulations-info"}, method={RequestMethod.GET})
    public void getSubpopulationsInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        PredictionSubpopulation subpop = PredictionResultsReader.getSubpopulationsInfo(fmeId);
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)(subpop != null ? subpop : new Object()));
    }

    @AuditedCall(value={"msgType", "modelevaluations-subpopulation-compute", "fme", "${fme}", "features", "${features}"})
    @RequestMapping(value={"/api/modelevaluations/subpopulation-computation-start"}, method={RequestMethod.POST})
    public void subpopulationComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam List<String> features, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoReadAccess(u, fmeId.getUnderlyingStore(), fmeId.getProjectKey());
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, this.modelEvaluationService.subpopulationComputationStart(user, fmeId, features, computationParams));
    }

    @AuditedCall(value={"msgType", "modelevaluations-get-subpopulation", "fme", "${fme}", "features", "${features}"})
    @RequestMapping(value={"/api/modelevaluations/get-subpopulation"}, method={RequestMethod.POST})
    public void getSubpopuplation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam List<String> features) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoReadAccess(u, fmeId.getUnderlyingStore(), fmeId.getProjectKey());
        }
        for (String feature : features) {
            this.checkNotBlank(feature, "Feature name cannot be empty", new Object[0]);
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeSubpopulationResults(fmeId, features, false));
    }

    @AuditedCall(value={"msgType", "modelevaluations-pdp-compute", "fme", "${fme}", "features", "${features}"})
    @RequestMapping(value={"/api/modelevaluations/pdp-computation-start"}, method={RequestMethod.POST})
    public void pdpComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam List<String> features, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoReadAccess(user, fmeId.getUnderlyingStore(), fmeId.getProjectKey());
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, this.modelEvaluationService.pdpComputationStart(user, fmeId, features, computationParams));
    }

    @AuditedCall(value={"msgType", "modelevaluations-prediction-get-global-explanations", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-global-explanations"}, method={RequestMethod.GET})
    public void getGlobalExplanations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws IOException, DKUSecurityException {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        Optional<PredictionGlobalExplanations> globalExplanations = fmeId.getGlobalExplanations();
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)(globalExplanations.isPresent() ? globalExplanations.get() : new Object()));
    }

    @AuditedCall(value={"msgType", "modelevaluations-prediction-get-global-explanations-facts", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-global-explanations-facts"}, method={RequestMethod.GET})
    public void getGlobalExplanationsFacts(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws IOException, DKUSecurityException {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        Optional<PredictionGlobalExplanationsFacts> globalExplanationsFacts = fmeId.getGlobalExplanationsFacts();
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)(globalExplanationsFacts.isPresent() ? globalExplanationsFacts.get() : new Object()));
    }

    @AuditedCall(value={"msgType", "modelevaluations-prediction-individual-explanations-compute", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/individual-explanations-computation-start"}, method={RequestMethod.POST})
    public void individualExplanationsComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoReadAccess(user, fmeId.getUnderlyingStore(), fmeId.getProjectKey());
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, this.modelEvaluationService.individualExplanationsComputationStart(user, fmeId, computationParams));
    }

    @AuditedCall(value={"msgType", "modelevaluations-prediction-get-individual-explanations", "fme", "${fme}"})
    @RequestMapping(value={"/api/modelevaluations/get-individual-explanations"}, method={RequestMethod.GET})
    public void getIndividualExplanations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme) throws IOException, DKUSecurityException {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, fmeId.getId());
            this.projectsService.failIfNoDashboardReadPermission(u, smartObjectRef, fmeId.getProjectKey());
        }
        PredictionIndividualExplanations explanations = this.modelEvaluationService.getIndividualExplanations(fmeId);
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)(explanations != null ? explanations : new Object()));
    }

    @AuditedCall(value={"msgType", "modelevaluations-data-drift", "projectKey", "${projectKey}", "referenceId", "${referenceId}", "currentId", "${currentId}"})
    @RequestMapping(value={"/api/modelevaluations/compute-drift"}, method={RequestMethod.POST})
    public void computeDrift(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String referenceId, @RequestParam String currentId, @RequestParam DriftParams params) throws Exception {
        DSSAuthCtx authCtx;
        ModelLikeId referenceModelLikeId = ModelLikeId.parse(referenceId, projectKey);
        ModelLikeId currentModelLikeId = ModelLikeId.parse(currentId, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.projectsService.failIfNoReadAccess(authCtx, referenceModelLikeId.getUnderlyingStore(), projectKey);
            this.projectsService.failIfNoReadAccess(authCtx, currentModelLikeId.getUnderlyingStore(), projectKey);
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, this.modelEvaluationService.startDriftComputation(authCtx, projectKey, referenceModelLikeId, currentModelLikeId, params));
    }

    public static FuturePayload buildFuturePayload(FullModelEvaluationId fme) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_model_evaluation_sample";
        fp.targets.add(DSSFuturePayloadUtils.forFME(fme).withPart("sample"));
        fp.displayName = "Refreshing model evaluation values table";
        return fp;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelevaluations/sample/refresh-table"})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam String displayScript, @RequestParam(value="filters", required=false, defaultValue="") String filters) throws Exception {
        FullModelEvaluationId parsedFme = FullModelEvaluationId.parse(fme);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, parsedFme.getId());
            this.projectsService.failIfNoDashboardReadPermission(user, smartObjectRef, parsedFme.getProjectKey());
            RefreshTableFutureThread ft = new RefreshTableFutureThread((DSSAuthCtx)user, parsedFme, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
            ModelEvaluationsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<ModelEvaluationSampleResult>>(){}));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelevaluations/sample/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam String displayScript, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        FullModelEvaluationId parsedFme = FullModelEvaluationId.parse(fme);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, parsedFme.getId());
            this.projectsService.failIfNoDashboardReadPermission(user, smartObjectRef, parsedFme.getProjectKey());
        }
        ModelEvaluationChunkResult result = new ModelEvaluationChunkResult();
        MemScriptRunner.TableWithReport twr = this.modelEvaluationSampleDataService.getUncachedFiltered_NT(parsedFme, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        result.chunkWithSelectedColumns = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        result.chunkWithSelectedColumns.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        sss.columnsSelection.list = null;
        sss.columnsSelection.mode = SerializedShakerScript.DisplayedColumnsMode.ALL;
        result.fullChunk = new SerializedTableChunk(firstRow, nbRows, 0, twr.initialCols);
        result.fullChunk.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelevaluations/sample/detailed-column-analysis"})
    public void detailedColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam String data, @RequestParam String column, @RequestParam int alphanumMaxResults) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmeId.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        ModelEvaluationsController.writeJSON((HttpServletResponse)resp, (Object)this.modelEvaluationSampleDataService.getDetailedColumnAnalysis(fmeId, ss, column, alphanumMaxResults));
    }

    @AuditInline
    @RequestMapping(value={"/api/modelevaluations/export-evaluation-sample"})
    @ResponseBody
    public ExportStatus exportEvaluationSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fme, @RequestParam ExportParams exportParams) throws Exception {
        FullModelEvaluationId fmeId = FullModelEvaluationId.parse(fme);
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, fmeId.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            ExportEvaluationSampleInput input = new ExportEvaluationSampleInput(fmeId);
            ExportStatus ret = this.exportService.handleExportRequest(authCtx, input, exportParams);
            this.auditTrailService.generic("modelevaluations-export-sample").with("fmeId", fmeId.toString()).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("modelevaluations-export-sample", (Throwable)e).with("fmeId", fmeId.toString()).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            throw e;
        }
    }

    public static class CompatibleReferencesResult {
        List<ModelComparisonsService.ComparableModelItem> compatibleReferences;
        @Nullable
        ModelLikeId defaultReference;
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
    }

    class RefreshTableFutureThread
    extends FutureThread<ModelEvaluationSampleResult> {
        final FullModelEvaluationId fme;
        final SerializedShakerScript displayScript;
        final FilterRequest frequest;
        final FuturePayload futurePayload;
        ModelEvaluationSampleResult result;

        public RefreshTableFutureThread(DSSAuthCtx user, FullModelEvaluationId fme, SerializedShakerScript sss, FilterRequest filterRequest) {
            super(user);
            this.result = new ModelEvaluationSampleResult();
            this.fme = fme;
            this.displayScript = sss;
            this.frequest = filterRequest;
            this.futurePayload = ModelEvaluationsController.buildFuturePayload(fme);
        }

        public ModelEvaluationSampleResult getResult() {
            return this.result;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            NDC.push((String)("refresh-sample-table: " + String.valueOf(this.fme)));
            try {
                MemScriptRunner.TableWithReport twr = ModelEvaluationsController.this.modelEvaluationSampleDataService.getUncachedFiltered_NT(this.fme, this.displayScript, this.frequest);
                this.result.tableWithSelectedColumns = new SerializedMemTableV2();
                this.result.fullTable = new SerializedMemTableV2();
                if (this.displayScript.columnsSelection.list == null) {
                    this.displayScript.columnsSelection.list = new ArrayList<SerializedShakerScript.DisplayedColumn>();
                    Set<String> columnsNotDisplayedByDefault = Set.of("llm_raw_query", "llm_raw_response", "dkuParsedToolCalls", "dkuParsedTrajectory");
                    for (MemColumn memColumn : twr.table.columnsList) {
                        SerializedShakerScript.DisplayedColumn displayedColumn = new SerializedShakerScript.DisplayedColumn();
                        displayedColumn.name = memColumn.getName();
                        displayedColumn.d = !columnsNotDisplayedByDefault.contains(memColumn.getName());
                        this.displayScript.columnsSelection.list.add(displayedColumn);
                    }
                    this.displayScript.columnsSelection.mode = SerializedShakerScript.DisplayedColumnsMode.SELECT;
                }
                this.result.tableWithSelectedColumns.fill(twr, this.displayScript, 64, 32);
                this.displayScript.columnsSelection.mode = SerializedShakerScript.DisplayedColumnsMode.ALL;
                this.displayScript.columnsSelection.list = null;
                this.result.fullTable.fill(twr, this.displayScript, 64, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                DIPInternalControllerBase.logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }

    static class ModelEvaluationChunkResult {
        SerializedTableChunk chunkWithSelectedColumns;
        SerializedTableChunk fullChunk;
    }

    static class ModelEvaluationSampleResult {
        SerializedMemTableV2 tableWithSelectedColumns;
        SerializedMemTableV2 fullTable;
    }
}

