/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.PersistentNotificationsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PersistentNotificationsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PersistentNotificationsService persistentNotifications;

    @AuditedCall(value={"msgType", "pnotifications-count"})
    @RequestMapping(value={"/api/notifications/count"})
    public void countNotifications(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        UnreadCount ret = new UnreadCount();
        ret.totalUnread = this.persistentNotifications.getUnreadCountForUser(liu.getIdentifier());
        PersistentNotificationsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "pnotifications-get"})
    @RequestMapping(value={"/api/notifications/get"})
    public void getNotifications(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        PersistentNotificationsController.writeJSON((HttpServletResponse)resp, (Object)this.persistentNotifications.getForUserWithSummaries(liu.getIdentifier()));
    }

    @AuditedCall(value={"msgType", "pnotifications-ack"})
    @RequestMapping(value={"/api/notifications/acknowledge"})
    public void ackNotifications(HttpServletRequest req, HttpServletResponse resp, @RequestParam long timestamp) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        this.persistentNotifications.acknowledge(liu.getIdentifier(), timestamp);
    }

    static class UnreadCount {
        int totalUnread;

        UnreadCount() {
        }
    }
}

