/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.report.ReportInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportSnapshot;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.reports.ReportsSnapshotsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.CallUsedByDashboard;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.EncodedContent;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ReportsSnapshotsController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ReportsSnapshotsService reportsSnapshotsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    private static String EXPORT_NOT_FOUND = "Export not found.";
    static Logger logger = Logger.getLogger((String)"dku.reports.snapshots");

    @AuditedCall(value={"msgType", "report-snapshot-create", "projectKey", "${projectKey}", "reportId", "${reportId}"})
    @RequestMapping(value={"/api/reports/snapshots/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String reportId) throws Exception {
        String script;
        Report report;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, reportId);
            report = this.reportsService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            script = this.reportsService.getScript(loc.getProjectKey(), loc.getId());
        }
        ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, this.reportsSnapshotsService.startCreate(report, script, authCtx));
    }

    @AuditedCall(value={"msgType", "report-snapshot-list", "projectKey", "${projectKey}", "reportId", "${reportId}"})
    @RequestMapping(value={"/api/reports/snapshots/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String reportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
        }
        List<ReportSnapshot> list = this.reportsSnapshotsService.listSorted_NT(projectKey, reportId);
        ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "reports-list"})
    @RequestMapping(value={"/api/reports/snapshots/list-for-all"})
    public void listForAll(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<AccessibleObjectsService.AccessibleObject> list;
        AuthCtx user;
        HashMap<String, List<ReportSnapshot>> snapshotsMap = new HashMap<String, List<ReportSnapshot>>();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            list = this.accessibleObjectsService.listAccessibleObjectsUnsafe(user, projectKey, ITaggingService.TaggableType.REPORT, SerializedProject.ReaderAuthorization.Mode.READ);
        }
        this.accessibleObjectsService.addKernelSpecInfo_NT(user, list);
        for (AccessibleObjectsService.AccessibleObject object : list) {
            snapshotsMap.put(object.smartId, this.reportsSnapshotsService.listSorted_NT(object.projectKey, object.id));
        }
        ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, snapshotsMap);
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "report-snapshot-view", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/snapshots/view"})
    public void view(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String timestamp, @RequestParam String format) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.REPORT, id);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
        }
        Report.ReportOutputFormat viewFormat = StringUtils.isBlank((String)format) ? null : this.parseFormat(format);
        Long t = this.parseTimestamp(timestamp);
        ReportSnapshot snapshot = new ReportSnapshot(ref.getProjectKey(projectKey), ref.objectId, t);
        if (viewFormat == null) {
            viewFormat = this.reportsSnapshotsService.findExistingFormatForBackwardsCompatibility(snapshot);
        }
        if (viewFormat == null) {
            logger.warn((Object)"Report snapshot not found");
            ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, (Object)this.getViewJSONError(EXPORT_NOT_FOUND));
            return;
        }
        logger.info((Object)("Get report snapshot for timestamp " + t));
        File viewFile = this.reportsSnapshotsService.getSnapshotOutputFile(snapshot, viewFormat);
        logger.info((Object)("File:" + viewFile.getAbsolutePath()));
        if (viewFile.exists()) {
            try (FileInputStream input = new FileInputStream(viewFile);){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)input, (OutputStream)bos);
                ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, (Object)new EncodedContent(bos.toByteArray(), viewFormat.getContentType()));
            }
        } else {
            logger.warn((Object)("Report snapshot not found: " + viewFile.getAbsolutePath()));
            ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, (Object)this.getViewJSONError(EXPORT_NOT_FOUND));
        }
    }

    private EncodedContent getViewJSONError(String err) {
        return new EncodedContent(err.getBytes(), "text/html");
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "report-snapshot-get", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/snapshots/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam(required=false) String timestamp) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.REPORT, id);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
        }
        long t2 = 0L;
        if (StringUtils.isNotBlank((String)timestamp)) {
            t2 = Long.parseLong(timestamp);
        }
        ReportSnapshot snapshot = null;
        try {
            snapshot = t2 == 0L ? this.reportsSnapshotsService.getLast_NT(ref.getProjectKey(projectKey), ref.objectId) : this.reportsSnapshotsService.getForTimestamp_NT(projectKey, id, t2);
        }
        catch (NotFoundException e) {
            logger.info((Object)("Report snapshot not found. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        if (snapshot == null) {
            throw ErrorContext.iaef((String)"No snapshot found for %s.%s", (Object)projectKey, (Object[])new Object[]{id});
        }
        ReportsSnapshotsController.writeJSON((HttpServletResponse)resp, (Object)snapshot);
    }

    @AuditedCall(value={"msgType", "report-snapshot-download", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/snapshots/download"})
    public void download(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam(required=false) String format) throws Exception {
        Report report;
        Insight insight;
        if (StringUtils.isBlank((String)format)) {
            throw new IllegalArgumentException("Invalid download format: " + format);
        }
        Report.ReportOutputFormat downloadFormat = this.parseFormat(format);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            insight = this.insightsService.getMandatoryUnsafe(projectKey, id);
            ReportInsightParams insightParams = insight.getParamsAs(ReportInsightParams.class);
            AnyLoc loc = AnyLoc.resolveSmart(insight.projectKey, insightParams.reportSmartId);
            report = this.reportsService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        }
        ReportSnapshot snapshot = this.reportsSnapshotsService.getSnapshotFromInsight_NT(insight);
        File file = this.reportsSnapshotsService.getSnapshotOutputFile(snapshot, downloadFormat);
        String downloadName = report.name + "." + downloadFormat.getExtension();
        this.writeFileForDownload(resp, file, downloadFormat.getContentType(), downloadName);
    }

    private Report.ReportOutputFormat parseFormat(String format) {
        try {
            return Report.ReportOutputFormat.valueOf(format);
        }
        catch (Exception e) {
            logger.info((Object)("Invalid view format: '" + format + "'. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw ErrorContext.iaef((String)"Invalid view format: %s. ", (Object)format, (Object[])new Object[0]);
        }
    }

    private Long parseTimestamp(String timestamp) {
        try {
            return Long.parseLong(timestamp);
        }
        catch (Exception e) {
            logger.info((Object)("Invalid timestamp: '" + timestamp + "'. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw ErrorContext.iaef((String)"Invalid timestamp: %s", (Object)timestamp, (Object[])new Object[0]);
        }
    }
}

