/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.python;

import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import com.dataiku.dip.server.datasets.renaming.code.python.ImportedScenarioClassParser;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DatasetBuildParser
implements RegexParser {
    private final String datasetNameRegex;
    private final String datasetNameReplacement;
    private final ImportedScenarioClassParser importedScenarioClassParser;
    private boolean matchesImportedScenarioClassParser;
    private Pattern scenarioInstancePattern;
    private Pattern datasetBuildPattern;
    private Matcher scenarioInstanceMatcher;
    private Matcher datasetBuildMatcher;
    private boolean matchesScenarioInstancePattern;
    private final Set<String> scenarioInstances;
    private int count;

    public DatasetBuildParser(String datasetNameRegex, String datasetNameReplacement) {
        this.datasetNameRegex = datasetNameRegex;
        this.datasetNameReplacement = datasetNameReplacement;
        this.scenarioInstances = new HashSet<String>();
        this.importedScenarioClassParser = new ImportedScenarioClassParser();
        this.compileScenarioInstancesPattern();
        this.compileDatasetBuildPattern();
    }

    private void compileScenarioInstancesPattern() {
        Set<String> scenarioClassNames = this.importedScenarioClassParser.getClassNames();
        this.scenarioInstancePattern = Pattern.compile(String.format("^(\\w++)\\s*+\\\\?\\s*+=\\s*+\\\\?\\s*+(?:%s)\\s*+\\\\?\\s*+\\(\\s*+\\\\?\\s*+\\)", String.join((CharSequence)"|", scenarioClassNames)));
    }

    private void compileDatasetBuildPattern() {
        this.datasetBuildPattern = Pattern.compile(String.format("^((?:%s)\\s*+\\\\?\\s*+\\.\\s*+\\\\?\\s*+build_dataset\\s*+\\\\?\\s*+\\(\\s*+\\\\?\\s*+)(?:\"%2$s\"|'%2$s')([^\\)]*+\\))", String.join((CharSequence)"|", this.scenarioInstances), this.datasetNameRegex));
    }

    @Override
    public boolean matches(String input) {
        this.matchesImportedScenarioClassParser = this.importedScenarioClassParser.matches(input);
        if (this.matchesImportedScenarioClassParser) {
            this.compileScenarioInstancesPattern();
            return true;
        }
        this.scenarioInstanceMatcher = this.scenarioInstancePattern.matcher(input);
        this.matchesScenarioInstancePattern = this.scenarioInstanceMatcher.find();
        if (this.matchesScenarioInstancePattern) {
            this.scenarioInstances.add(this.scenarioInstanceMatcher.group(1));
            this.compileDatasetBuildPattern();
            return true;
        }
        this.datasetBuildMatcher = this.datasetBuildPattern.matcher(input);
        if (this.datasetBuildMatcher.find()) {
            ++this.count;
            return true;
        }
        return false;
    }

    @Override
    public String getMatch() {
        if (this.matchesImportedScenarioClassParser) {
            return this.importedScenarioClassParser.getMatch();
        }
        if (this.matchesScenarioInstancePattern) {
            return this.scenarioInstanceMatcher.group(0);
        }
        return this.datasetBuildMatcher.group(0);
    }

    @Override
    public String getReplacement() {
        if (this.matchesImportedScenarioClassParser) {
            return this.importedScenarioClassParser.getReplacement();
        }
        if (this.matchesScenarioInstancePattern) {
            return this.scenarioInstanceMatcher.group(0);
        }
        return this.datasetBuildMatcher.pattern().matcher(this.datasetBuildMatcher.group(0)).replaceFirst(this.datasetNameReplacement);
    }

    @Override
    public int datasetReferences() {
        return this.count;
    }
}

