/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import java.util.Objects;

public class LoginEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "login";
    public final String user;
    public final String userDisplayName;

    LoginEvent(String user, String userDisplayName) {
        this.user = user;
        this.userDisplayName = userDisplayName;
    }

    public static LoginEvent withUsername(String username, String displayName) {
        return new LoginEvent(username, displayName);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return markup.user(this.user, this.userDisplayName) + " just logged-in";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginEvent that = (LoginEvent)o;
        return this.user.equals(that.user) && Objects.equals(this.userDisplayName, that.userDisplayName);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.userDisplayName);
    }

    public String toString() {
        return "LoginEvent{user='" + this.user + "', userDisplayName='" + this.userDisplayName + "'}";
    }
}

