/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.samples;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.samples.SnippetOrigin;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface SnippetsDAO {
    public void save(Snippet var1, String var2, AuthCtx var3) throws IOException;

    public List<Snippet> list(String var1, AuthCtx var2) throws IOException;

    public void delete(String var1, String var2) throws IOException;

    public static class Permission {
        @Nullable
        public String group;
        @Nullable
        public String user;
        public boolean isAdmin;
        public boolean canUpdate;
        public boolean canViewAndUse;

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Permission that = (Permission)o;
            return this.isAdmin == that.isAdmin && this.canUpdate == that.canUpdate && this.canViewAndUse == that.canViewAndUse && Objects.equals(this.group, that.group) && Objects.equals(this.user, that.user);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.user, this.isAdmin, this.canUpdate, this.canViewAndUse);
        }
    }

    public static class SnippetTag {
        String name;
        String color;
    }

    public static class SnippetVariation {
        String id;
        String title;
        String code;
    }

    public static class Snippet {
        String id;
        String title;
        String description;
        String documentation;
        List<SnippetVariation> variations;
        List<SnippetTag> tags;
        boolean isShared;
        String category;
        List<String> libraries = new ArrayList<String>();
        List<String> selectPanes;
        SnippetOrigin origin;
        String userCreation;
        String userEdition;
        long creationDate;
        long editionDate;
        private List<Permission> permissions;
        @JSON.FileTransient
        private Permission initialPermission;

        public List<Permission> getPermissions() {
            if (this.initialPermission == null) {
                this.initialPermission = new Permission();
                this.initialPermission.isAdmin = true;
                this.initialPermission.canUpdate = true;
                this.initialPermission.canViewAndUse = true;
                if (this.isShared) {
                    this.initialPermission.group = "$$ALL_USERS$$";
                } else {
                    this.initialPermission.user = this.userCreation;
                }
            }
            if (!(Snippet.isPermissionsFeatureFlagEnabled() || this.permissions == null || this.permissions.size() == 1 && Objects.equals(this.permissions.get(0), this.initialPermission))) {
                this.permissions = null;
            }
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>();
                this.permissions.add(this.initialPermission);
            }
            return this.permissions;
        }

        public void setPermissions(Collection<Permission> permissions) {
            if (Snippet.isPermissionsFeatureFlagEnabled()) {
                this.permissions = new ArrayList<Permission>(permissions);
            }
        }

        private static boolean isPermissionsFeatureFlagEnabled() {
            return FeatureFlags.isEnabled((String)"codeSamplesPermissions");
        }
    }
}

